/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.emf;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TreeIterator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtilities {
    public static IPath computeDeployPath(IFile sourceFile) {
        for (IVirtualFile virtualFile : CollectionTools.iterable(ComponentUtilities.allVirtualFiles(sourceFile.getProject()))) {
            IFile[] iFileArray = virtualFile.getUnderlyingFiles();
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile underlyingFile = iFileArray[n2];
                if (sourceFile.equals((Object)underlyingFile)) {
                    return virtualFile.getRuntimePath();
                }
                ++n2;
            }
        }
        return null;
    }

    private static Iterator<IVirtualFile> allVirtualFiles(IProject project) {
        return new FilteringIterator<IVirtualResource, IVirtualFile>(ComponentUtilities.allVirtualResources(project)){

            protected boolean accept(IVirtualResource o) {
                return o.getType() == 16;
            }
        };
    }

    private static Iterator<IVirtualResource> allVirtualResources(IProject project) {
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)project);
        if (virtualComponent == null) {
            return EmptyIterator.instance();
        }
        return new TreeIterator<IVirtualResource>((IVirtualResource)virtualComponent.getRootFolder()){

            protected Iterator<? extends IVirtualResource> children(IVirtualResource next) {
                if (next.getType() == 32) {
                    try {
                        return CollectionTools.iterator((Object[])((IVirtualFolder)next).members());
                    }
                    catch (CoreException coreException) {}
                }
                return EmptyIterator.instance();
            }
        };
    }
}

