/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.validation.DependentResource;
import org.eclipse.wst.validation.Friend;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.DisabledResourceManager;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.ResourceUnavailableError;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValBuilderJob
extends WorkspaceJob
implements IResourceDeltaVisitor,
IResourceVisitor {
    private static ValBuilderJob _job;
    private static Queue<ValidationRequest> _work;
    private IProgressMonitor _monitor;
    private SubMonitor _subMonitor;
    private ValidationRequest _request;
    private static final int InterestedFlags = 0x103100;

    static {
        _work = new LinkedList<ValidationRequest>();
    }

    public static synchronized void validateProject(IProject project, IResourceDelta delta, int buildKind, ValOperation operation) {
        ValidationRequest request = new ValidationRequest(project, delta, buildKind, operation);
        if (_job == null) {
            _job = new ValBuilderJob();
            _job.add(request);
            _job.schedule();
        } else {
            _job.add(request);
        }
    }

    private static synchronized ValidationRequest getRequest() {
        ValidationRequest request = _work.poll();
        if (request == null) {
            _job = null;
        }
        return request;
    }

    private ValBuilderJob() {
        super(ValMessages.JobName);
    }

    private void add(ValidationRequest request) {
        _work.add(request);
    }

    public boolean belongsTo(Object family) {
        if (family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
            return true;
        }
        if (family == ValidationBuilder.FAMILY_VALIDATION_JOB) {
            return true;
        }
        return super.belongsTo(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        Tracing.log("ValBuilderJob-01: Starting");
        this._monitor = monitor;
        ValidationRequest request = ValBuilderJob.getRequest();
        while (request != null) {
            this._request = request;
            this.run();
            request = ValBuilderJob.getRequest();
        }
        Tracing.log("ValBuilderJob-02: Finished");
        return Status.OK_STATUS;
    }

    private void run() {
        this.setName(String.valueOf(ValMessages.JobName) + " " + this._request.getProject().getName());
        try {
            if (this._request.getDelta() == null) {
                this.fullBuild();
            } else {
                this.deltaBuild();
            }
        }
        catch (ProjectUnavailableError e) {
            ValidationPlugin.getPlugin().handleProjectUnavailableError(e);
        }
        catch (ResourceUnavailableError e) {
            ValidationPlugin.getPlugin().handleResourceUnavailableError(e);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private void deltaBuild() throws CoreException {
        ResourceCounter counter = new ResourceCounter();
        this._request.getDelta().accept((IResourceDeltaVisitor)counter);
        this._subMonitor = SubMonitor.convert((IProgressMonitor)this._monitor, (int)counter.getCount());
        this._request.getDelta().accept((IResourceDeltaVisitor)this);
    }

    private void fullBuild() throws CoreException {
        ResourceCounter counter = new ResourceCounter();
        this._request.getProject().accept((IResourceProxyVisitor)counter, 0);
        this._subMonitor = SubMonitor.convert((IProgressMonitor)this._monitor, (int)counter.getCount());
        this._request.getProject().accept((IResourceVisitor)this);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IDependencyIndex index;
        boolean isChanged;
        IResource resource = delta.getResource();
        if (DisabledResourceManager.getDefault().isDisabled(resource)) {
            MarkerManager.getDefault().deleteMarkers(resource, this._request.getOperation().getStarted(), 2);
            return false;
        }
        int kind = delta.getKind();
        boolean bl = isChanged = (kind & 4) != 0;
        if (isChanged && (delta.getFlags() & 0x103100) == 0) {
            return true;
        }
        if ((kind & 5) != 0) {
            ValManager.getDefault().validate(this._request.getProject(), resource, delta.getKind(), ValType.Build, this._request.getBuildKind(), this._request.getOperation(), (IProgressMonitor)this._subMonitor.newChild(1));
        }
        if ((index = ValidationFramework.getDefault().getDependencyIndex()).isDependedOn(resource)) {
            MarkerManager mm = MarkerManager.getDefault();
            for (DependentResource dr : index.get(resource)) {
                if (!Friend.shouldValidate(dr.getValidator(), dr.getResource(), ValType.Build, new ContentTypeWrapper())) continue;
                mm.clearMarker(dr.getResource(), dr.getValidator());
                this._request.getOperation().getState().put("org.eclipse.wst.validation.Trigger", resource);
                ValManager.getDefault().validate(dr.getValidator(), this._request.getOperation(), dr.getResource(), 0, this._monitor);
            }
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        block4: {
            try {
                if (!DisabledResourceManager.getDefault().isDisabled(resource)) break block4;
                MarkerManager.getDefault().deleteMarkers(resource, this._request.getOperation().getStarted(), 2);
                return false;
            }
            catch (ResourceUnavailableError e) {
                if (Tracing.isLogging()) {
                    Tracing.log("ValBuilderJob-02: " + e.toString());
                }
                return false;
            }
        }
        ValManager.getDefault().validate(this._request.getProject(), resource, 0, ValType.Build, this._request.getBuildKind(), this._request.getOperation(), (IProgressMonitor)this._subMonitor.newChild(1));
        return true;
    }

    static class ResourceCounter
    implements IResourceProxyVisitor,
    IResourceDeltaVisitor {
        private int _count;

        ResourceCounter() {
        }

        public int getCount() {
            return this._count;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            ++this._count;
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            ++this._count;
            return true;
        }
    }

    static class ValidationRequest {
        private IProject _project;
        private IResourceDelta _delta;
        private ValOperation _operation;
        private int _buildKind;

        public ValidationRequest(IProject project, IResourceDelta delta, int buildKind, ValOperation operation) {
            this._project = project;
            this._delta = delta;
            this._buildKind = buildKind;
            this._operation = operation;
        }

        public IProject getProject() {
            return this._project;
        }

        public IResourceDelta getDelta() {
            return this._delta;
        }

        public ValOperation getOperation() {
            return this._operation;
        }

        public int getBuildKind() {
            return this._buildKind;
        }
    }
}

