/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValOperation {
    private ValidationState _state = new ValidationState();
    private ValidationResult _result = new ValidationResult();
    private Map<IProject, Set<Validator>> _suspended = Collections.synchronizedMap(new HashMap(40));
    private long _started = System.currentTimeMillis();
    private boolean _multiProject;
    private Map<String, Set<IResource>> _validated = new HashMap<String, Set<IResource>>(20);

    public ValidationState getState() {
        return this._state;
    }

    public void setState(ValidationState state) {
        this._state = state;
    }

    public ValidationResult getResult() {
        return this._result;
    }

    public void setResult(ValidationResult result) {
        this._result = result;
    }

    public ValidationResults getResults() {
        return new ValidationResults(this._result);
    }

    public void addValidated(String id, IResource resource) {
        Set<IResource> set = this._validated.get(id);
        if (set == null) {
            set = new HashSet<IResource>(20);
            this._validated.put(id, set);
        }
        set.add(resource);
    }

    public boolean isValidated(String id, IResource resource) {
        Set<IResource> set = this._validated.get(id);
        if (set == null) {
            return false;
        }
        return set.contains(resource);
    }

    public boolean isSuspended(Validator val, IProject project) {
        if (project == null) {
            return false;
        }
        Set<Validator> set = this.getSuspended(project);
        return set.contains(val);
    }

    private Set<Validator> getSuspended(IProject project) {
        Set<Validator> set = this._suspended.get(project);
        if (set == null) {
            set = new HashSet<Validator>(5);
            this._suspended.put(project, set);
        }
        return set;
    }

    void suspendValidation(IProject project, Validator validator) {
        if (project == null) {
            return;
        }
        this.getSuspended(project).add(validator);
    }

    public long getStarted() {
        return this._started;
    }

    public boolean isMultiProject() {
        return this._multiProject;
    }

    public void setMultiProject(boolean multiProject) {
        this._multiProject = multiProject;
    }
}

