/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDFactory;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.impl.DTDFactoryImpl;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDModelBuilder;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDPrinter;
import org.eclipse.wst.dtd.core.internal.emf.util.ExternalDTDModel;
import org.eclipse.wst.dtd.core.internal.saxparser.DTD;
import org.eclipse.wst.dtd.core.internal.saxparser.DTDParser;
import org.eclipse.wst.dtd.core.internal.saxparser.ErrorMessage;

public class DTDUtil {
    DTDFactory factory;
    EList extent;
    Resource resource;
    DTDFile dtdFile;
    String dtdModelFile;
    boolean expandEntityReferences;
    private Hashtable externalDTDModels = new Hashtable();
    private Hashtable pePool = new Hashtable();
    private Hashtable elementPool = new Hashtable();
    private DTDParser parser;
    private Vector errorMsgs = new Vector();
    private static Hashtable utilCache = new Hashtable();

    public static DTDUtil getDTDUtilFor(String filename) {
        DTDUtil util = (DTDUtil)utilCache.get(filename);
        if (util == null) {
            util = new DTDUtil();
            utilCache.put(filename, util);
        }
        return util;
    }

    public void parse(String uri) {
        this.parse((ResourceSet)new ResourceSetImpl(), uri);
    }

    public void parse(ResourceSet resources, String filename) {
        Path path = new Path(filename);
        IPath iPath = path.removeFileExtension();
        String dtdName = iPath.toFile().getName();
        try {
            this.parser = new DTDParser(false);
            if (this.expandEntityReferences) {
                this.parser.setExpandEntityReferences(this.expandEntityReferences);
            }
            this.parser.parse(filename);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        this.dtdModelFile = filename;
        this.factory = DTDFactoryImpl.instance();
        this.extent = new BasicEList();
        this.dtdFile = this.factory.createDTDFile();
        this.extent.add((Object)this.dtdFile);
        this.dtdFile.setName(dtdName);
        this.populateDTD(resources, this.expandEntityReferences);
    }

    public DTDFactory getFactory() {
        return this.factory;
    }

    public DTDFile getDTDFile() {
        return this.dtdFile;
    }

    public Hashtable getPEPool() {
        return this.pePool;
    }

    public Hashtable getElementPool() {
        return this.elementPool;
    }

    public EList getContents() {
        return this.extent;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource(Resource resource) {
        return resource;
    }

    public void setexpandEntityReferences(boolean expandEntityReferences) {
        this.expandEntityReferences = expandEntityReferences;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public boolean isModelDirty() {
        if (this.resource != null) {
            return this.resource.isModified();
        }
        return false;
    }

    public boolean save() {
        try {
            HashMap options = new HashMap();
            this.resource.save(options);
            return true;
        }
        catch (Exception ex) {
            System.out.println("Save model exception " + ex);
            ex.printStackTrace();
            return false;
        }
    }

    public boolean saveAs(String newFilename) {
        this.resource.setURI(URI.createURI((String)newFilename));
        boolean ok = this.save();
        if (ok) {
            Path path = new Path(newFilename);
            IPath iPath = path.removeFileExtension();
            String dtdName = iPath.toFile().getName();
            this.dtdFile.setName(dtdName);
        }
        return ok;
    }

    public boolean saveDTDFile(String filename) {
        boolean result = true;
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(filename), true);
            DTDPrinter printer = new DTDPrinter(true);
            printer.visitDTDFile(this.dtdFile);
            String s = printer.getBuffer().toString();
            pw.println(s);
            pw.close();
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    public String getDTDSource(boolean includeError) {
        return this.dtdFile.unparse(includeError);
    }

    private void populateDTD(ResourceSet resources, boolean expandEntityReferences) {
        Vector dtdList = this.parser.getDTDList();
        if (dtdList.size() > 0) {
            if (!expandEntityReferences) {
                int i = dtdList.size() - 1;
                while (i > 0) {
                    DTD dtd = (DTD)dtdList.elementAt(i);
                    this.loadIncludedDTD(resources, dtd);
                    --i;
                }
                DTD dtd = (DTD)dtdList.elementAt(0);
                this.populateDTD(resources, dtd, this.dtdFile);
            } else {
                int i = dtdList.size() - 1;
                while (i >= 0) {
                    DTD dtd = (DTD)dtdList.elementAt(i);
                    this.populateDTD(resources, dtd, this.dtdFile);
                    --i;
                }
            }
        }
    }

    public ExternalDTDModel getExternalDTDModel(ResourceSet resources, String uri) {
        if (this.expandEntityReferences) {
            return null;
        }
        if (this.externalDTDModels.containsKey(uri)) {
            return (ExternalDTDModel)this.externalDTDModels.get(uri);
        }
        ExternalDTDModel extModel = new ExternalDTDModel();
        if (extModel.loadModel(resources, uri)) {
            this.externalDTDModels.put(uri, extModel);
            return extModel;
        }
        return null;
    }

    private void loadIncludedDTD(ResourceSet resources, DTD dtd) {
        ExternalDTDModel extModel = this.getExternalDTDModel(resources, dtd.getName());
        if (extModel != null) {
            DTDFile file = extModel.getExternalDTDFile();
            List elementList = file.listDTDElement();
            List entityList = file.listDTDEntity();
            Iterator i = elementList.iterator();
            while (i.hasNext()) {
                DTDObject object = (DTDObject)i.next();
                this.elementPool.put(DTDUtil.getBaseName(object), object);
            }
            i = entityList.iterator();
            while (i.hasNext()) {
                DTDEntity entity = (DTDEntity)i.next();
                if (!entity.isParameterEntity()) continue;
                this.pePool.put(DTDUtil.getBaseName(entity), entity);
            }
        }
    }

    private void populateDTD(ResourceSet resources, DTD dtd, DTDFile dFile) {
        DTDModelBuilder modelBuilder = new DTDModelBuilder(resources, this, dtd, dFile);
        modelBuilder.visitDTD(dtd);
    }

    public void emptyErrorMessages() {
        this.errorMsgs.removeAllElements();
    }

    public void addErrorMessage(ErrorMessage error) {
        int vectorSize = this.errorMsgs.size();
        boolean add = true;
        if (vectorSize != 0) {
            int index = 0;
            while (add && index < vectorSize) {
                if (((ErrorMessage)this.errorMsgs.elementAt(index)).equals(error)) {
                    add = false;
                    continue;
                }
                ++index;
            }
        }
        if (add) {
            this.errorMsgs.addElement(error);
        }
    }

    public Vector getErrors() {
        return this.errorMsgs;
    }

    public static String getBaseName(DTDObject obj) {
        return DTDUtil.getName(obj, null);
    }

    public static String getName(DTDObject obj, DTDFile dtdFile) {
        String name = "";
        if (obj instanceof DTDEntity) {
            DTDEntity entity = (DTDEntity)obj;
            if (dtdFile != null && !entity.getDTDFile().equals(dtdFile)) {
                name = String.valueOf(new Path(entity.getDTDFile().getName()).lastSegment()) + ": ";
            }
            name = String.valueOf(name) + "%" + ((DTDEntity)obj).getName() + ";";
        } else if (obj instanceof DTDElement) {
            DTDElement element = (DTDElement)obj;
            if (dtdFile != null && !element.getDTDFile().equals(dtdFile)) {
                name = String.valueOf(new Path(element.getDTDFile().getName()).lastSegment()) + ": ";
            }
            name = String.valueOf(name) + ((DTDElement)obj).getName();
        } else if (obj instanceof DTDElementContent) {
            return ((DTDElementContent)obj).getContentName();
        }
        return name;
    }

    public static String getGroupType(int groupKind, int occurrence) {
        String type = null;
        switch (groupKind) {
            case 1: {
                type = "DTDSequence";
                break;
            }
            case 2: {
                type = "DTDChoice";
            }
        }
        type = String.valueOf(type) + DTDUtil.getRepeatableTypeSuffix(occurrence);
        return type;
    }

    public static String getReferenceType(int occurrence) {
        String type = "DTDReference";
        type = String.valueOf(type) + DTDUtil.getRepeatableTypeSuffix(occurrence);
        return type;
    }

    private static String getRepeatableTypeSuffix(int occurrence) {
        return "(" + (char)occurrence + ")";
    }

    public static void main(String[] args) {
        System.out.println("\nStarting ...");
        if (args.length != 1) {
            System.out.println("usage: DtdUtil inputfile.dtd");
        }
        File inputFile = new File(args[0]);
        String dtdFileName = "";
        try {
            dtdFileName = inputFile.getCanonicalPath();
        }
        catch (IOException iOException) {}
        String dtdModelName = dtdFileName;
        if ("dtd".equals(new Path(dtdFileName).getFileExtension())) {
            dtdModelName = new Path(dtdFileName).removeFileExtension().lastSegment();
        }
        DTDUtil d2m = new DTDUtil();
        try {
            d2m.saveAs(String.valueOf(dtdModelName) + "." + "dtd.xmi");
        }
        catch (Exception e) {
            System.out.println("Exception thrown during model save: " + e);
        }
        System.out.println("Done.");
    }

    public IPath getPath() {
        Path currentDTDPath = new Path(this.dtdModelFile);
        if (currentDTDPath.segmentCount() > 1) {
            return currentDTDPath.removeLastSegments(1).addTrailingSeparator();
        }
        return new Path("");
    }
}

