/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyModulesComposite
extends Composite {
    public static final String TASK_REFRESH_MODULES = "refresh-modules";
    private static final String ROOT = "root";
    protected static Color color;
    protected static Font font;
    protected IWizardHandle wizard;
    protected IServerAttributes server;
    protected IRuntime runtime;
    protected boolean runtimeDirty;
    protected Object refreshModules;
    protected Map<ChildModuleMapKey, IModule[]> childModuleMap = new HashMap<ChildModuleMapKey, IModule[]>();
    protected Map<IModule, IModule[]> parentModuleMap = new HashMap<IModule, IModule[]>();
    protected List<IModule> originalModules = new ArrayList<IModule>();
    protected List<IModule> modules = new ArrayList<IModule>();
    protected List<IModule> deployed = new ArrayList<IModule>();
    protected TreeViewer availableTreeViewer;
    protected TreeViewer deployedTreeViewer;
    protected Button add;
    protected Button addAll;
    protected Button remove;
    protected Button removeAll;
    protected TaskModel taskModel;
    protected IModule requiredModule;
    protected boolean isComplete = true;
    protected IModule[] requiredModules;
    protected Map<IModule, IStatus> errorMap;

    public ModifyModulesComposite(Composite parent, IWizardHandle wizard, IModule module) {
        super(parent, 0);
        this.wizard = wizard;
        this.requiredModule = module;
        wizard.setTitle(Messages.wizModuleTitle);
        wizard.setDescription(Messages.wizModuleDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("selectServer"));
        this.createControl();
    }

    public void setServer(IServerAttributes server) {
        IModule[] children;
        IModule[] modules2;
        IRuntimeWorkingCopy wc;
        if (this.isVisible()) {
            return;
        }
        if (this.refreshModules == this.taskModel.getObject(TASK_REFRESH_MODULES) && server == this.server) {
            if (server == null) {
                return;
            }
            if (this.runtime == server.getRuntime()) {
                if (this.runtime == null) {
                    return;
                }
                if (this.runtime instanceof IRuntimeWorkingCopy) {
                    wc = (IRuntimeWorkingCopy)this.runtime;
                    if (wc.isDirty() == this.runtimeDirty) {
                        return;
                    }
                } else {
                    return;
                }
            }
        }
        this.refreshModules = this.taskModel.getObject(TASK_REFRESH_MODULES);
        this.server = server;
        this.runtime = server == null ? null : server.getRuntime();
        this.runtimeDirty = false;
        if (this.runtime != null && this.runtime instanceof IRuntimeWorkingCopy && (wc = (IRuntimeWorkingCopy)this.runtime).isDirty()) {
            this.runtimeDirty = true;
        }
        this.originalModules = new ArrayList<IModule>();
        this.deployed = new ArrayList<IModule>();
        this.modules = new ArrayList<IModule>();
        this.childModuleMap = new HashMap<ChildModuleMapKey, IModule[]>();
        if (server == null) {
            return;
        }
        System.setProperty("J2EEcache", "" + Math.random());
        IModule[] currentModules = server.getModules();
        if (currentModules != null) {
            int size = currentModules.length;
            int i = 0;
            while (i < size) {
                this.originalModules.add(currentModules[i]);
                this.deployed.add(currentModules[i]);
                ++i;
            }
        }
        this.requiredModules = null;
        this.errorMap = new HashMap<IModule, IStatus>();
        if (this.requiredModule != null) {
            try {
                IModule[] parents = server.getRootModules(this.requiredModule, null);
                this.requiredModules = parents != null && parents.length > 0 ? parents : new IModule[]{this.requiredModule};
            }
            catch (CoreException ce) {
                Trace.trace((byte)1, "A possible server implementation error", ce);
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not find root module", e);
            }
        }
        if (this.requiredModules != null && !this.deployed.contains(this.requiredModules[0])) {
            this.deployed.add(this.requiredModules[0]);
        }
        if ((modules2 = ServerUtil.getModules((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes())) != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IModule module = modules2[i];
                if (!this.deployed.contains(module)) {
                    try {
                        IModule[] parents = server.getRootModules(module, null);
                        if (parents != null) {
                            int size2 = parents.length;
                            int j = 0;
                            while (j < size2) {
                                if (parents[j].equals(module)) {
                                    IStatus status = server.canModifyModules(new IModule[]{module}, null, null);
                                    if (status != null && !status.isOK()) {
                                        this.errorMap.put(module, status);
                                    }
                                    this.modules.add(module);
                                }
                                ++j;
                            }
                        }
                    }
                    catch (CoreException ce) {
                        this.errorMap.put(module, ce.getStatus());
                        this.modules.add(module);
                    }
                }
                ++i;
            }
        }
        for (IModule module : this.deployed) {
            try {
                children = server.getChildModules(new IModule[]{module}, null);
                if (children == null || children.length <= 0) continue;
                this.childModuleMap.put(new ChildModuleMapKey(module), children);
            }
            catch (Exception exception) {}
        }
        for (IModule module : this.modules) {
            try {
                children = server.getChildModules(new IModule[]{module}, null);
                if (children == null || children.length <= 0) continue;
                this.childModuleMap.put(new ChildModuleMapKey(module), children);
            }
            catch (Exception exception) {}
        }
        Iterator<ChildModuleMapKey> iterator2 = this.childModuleMap.keySet().iterator();
        ArrayList<ChildModuleMapKey> list = new ArrayList<ChildModuleMapKey>();
        while (iterator2.hasNext()) {
            list.add(iterator2.next());
        }
        for (ChildModuleMapKey key : list) {
            IModule[] children0 = this.childModuleMap.get(key);
            if (children0 == null) continue;
            int size = children0.length;
            int i = 0;
            while (i < size) {
                int size2 = key.moduleTree.length;
                IModule[] module2 = new IModule[size2 + 1];
                System.arraycopy(key.moduleTree, 0, module2, 0, size2);
                module2[size2] = children0[i];
                try {
                    IModule[] children2 = server.getChildModules(module2, null);
                    if (children2 != null && children2.length > 0) {
                        this.childModuleMap.put(new ChildModuleMapKey(module2), children2);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        System.setProperty("J2EEcache", "");
        this.updateTaskModel();
    }

    public void setVisible(boolean b) {
        if (b) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (ModifyModulesComposite.this.availableTreeViewer == null || ModifyModulesComposite.this.availableTreeViewer.getControl().isDisposed()) {
                        return;
                    }
                    try {
                        ModifyModulesComposite.this.availableTreeViewer.refresh();
                        ModifyModulesComposite.this.deployedTreeViewer.refresh();
                        ModifyModulesComposite.this.setEnablement();
                    }
                    catch (Exception exception) {}
                }
            });
        }
        super.setVisible(b);
    }

    public void setTaskModel(TaskModel model) {
        this.taskModel = model;
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.setFont(this.getParent().getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.wst.server.ui.swmm0000");
        Display display = this.getDisplay();
        color = display.getSystemColor(16);
        FontData[] fd = this.getFont().getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setStyle(2);
            ++i;
        }
        font = new Font((Device)display, fd);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        Label label = new Label((Composite)this, 0);
        GridData data = new GridData(770);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        label.setText(Messages.wizModuleMessage);
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizModuleAvailableList);
        label = new Label((Composite)this, 0);
        label.setText("");
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizModuleDeployedList);
        Tree availableTree = new Tree((Composite)this, 2050);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 150;
        availableTree.setLayoutData((Object)data);
        this.availableTreeViewer = new TreeViewer(availableTree);
        ILabelProvider labelProvider = ServerUICore.getLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    ModifyModulesComposite.this.availableTreeViewer.refresh(true);
                } else {
                    obj = ServerUIPlugin.adaptLabelChangeObjects(obj);
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        ModifyModulesComposite.this.availableTreeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.availableTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.availableTreeViewer.setContentProvider((IContentProvider)new AvailableContentProvider());
        this.availableTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ModuleServer && e2 instanceof ModuleServer) {
                    ModuleServer s1 = (ModuleServer)e1;
                    ModuleServer s2 = (ModuleServer)e2;
                    return s1.module[s1.module.length - 1].getName().compareToIgnoreCase(s2.module[s2.module.length - 1].getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.availableTreeViewer.setInput((Object)ROOT);
        this.availableTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModifyModulesComposite.this.setEnablement();
            }
        });
        this.availableTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModifyModulesComposite.this.setEnablement();
                if (ModifyModulesComposite.this.add.isEnabled()) {
                    ModifyModulesComposite.this.add(false);
                }
            }
        });
        Composite comp = new Composite((Composite)this, 0);
        data = new GridData(1808);
        data.widthHint = 120;
        comp.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 25;
        layout.verticalSpacing = 20;
        comp.setLayout((Layout)layout);
        this.add = new Button(comp, 8);
        this.add.setText(Messages.wizModuleAdd);
        this.add.setLayoutData((Object)new GridData(768));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.add(false);
            }
        });
        this.remove = new Button(comp, 8);
        this.remove.setText(Messages.wizModuleRemove);
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.remove(false);
            }
        });
        label = new Label(comp, 0);
        label.setText("");
        this.addAll = new Button(comp, 8);
        this.addAll.setText(Messages.wizModuleAddAll);
        this.addAll.setLayoutData((Object)new GridData(768));
        this.addAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.add(true);
            }
        });
        this.removeAll = new Button(comp, 8);
        this.removeAll.setText(Messages.wizModuleRemoveAll);
        this.removeAll.setLayoutData((Object)new GridData(768));
        this.removeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.remove(true);
            }
        });
        Tree deployedTree = new Tree((Composite)this, 2050);
        data = new GridData(1808);
        data.widthHint = 150;
        deployedTree.setLayoutData((Object)data);
        this.deployedTreeViewer = new TreeViewer(deployedTree){

            public void doUpdateItem(Widget widget, Object element, boolean fullMap) {
                if (widget instanceof TreeItem && color != null) {
                    TreeItem item = (TreeItem)widget;
                    if (element instanceof ModuleServer) {
                        ModuleServer ms = (ModuleServer)element;
                        IModule m = ms.module[ms.module.length - 1];
                        if (m.isExternal()) {
                            item.setForeground(color);
                        } else {
                            item.setForeground(null);
                        }
                        if (!(ModifyModulesComposite.this.server instanceof IServer) || ((IServer)ModifyModulesComposite.this.server).getModulePublishState(ms.module) != 1) {
                            item.setFont(font);
                        } else {
                            item.setFont(null);
                        }
                    }
                }
                super.doUpdateItem(widget, element, fullMap);
            }
        };
        labelProvider = ServerUICore.getLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    ModifyModulesComposite.this.deployedTreeViewer.refresh(true);
                } else {
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        ModifyModulesComposite.this.deployedTreeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.deployedTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.deployedTreeViewer.setContentProvider((IContentProvider)new DeployedContentProvider());
        this.deployedTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ModuleServer && e2 instanceof ModuleServer) {
                    ModuleServer s1 = (ModuleServer)e1;
                    ModuleServer s2 = (ModuleServer)e2;
                    return s1.module[s1.module.length - 1].getName().compareToIgnoreCase(s2.module[s2.module.length - 1].getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.deployedTreeViewer.setInput((Object)ROOT);
        this.deployedTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModifyModulesComposite.this.setEnablement();
            }
        });
        this.deployedTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModifyModulesComposite.this.setEnablement();
                if (ModifyModulesComposite.this.remove.isEnabled()) {
                    ModifyModulesComposite.this.remove(false);
                }
            }
        });
        this.setEnablement();
        availableTree.setFocus();
        Dialog.applyDialogFont((Control)this);
    }

    protected ModuleServer[] getAvailableSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.availableTreeViewer.getSelection();
        if (sel.isEmpty()) {
            return new ModuleServer[0];
        }
        ModuleServer[] mss = new ModuleServer[sel.size()];
        System.arraycopy(sel.toArray(), 0, mss, 0, sel.size());
        return mss;
    }

    protected ModuleServer[] getDeployedSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.deployedTreeViewer.getSelection();
        if (sel.isEmpty()) {
            return new ModuleServer[0];
        }
        ModuleServer[] mss = new ModuleServer[sel.size()];
        System.arraycopy(sel.toArray(), 0, mss, 0, sel.size());
        return mss;
    }

    protected static IModule getModule(ModuleServer ms) {
        if (ms == null) {
            return null;
        }
        IModule[] modules2 = ms.module;
        return modules2[modules2.length - 1];
    }

    protected static IModule[] getModules(ModuleServer[] ms) {
        if (ms == null) {
            return null;
        }
        IModule[] modules2 = new IModule[ms.length];
        int i = 0;
        while (i < ms.length) {
            modules2[i] = ModifyModulesComposite.getModule(ms[i]);
            ++i;
        }
        return modules2;
    }

    protected void setEnablement() {
        IModule module;
        boolean enabled;
        ModuleServer[] ms;
        int i;
        this.wizard.setMessage(null, 0);
        int count = 0;
        if (this.requiredModules != null) {
            int size = this.requiredModules.length;
            int i2 = 0;
            while (i2 < size) {
                if (this.deployed.contains(this.requiredModules[i2])) {
                    ++count;
                }
                ++i2;
            }
        }
        this.isComplete = true;
        if (this.requiredModules != null && this.requiredModules.length > 1 && count == 0) {
            String s = "";
            int size = this.requiredModules.length;
            i = 0;
            while (i < size) {
                if (i > 0) {
                    s = String.valueOf(s) + " | ";
                }
                s = String.valueOf(s) + this.requiredModules[i].getName();
                ++i;
            }
            this.wizard.setMessage(NLS.bind((String)Messages.wizModuleRequiredModules, (Object)s), 3);
            this.isComplete = false;
        }
        if ((ms = this.getAvailableSelection()) == null || ms.length == 0) {
            this.add.setEnabled(false);
        } else {
            enabled = false;
            i = 0;
            while (i < ms.length) {
                block29: {
                    module = ModifyModulesComposite.getModule(ms[i]);
                    if (module != null) {
                        try {
                            IStatus status = this.errorMap.get(module);
                            if (this.modules.contains(module)) {
                                if (status == null) {
                                    enabled = true;
                                } else {
                                    if (status.getSeverity() == 4) {
                                        enabled = false;
                                        this.wizard.setMessage(status.getMessage(), 3);
                                        break;
                                    }
                                    if (status.getSeverity() == 2) {
                                        enabled = true;
                                        this.wizard.setMessage(status.getMessage(), 2);
                                    } else if (status.getSeverity() == 1) {
                                        enabled = true;
                                        this.wizard.setMessage(status.getMessage(), 1);
                                    }
                                }
                                break block29;
                            }
                            enabled = false;
                            break;
                        }
                        catch (Exception exception) {
                            Trace.trace((byte)1, "Unable to handle error map for module:" + module);
                        }
                    }
                }
                ++i;
            }
            this.add.setEnabled(enabled);
        }
        this.addAll.setEnabled(this.modules.size() > 0);
        ms = this.getDeployedSelection();
        if (ms == null || ms.length == 0) {
            this.remove.setEnabled(false);
        } else {
            enabled = false;
            i = 0;
            while (i < ms.length) {
                module = ModifyModulesComposite.getModule(ms[i]);
                if (module != null && this.deployed.contains(module)) {
                    if (this.requiredModules != null) {
                        if (this.requiredModules.length == 1 && this.requiredModules[0].equals(module)) {
                            this.wizard.setMessage(NLS.bind((String)Messages.wizModuleRequiredModule, (Object)module.getName()), 3);
                            enabled = false;
                            break;
                        }
                    } else {
                        enabled = true;
                    }
                } else {
                    enabled = false;
                    break;
                }
                ++i;
            }
            this.remove.setEnabled(enabled);
        }
        if (this.requiredModules == null) {
            this.removeAll.setEnabled(this.deployed.size() > 0);
        } else {
            this.removeAll.setEnabled(this.deployed.size() > 1);
        }
    }

    protected void add(boolean all) {
        if (all) {
            IModule[] modules2 = new IModule[this.modules.size()];
            this.modules.toArray(modules2);
            this.moveAll(modules2, true);
        } else {
            this.moveAll(ModifyModulesComposite.getModules(this.getAvailableSelection()), true);
        }
        this.updateTaskModel();
    }

    protected void remove(boolean all) {
        if (all) {
            IModule keep = null;
            if (this.requiredModules != null) {
                int size2 = this.requiredModules.length;
                int i = 0;
                while (i < size2) {
                    if (keep == null && this.deployed.contains(this.requiredModules[i])) {
                        keep = this.requiredModules[i];
                    }
                    ++i;
                }
            }
            ArrayList<IModule> list = new ArrayList<IModule>();
            list.addAll(this.deployed);
            list.remove(keep);
            IModule[] modules2 = new IModule[list.size()];
            list.toArray(modules2);
            this.moveAll(modules2, false);
        } else {
            this.moveAll(ModifyModulesComposite.getModules(this.getDeployedSelection()), false);
        }
        this.updateTaskModel();
    }

    protected void moveAll(IModule[] mods, boolean add2) {
        int size = mods.length;
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < size) {
            IStatus status = this.errorMap.get(mods[i]);
            if (status == null && !list.contains(mods[i])) {
                list.add(mods[i]);
            }
            ++i;
        }
        for (IModule module : list) {
            ModuleServer ms = new ModuleServer(null, new IModule[]{module});
            if (add2) {
                this.modules.remove(module);
                this.deployed.add(module);
                this.availableTreeViewer.remove((Object)ms);
                this.deployedTreeViewer.add((Object)ROOT, (Object)ms);
                continue;
            }
            this.modules.add(module);
            this.deployed.remove(module);
            this.availableTreeViewer.add((Object)ROOT, (Object)ms);
            this.deployedTreeViewer.remove((Object)ms);
        }
        this.setEnablement();
    }

    protected void updateTaskModel() {
        if (this.taskModel == null) {
            return;
        }
        this.taskModel.putObject("modules", (Object)this.getModuleMap());
        this.wizard.update();
    }

    public List<IModule> getModulesToRemove() {
        ArrayList<IModule> list = new ArrayList<IModule>();
        for (IModule module : this.originalModules) {
            if (this.deployed.contains(module)) continue;
            list.add(module);
        }
        return list;
    }

    public List<IModule> getModulesToAdd() {
        ArrayList<IModule> list = new ArrayList<IModule>();
        for (IModule module : this.deployed) {
            if (this.originalModules.contains(module)) continue;
            list.add(module);
        }
        return list;
    }

    private void addChildMap(List<IModule[]> map, IModule[] parents, IModule[] children) {
        if (children == null) {
            return;
        }
        int size = children.length;
        int i = 0;
        while (i < size) {
            IModule module = children[i];
            int size2 = parents.length;
            IModule[] modules2 = new IModule[size2 + 1];
            System.arraycopy(parents, 0, modules2, 0, size2);
            modules2[size2] = module;
            map.add(modules2);
            IModule[] children2 = this.childModuleMap.get(new ChildModuleMapKey(module));
            if (children2 != null) {
                this.addChildMap(map, modules2, children2);
            }
            ++i;
        }
    }

    public List getModuleMap() {
        ArrayList<IModule[]> map = new ArrayList<IModule[]>();
        for (IModule module : this.deployed) {
            IModule[] moduleTree = new IModule[]{module};
            map.add(moduleTree);
            IModule[] children = this.childModuleMap.get(new ChildModuleMapKey(module));
            if (children == null) continue;
            this.addChildMap(map, moduleTree, children);
        }
        return map;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    class AvailableContentProvider
    extends TreeContentProvider {
        AvailableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<ModuleServer> list = new ArrayList<ModuleServer>();
            for (IModule module : ModifyModulesComposite.this.modules) {
                list.add(new ModuleServer(null, new IModule[]{module}));
            }
            return list.toArray();
        }
    }

    protected class ChildModuleMapKey {
        protected IModule[] moduleTree;

        protected ChildModuleMapKey(IModule curModule) {
            if (curModule != null) {
                this.moduleTree = new IModule[]{curModule};
            }
        }

        protected ChildModuleMapKey(IModule[] curModuleTree) {
            this.moduleTree = curModuleTree;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ChildModuleMapKey)) {
                return false;
            }
            IModule[] curCompareModule = ((ChildModuleMapKey)obj).moduleTree;
            if (curCompareModule == this.moduleTree) {
                return true;
            }
            if (this.moduleTree == null || curCompareModule == null || this.moduleTree.length != curCompareModule.length) {
                return false;
            }
            int i = 0;
            while (i < curCompareModule.length) {
                if (!curCompareModule[i].equals(this.moduleTree[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return 12345;
        }
    }

    class DeployedContentProvider
    extends TreeContentProvider {
        DeployedContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<ModuleServer> list = new ArrayList<ModuleServer>();
            for (IModule module : ModifyModulesComposite.this.deployed) {
                list.add(new ModuleServer(null, new IModule[]{module}));
            }
            return list.toArray();
        }
    }

    abstract class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            ModuleServer ms = (ModuleServer)parentElement;
            IModule[] parent = ms.module;
            IModule[] children = ModifyModulesComposite.this.childModuleMap.get(new ChildModuleMapKey(parent));
            ArrayList<ModuleServer> list = new ArrayList<ModuleServer>();
            if (children != null) {
                int size = children.length;
                int i = 0;
                while (i < size) {
                    IModule child = children[i];
                    ModifyModulesComposite.this.parentModuleMap.put(child, parent);
                    int size2 = parent.length;
                    IModule[] module2 = new IModule[size2 + 1];
                    System.arraycopy(parent, 0, module2, 0, size2);
                    module2[size2] = child;
                    list.add(new ModuleServer(null, module2));
                    ++i;
                }
            }
            return list.toArray();
        }

        public Object getParent(Object element) {
            ModuleServer ms = (ModuleServer)element;
            IModule[] child = ms.module;
            IModule[] modules2 = ModifyModulesComposite.this.parentModuleMap.get(child);
            if (modules2 == null) {
                return null;
            }
            return new ModuleServer(null, modules2);
        }

        public boolean hasChildren(Object element) {
            ModuleServer ms = (ModuleServer)element;
            IModule[] parent = ms.module;
            IModule[] children = ModifyModulesComposite.this.childModuleMap.get(new ChildModuleMapKey(parent));
            return children != null && children.length > 0;
        }
    }
}

