/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.ui.internal;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DTPUiTools {
    private static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";

    public static String createNewProfile() {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                CPWizardNode wizardNode = (CPWizardNode)element;
                if (!(wizardNode.getProvider() instanceof IWizardCategoryProvider)) {
                    ICategory cat = ConnectionProfileManager.getInstance().getProvider(((ProfileWizardProvider)wizardNode.getProvider()).getProfile()).getCategory();
                    while (cat != null) {
                        if (cat.getId().equals(DTPUiTools.DATABASE_CATEGORY_ID)) {
                            return true;
                        }
                        cat = cat.getParent();
                    }
                }
                return false;
            }
        };
        NewCPWizard wizard = new NewCPWizard(viewerFilter, null);
        Shell currentShell = Display.getCurrent().getActiveShell();
        WizardDialog wizardDialog = new WizardDialog(currentShell, (IWizard)wizard);
        wizardDialog.setBlockOnOpen(true);
        LocalProfileListener listener = new LocalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (wizardDialog.open() == 1) {
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            return null;
        }
        IConnectionProfile addedProfile = listener.addedProfile;
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        return addedProfile.getName();
    }

    static class LocalProfileListener
    implements IProfileListener {
        IConnectionProfile addedProfile;

        LocalProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.addedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }
}

