/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveComponentFromEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.AvailableJ2EEComponentsForEARContentProvider;
import org.eclipse.jst.j2ee.internal.IJ2EEDependenciesControl;
import org.eclipse.jst.j2ee.internal.J2EEDependenciesPage;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.SecondCheckBoxStateChangedEvent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.dialogs.ChangeLibDirDialog;
import org.eclipse.jst.j2ee.internal.dialogs.DependencyConflictResolveDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.ui.DoubleCheckboxTableItem;
import org.eclipse.jst.j2ee.internal.ui.DoubleCheckboxTableViewer;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.EarFacetRuntimeHandler;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.jee.project.facet.EarCreateDeploymentFilesDataModelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphManager;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class AddModulestoEARPropertiesPage
implements IJ2EEDependenciesControl,
Listener {
    protected final IProject project;
    protected final J2EEDependenciesPage propPage;
    protected IVirtualComponent earComponent = null;
    protected Text componentNameText;
    protected Label availableModules;
    protected CheckboxTableViewer availableComponentsViewer;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Button projectJarButton;
    protected Button externalJarButton;
    protected Button addVariableButton;
    protected Button changeLibPathButton;
    protected Composite buttonColumn;
    protected String libDir = null;
    protected String oldLibDir;
    protected List j2eeComponentList = new ArrayList();
    protected List javaProjectsList = new ArrayList();
    protected List j2eeLibElementList = new ArrayList();
    protected List javaLibProjectsList = new ArrayList();
    protected static final IStatus OK_STATUS = IDataModelProvider.OK_STATUS;
    protected boolean isVersion5;
    protected Set libsToUncheck;
    protected List<IVirtualComponent> addedJARComponents = new ArrayList<IVirtualComponent>();

    public AddModulestoEARPropertiesPage(IProject project, J2EEDependenciesPage page) {
        String earDDVersion;
        this.project = project;
        this.propPage = page;
        this.earComponent = ComponentCore.createComponent((IProject)project);
        boolean hasEE5Facet = false;
        try {
            IProjectFacetVersion facetVersion;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null && (facetVersion = facetedProject.getProjectFacetVersion(EarUtilities.ENTERPRISE_APPLICATION_FACET)).equals(EarUtilities.ENTERPRISE_APPLICATION_50)) {
                hasEE5Facet = true;
            }
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        if (hasEE5Facet && (earDDVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project)).equals("5.0")) {
            this.isVersion5 = true;
            Application app = (Application)ModelProviderManager.getModelProvider((IProject)project).getModelObject();
            if (app != null) {
                this.oldLibDir = app.getLibraryDirectory();
            }
            if (this.oldLibDir == null) {
                this.oldLibDir = "/lib";
            }
            this.libDir = this.oldLibDir;
        }
        this.libsToUncheck = new HashSet();
    }

    public Composite createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        J2EEDependenciesPage.createDescriptionComposite(composite, ManifestUIResourceHandler.EAR_Modules_Desc);
        this.createListGroup(composite);
        this.refresh();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableModules = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableModules.setText(J2EEUIMessages.getResourceString("AVAILABLE_J2EE_COMPONENTS"));
        this.availableModules.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    public boolean performOk() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (this.isVersion5) {
            if (this.libDir.length() == 0) {
                MessageDialog dlg = new MessageDialog(null, J2EEUIMessages.getResourceString("BLANK_LIB_DIR"), null, J2EEUIMessages.getResourceString("BLANK_LIB_DIR_WARN_QUESTION"), 3, new String[]{J2EEUIMessages.YES_BUTTON, J2EEUIMessages.NO_BUTTON, J2EEUIMessages.CANCEL_BUTTON}, 1);
                switch (dlg.open()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.handleChangeLibDirButton(false);
                        return false;
                    }
                    case 2: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.updateLibDir((IProgressMonitor)monitor);
        }
        this.removeModulesFromEAR((IProgressMonitor)monitor);
        this.addModulesToEAR((IProgressMonitor)monitor);
        this.refresh();
        return true;
    }

    public void performDefaults() {
    }

    public boolean performCancel() {
        return true;
    }

    public void dispose() {
    }

    public void setVisible(boolean visible) {
    }

    private List newJ2EEModulesToAdd(boolean inLibFolder) {
        List comps;
        if (inLibFolder && !this.isVersion5) {
            return null;
        }
        ArrayList<IVirtualComponent> newComps = new ArrayList<IVirtualComponent>();
        List list = comps = inLibFolder ? this.j2eeLibElementList : this.j2eeComponentList;
        if (comps != null && !comps.isEmpty()) {
            int i = 0;
            while (i < comps.size()) {
                IVirtualComponent handle = (IVirtualComponent)comps.get(i);
                if (!ClasspathDependencyUtil.isClasspathComponentDependency((IVirtualComponent)handle) && !this.inEARAlready(handle)) {
                    newComps.add(handle);
                }
                ++i;
            }
        }
        return newComps;
    }

    private void updateLibDir(IProgressMonitor monitor) {
        if (this.libDir.equals(this.oldLibDir)) {
            return;
        }
        IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)this.project);
        final Application app = (Application)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
        this.oldLibDir = app.getLibraryDirectory();
        if (this.oldLibDir == null) {
            this.oldLibDir = "/lib";
        }
        earModel.modify(new Runnable(){

            public void run() {
                app.setLibraryDirectory(AddModulestoEARPropertiesPage.this.libDir);
            }
        }, null);
    }

    protected void createDD(IProgressMonitor monitor) {
        if (this.earComponent != null) {
            IDataModelOperation op = this.generateEARDDOperation();
            try {
                op.execute(monitor, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    private void execAddOp(IProgressMonitor monitor, List componentList, String path) throws CoreException {
        IStatus stat;
        if (componentList == null || componentList.isEmpty()) {
            return;
        }
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.earComponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)componentList);
        HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
        int i = 0;
        while (i < componentList.size()) {
            IVirtualComponent virtComp = (IVirtualComponent)componentList.get(i);
            String virtCompURIMapName = this.getVirtualComponentNameWithExtension(virtComp);
            uriMap.put(virtComp, virtCompURIMapName);
            ++i;
        }
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        if (this.isVersion5) {
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)path);
        }
        if ((stat = dm.validateProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT")) != OK_STATUS) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    private void execAddOp1(IProgressMonitor monitor, List jProjList, List j2eeCompList, String path) throws CoreException {
        if (!jProjList.isEmpty()) {
            HashSet<IProject> moduleProjects = new HashSet<IProject>();
            int i = 0;
            while (i < jProjList.size()) {
                try {
                    IProject proj = (IProject)jProjList.get(i);
                    moduleProjects.add(proj);
                    IDataModel migrationdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
                    migrationdm.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)proj.getName());
                    migrationdm.getDefaultOperation().execute(monitor, null);
                    IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
                    List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    IVirtualComponent targetcomponent = ComponentCore.createComponent((IProject)proj);
                    targetCompList.add(targetcomponent);
                    refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.earComponent);
                    refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
                    if (this.isVersion5) {
                        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)path);
                    }
                    ((Map)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP")).put(targetcomponent, String.valueOf(proj.getName().replace(' ', '_')) + ".jar");
                    refdm.getDefaultOperation().execute(monitor, null);
                    j2eeCompList.add(targetcomponent);
                }
                catch (ExecutionException e) {
                    Logger.getLogger().log((Throwable)e);
                }
                ++i;
            }
            EarFacetRuntimeHandler.updateModuleProjectRuntime((IProject)this.earComponent.getProject(), moduleProjects, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private IStatus addModulesToEAR(IProgressMonitor monitor) {
        try {
            if (this.earComponent != null) {
                boolean shouldBndRun;
                final List list = this.newJ2EEModulesToAdd(false);
                final List bndList = this.newJ2EEModulesToAdd(true);
                final boolean shouldRun = list != null && !list.isEmpty() || !this.javaProjectsList.isEmpty();
                boolean bl = shouldBndRun = this.isVersion5 && (bndList != null && !bndList.isEmpty() || !this.javaLibProjectsList.isEmpty());
                if (shouldRun || shouldBndRun) {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            if (shouldRun) {
                                AddModulestoEARPropertiesPage.this.execAddOp(monitor, list, "/");
                                AddModulestoEARPropertiesPage.this.execAddOp1(monitor, AddModulestoEARPropertiesPage.this.javaProjectsList, AddModulestoEARPropertiesPage.this.j2eeComponentList, "/");
                            }
                            if (shouldBndRun) {
                                AddModulestoEARPropertiesPage.this.execAddOp(monitor, bndList, AddModulestoEARPropertiesPage.this.libDir);
                                AddModulestoEARPropertiesPage.this.execAddOp1(monitor, AddModulestoEARPropertiesPage.this.javaLibProjectsList, AddModulestoEARPropertiesPage.this.j2eeLibElementList, AddModulestoEARPropertiesPage.this.libDir);
                            }
                        }
                    };
                    J2EEUIPlugin.getWorkspace().run(runnable, monitor);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().log((Throwable)e);
        }
        this.addedJARComponents.clear();
        return OK_STATUS;
    }

    private void remComps(List list, String path) {
        if (!list.isEmpty()) {
            try {
                Map dependentComps = this.getEARModuleDependencies(this.earComponent, list);
                IDataModelOperation op = this.removeComponentFromEAROperation(this.earComponent, list, path);
                op.execute(null, null);
                J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(this.earComponent.getProject());
                this.removeEARComponentDependencies(dependentComps);
            }
            catch (ExecutionException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    private IStatus removeModulesFromEAR(IProgressMonitor monitor) {
        IStatus stat = OK_STATUS;
        if (!this.isVersion5) {
            if (this.earComponent != null && this.j2eeComponentList != null) {
                List list = this.getComponentsToRemove();
                this.remComps(list, "/");
            }
        } else if (this.earComponent != null && this.j2eeComponentList != null) {
            List[] list = this.getComponentsToRemoveUpdate(!this.libDir.equals(this.oldLibDir));
            this.remComps(list[0], "/");
            this.remComps(list[1], this.oldLibDir);
        }
        return stat;
    }

    private Map getEARModuleDependencies(IVirtualComponent earComponent, List components) {
        HashMap dependentComps = new HashMap();
        int i = 0;
        while (i < components.size()) {
            ArrayList<IVirtualComponent> compsForProject = new ArrayList<IVirtualComponent>();
            IVirtualComponent comp = (IVirtualComponent)components.get(i);
            IProject[] dependentProjects = DependencyGraphManager.getInstance().getDependencyGraph().getReferencingComponents(comp.getProject());
            int j = 0;
            while (j < dependentProjects.length) {
                IProject project = dependentProjects[j];
                if (!J2EEProjectUtilities.isEARProject((IProject)project)) {
                    IVirtualReference ref;
                    IVirtualComponent dependentComp = ComponentCore.createComponent((IProject)project);
                    IProject[] refEARs = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
                    boolean sameEAR = false;
                    int k = 0;
                    while (k < refEARs.length) {
                        if (refEARs[k].equals((Object)earComponent.getProject())) {
                            sameEAR = true;
                            break;
                        }
                        ++k;
                    }
                    if (!(!sameEAR || J2EEProjectUtilities.isDynamicWebProject((IProject)project) && (ref = dependentComp.getReference(comp.getName())) != null && ref.getRuntimePath().equals((Object)new Path("/WEB-INF/lib")))) {
                        compsForProject.add(dependentComp);
                    }
                }
                ++j;
            }
            dependentComps.put(comp, compsForProject);
            ++i;
        }
        return dependentComps;
    }

    private void removeEARComponentDependencies(Map dependentComps) throws ExecutionException {
        for (IVirtualComponent target : dependentComps.keySet()) {
            List sources = (List)dependentComps.get(target);
            int i = 0;
            while (i < sources.size()) {
                IVirtualComponent source = (IVirtualComponent)sources.get(i);
                IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
                model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)source);
                List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                modHandlesList.add(target);
                model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
                model.getDefaultOperation().execute(null, null);
                this.removeManifestDependency(source, target);
                ++i;
            }
        }
    }

    private void removeManifestDependency(IVirtualComponent source, IVirtualComponent target) throws ExecutionException {
        String targetProjName;
        String sourceProjName = source.getProject().getName();
        if (target instanceof J2EEModuleVirtualArchiveComponent) {
            targetProjName = ((J2EEModuleVirtualArchiveComponent)target).getName();
            String[] pathSegments = targetProjName.split("/");
            targetProjName = pathSegments[pathSegments.length - 1];
        } else {
            targetProjName = target.getProject().getName();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile manifestmf = J2EEProjectUtilities.getManifestFile((IProject)source.getProject());
        ArchiveManifest mf = J2EEProjectUtilities.readManifest((IProject)source.getProject());
        if (mf == null) {
            return;
        }
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)sourceProjName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        String[] cp = mf.getClassPathTokenized();
        ArrayList<String> cpList = new ArrayList<String>();
        String cpToRemove = targetProjName.endsWith(".jar") ? targetProjName : String.valueOf(targetProjName) + ".jar";
        int i = 0;
        while (i < cp.length) {
            if (!cp[i].equals(cpToRemove)) {
                cpList.add(cp[i]);
            }
            ++i;
        }
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
        updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
    }

    protected IDataModelOperation generateEARDDOperation() {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EarCreateDeploymentFilesDataModelProvider());
        model.setProperty("ICreateDeploymentFilesDataModelProperties.GENERATE_DD", (Object)this.earComponent);
        model.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.project);
        return model.getDefaultOperation();
    }

    protected IDataModelOperation removeComponentFromEAROperation(IVirtualComponent sourceComponent, List targetComponentsHandles, String dir) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveComponentFromEnterpriseApplicationDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentsHandles);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)dir);
        return model.getDefaultOperation();
    }

    protected List getComponentsToRemove() {
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        if (this.earComponent != null && list != null) {
            IVirtualReference[] oldrefs = this.earComponent.getReferences();
            int j = 0;
            while (j < oldrefs.length) {
                IVirtualReference ref = oldrefs[j];
                IVirtualComponent handle = ref.getReferencedComponent();
                if (!(this.j2eeComponentList.contains(handle) || this.isVersion5 && this.j2eeLibElementList.contains(handle))) {
                    list.add(handle);
                }
                ++j;
            }
        }
        return list;
    }

    protected List[] getComponentsToRemoveUpdate(boolean dirUpdated) {
        List[] list = new ArrayList[]{new ArrayList(), new ArrayList()};
        if (this.earComponent != null && list != null) {
            IVirtualReference[] oldrefs = this.earComponent.getReferences();
            int j = 0;
            while (j < oldrefs.length) {
                IVirtualReference ref = oldrefs[j];
                IVirtualComponent handle = ref.getReferencedComponent();
                if (!this.j2eeComponentList.contains(handle) && ref.getRuntimePath().isRoot()) {
                    list[0].add(handle);
                }
                if ((!this.j2eeLibElementList.contains(handle) || dirUpdated) && ref.getRuntimePath().toString().equals(this.oldLibDir)) {
                    list[1].add(handle);
                }
                ++j;
            }
        }
        return list;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.selectAllButton) {
            this.handleSelectAllButtonPressed();
        } else if (event.widget == this.deselectAllButton) {
            this.handleDeselectAllButtonPressed();
        } else if (event.widget == this.projectJarButton) {
            this.handleSelectProjectJarButton();
        } else if (event.widget == this.externalJarButton) {
            this.handleSelectExternalJarButton();
        } else if (event.widget == this.addVariableButton) {
            this.handleSelectVariableButton();
        } else if (event.widget == this.changeLibPathButton) {
            this.handleChangeLibDirButton(true);
        }
    }

    private void handleSelectAllButtonPressed() {
        this.availableComponentsViewer.setAllChecked(true);
        this.j2eeComponentList = this.getCheckedJ2EEElementsAsList(true);
        this.javaProjectsList = this.getCheckedJavaProjectsAsList(true);
        if (this.isVersion5) {
            this.j2eeLibElementList = this.getCheckedJ2EEElementsAsList(false);
            this.javaLibProjectsList = this.getCheckedJavaProjectsAsList(false);
        }
    }

    private void handleDeselectAllButtonPressed() {
        this.availableComponentsViewer.setAllChecked(false);
        if (this.isVersion5) {
            ((DoubleCheckboxTableViewer)this.availableComponentsViewer).setAllSecondChecked(false);
            this.libsToUncheck.clear();
        }
        this.j2eeComponentList = new ArrayList();
        this.javaProjectsList = new ArrayList();
        if (this.isVersion5) {
            this.j2eeLibElementList = new ArrayList();
            this.javaLibProjectsList = new ArrayList();
        }
    }

    private void addPotentialNewReference(IVirtualComponent archive) {
        IVirtualReference[] existingRefs = this.earComponent.getReferences();
        boolean refAlreadyExists = false;
        int i = 0;
        while (i < existingRefs.length && !refAlreadyExists) {
            IVirtualComponent referencedComponent = existingRefs[i].getReferencedComponent();
            refAlreadyExists = referencedComponent.equals(archive);
            ++i;
        }
        if (!refAlreadyExists) {
            this.j2eeComponentList.add(archive);
            this.addedJARComponents.add(archive);
        }
    }

    private void handleSelectExternalJarButton() {
        IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.propPage.getShell());
        if (selected != null) {
            int i = 0;
            while (i < selected.length) {
                String type = "lib/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)this.earComponent.getProject(), (String)(String.valueOf(type) + selected[i].toString()));
                this.addPotentialNewReference(archive);
                ++i;
            }
            this.refresh();
        }
    }

    private void handleSelectVariableButton() {
        Path[] existingPath = new Path[]{};
        IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.propPage.getShell(), (IPath[])existingPath);
        if (paths != null) {
            this.refresh();
            int i = 0;
            while (i < paths.length) {
                IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i]);
                File file = new File(resolvedPath.toOSString());
                if (file.isFile() && file.exists()) {
                    String type = "var/";
                    IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)this.earComponent.getProject(), (String)(String.valueOf(type) + paths[i].toString()));
                    this.addPotentialNewReference(archive);
                }
                ++i;
            }
            this.refresh();
        }
    }

    private void handleChangeLibDirButton(boolean warnBlank) {
        ChangeLibDirDialog dlg;
        IVirtualFile vFile = this.earComponent.getRootFolder().getFile((IPath)new Path("META-INF/application.xml"));
        if (!vFile.exists()) {
            if (!MessageDialog.openQuestion(null, (String)J2EEUIMessages.getResourceString("NO_DD_MSG_TITLE"), (String)J2EEUIMessages.getResourceString("GEN_DD_QUESTION"))) {
                return;
            }
            this.createDD((IProgressMonitor)new NullProgressMonitor());
        }
        Application app = (Application)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
        if (this.libDir == null) {
            this.libDir = app.getLibraryDirectory();
            if (this.libDir == null) {
                this.libDir = "/lib";
            }
        }
        if ((dlg = new ChangeLibDirDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.libDir, warnBlank)).open() == 1) {
            return;
        }
        this.libDir = dlg.getValue().trim();
        if (this.libDir.length() > 0 && !this.libDir.startsWith("/")) {
            this.libDir = String.valueOf('/') + this.libDir;
        }
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillComposite(composite);
    }

    public void fillComposite(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTable(parent);
        this.createButtonColumn(parent);
    }

    protected void createButtonColumn(Composite parent) {
        this.buttonColumn = this.createButtonColumnComposite(parent);
        GridData data = new GridData(128);
        this.buttonColumn.setLayoutData((Object)data);
        this.createPushButtons();
    }

    protected void createPushButtons() {
        this.selectAllButton = this.createPushButton(SELECT_ALL_BUTTON);
        this.deselectAllButton = this.createPushButton(DE_SELECT_ALL_BUTTON);
        this.projectJarButton = this.createPushButton(J2EEUIMessages.getResourceString("PROJECT_JAR"));
        this.externalJarButton = this.createPushButton(J2EEUIMessages.getResourceString("EXTERNAL_JAR"));
        this.addVariableButton = this.createPushButton(J2EEUIMessages.getResourceString("ADDVARIABLE"));
        if (this.isVersion5) {
            this.changeLibPathButton = this.createPushButton(J2EEUIMessages.getResourceString("CHANGE_LIB_DIR"));
        }
    }

    protected Button createPushButton(String label) {
        Button aButton = this.primCreatePushButton(label, this.buttonColumn);
        aButton.addListener(13, (Listener)this);
        aButton.setLayoutData((Object)new GridData(768));
        return aButton;
    }

    public Button primCreatePushButton(String label, Composite aButtonColumn) {
        Button aButton = new Button(aButtonColumn, 8);
        aButton.setText(label);
        return aButton;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite aButtonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        aButtonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        aButtonColumn.setLayoutData((Object)data);
        return aButtonColumn;
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTable(Composite parent) {
        this.availableComponentsViewer = this.createavailableComponentsViewer(parent);
        GridData gd = new GridData(1296);
        this.availableComponentsViewer.getTable().setLayoutData((Object)gd);
        if (this.earComponent != null) {
            int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((IVirtualComponent)this.earComponent);
            AvailableJ2EEComponentsForEARContentProvider provider = new AvailableJ2EEComponentsForEARContentProvider(this.earComponent, j2eeVersion);
            this.availableComponentsViewer.setContentProvider((IContentProvider)provider);
            this.availableComponentsViewer.setLabelProvider((IBaseLabelProvider)provider);
            this.addTableListeners();
        }
    }

    protected void addTableListeners() {
        this.addCheckStateListener();
    }

    protected void addCheckStateListener() {
        this.availableComponentsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!(event instanceof SecondCheckBoxStateChangedEvent) && AddModulestoEARPropertiesPage.this.isVersion5) {
                    DoubleCheckboxTableViewer vr = (DoubleCheckboxTableViewer)((Object)event.getSource());
                    Object[] items = vr.getUncheckedItems();
                    int i = 0;
                    while (i < items.length) {
                        DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)((Object)items[i]);
                        if (item.getSecondChecked()) {
                            item.setSecondChecked(false);
                            AddModulestoEARPropertiesPage.this.libsToUncheck.remove(event.getElement());
                        }
                        ++i;
                    }
                }
                if (event instanceof SecondCheckBoxStateChangedEvent) {
                    DependencyConflictResolveDialog dlg;
                    SecondCheckBoxStateChangedEvent evt = (SecondCheckBoxStateChangedEvent)event;
                    DoubleCheckboxTableItem tblItem = evt.getTableItem();
                    if (tblItem.getSecondChecked() && AddModulestoEARPropertiesPage.this.isConflict(tblItem.getData()) && (dlg = new DependencyConflictResolveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2)).open() == 1) {
                        tblItem.setSecondChecked(false);
                        return;
                    }
                    if (tblItem.getSecondChecked()) {
                        if (!tblItem.getChecked()) {
                            tblItem.setChecked(true);
                        }
                        AddModulestoEARPropertiesPage.this.libsToUncheck.add(event.getElement());
                    } else {
                        AddModulestoEARPropertiesPage.this.libsToUncheck.remove(event.getElement());
                    }
                }
                AddModulestoEARPropertiesPage.this.j2eeComponentList = AddModulestoEARPropertiesPage.this.getCheckedJ2EEElementsAsList(true);
                AddModulestoEARPropertiesPage.this.javaProjectsList = AddModulestoEARPropertiesPage.this.getCheckedJavaProjectsAsList(true);
                if (AddModulestoEARPropertiesPage.this.isVersion5) {
                    AddModulestoEARPropertiesPage.this.j2eeLibElementList = AddModulestoEARPropertiesPage.this.getCheckedJ2EEElementsAsList(false);
                    AddModulestoEARPropertiesPage.this.javaLibProjectsList = AddModulestoEARPropertiesPage.this.getCheckedJavaProjectsAsList(false);
                }
            }
        });
    }

    protected Object[] getCPComponentsInEar(boolean inLibFolder) {
        ArrayList list = new ArrayList();
        HashMap pathToComp = new HashMap();
        IVirtualReference[] refs = this.earComponent.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference ref = refs[i];
            if (ref.getRuntimePath().isRoot() && !inLibFolder || !ref.getRuntimePath().isRoot() && inLibFolder || !this.isVersion5) {
                IVirtualComponent comp = ref.getReferencedComponent();
                AvailableJ2EEComponentsForEARContentProvider.addClasspathComponentDependencies(list, pathToComp, comp);
            }
            ++i;
        }
        return list.toArray();
    }

    protected Object[] getComponentsInEar(boolean inLibFolder) {
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        IVirtualReference[] refs = this.earComponent.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference ref = refs[i];
            if (ref.getRuntimePath().isRoot() && !inLibFolder || !ref.getRuntimePath().isRoot() && inLibFolder || !this.isVersion5) {
                IVirtualComponent comp = ref.getReferencedComponent();
                list.add(comp);
            }
            ++i;
        }
        return list.toArray();
    }

    protected boolean inEARAlready(IVirtualComponent component) {
        IVirtualReference[] refs = this.earComponent.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference ref = refs[i];
            if (ref.getReferencedComponent().equals(component)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List getCheckedJ2EEElementsAsList(boolean singleChecked) {
        ArrayList<Object> list;
        Object[] elements = this.isVersion5 ? (singleChecked ? ((DoubleCheckboxTableViewer)this.availableComponentsViewer).getSingleCheckedElements() : ((DoubleCheckboxTableViewer)this.availableComponentsViewer).getDoubleCheckedElements()) : this.availableComponentsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = new ArrayList<Object>(0);
        } else {
            list = new ArrayList();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IVirtualComponent) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected List getCheckedJavaProjectsAsList(boolean single) {
        ArrayList<Object> list;
        Object[] elements = this.isVersion5 ? (single ? ((DoubleCheckboxTableViewer)this.availableComponentsViewer).getSingleCheckedElements() : ((DoubleCheckboxTableViewer)this.availableComponentsViewer).getDoubleCheckedElements()) : this.availableComponentsViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            list = new ArrayList<Object>(0);
        } else {
            list = new ArrayList();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IProject) {
                    list.add(elements[i]);
                }
                ++i;
            }
        }
        return list;
    }

    protected List getLibFolderLibsAsList() {
        ArrayList<Object> list;
        Object[] items = ((DoubleCheckboxTableViewer)this.availableComponentsViewer).getSecondCheckedItems();
        if (items == null || items.length == 0) {
            list = new ArrayList<Object>(0);
        } else {
            list = new ArrayList();
            int i = 0;
            while (i < items.length) {
                Object element = ((DoubleCheckboxTableItem)((Object)items[i])).getData();
                if (element instanceof IProject) {
                    list.add(element);
                }
                ++i;
            }
        }
        return list;
    }

    public CheckboxTableViewer createavailableComponentsViewer(Composite parent) {
        int flags = 67618;
        Table table = this.isVersion5 ? new Table(parent, flags) : new Table(parent, flags);
        this.availableComponentsViewer = this.isVersion5 ? new DoubleCheckboxTableViewer(table, 2) : new CheckboxTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        if (this.isVersion5) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        }
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.availableComponentsViewer.setSorter(null);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(ManifestUIResourceHandler.JAR_Module_UI_);
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(ManifestUIResourceHandler.Project_UI_);
        projectColumn.setResizable(true);
        if (this.isVersion5) {
            TableColumn bndColumn = new TableColumn(table, 0, 2);
            bndColumn.setText(ManifestUIResourceHandler.Packed_In_Lib_UI_);
            bndColumn.setResizable(true);
        }
        tableLayout.layout((Composite)table, true);
        return this.availableComponentsViewer;
    }

    private boolean shouldBeDisabled(IVirtualComponent component) {
        if (J2EEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
            return true;
        }
        if (J2EEProjectUtilities.isEARProject((IProject)component.getProject()) && component.isBinary()) {
            return false;
        }
        if (J2EEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
            return true;
        }
        if (J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
            return true;
        }
        if (J2EEProjectUtilities.isJCAComponent((IVirtualComponent)component)) {
            return true;
        }
        if (J2EEProjectUtilities.isStaticWebProject((IProject)component.getProject())) {
            return true;
        }
        if (J2EEProjectUtilities.isProjectOfType((IProject)component.getProject(), (String)"jst.java")) {
            return false;
        }
        return false;
    }

    public void refresh() {
        Object[] cpComps;
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        this.availableComponentsViewer.setInput((Object)input);
        GridData data = new GridData(1808);
        int numlines = Math.min(10, this.availableComponentsViewer.getTable().getItemCount());
        data.heightHint = this.availableComponentsViewer.getTable().getItemHeight() * numlines;
        this.availableComponentsViewer.getTable().setLayoutData((Object)data);
        for (IVirtualComponent jarComponent : this.addedJARComponents) {
            this.availableComponentsViewer.add((Object)jarComponent);
        }
        TableItem[] items = this.availableComponentsViewer.getTable().getItems();
        ArrayList<IVirtualComponent> list = new ArrayList<IVirtualComponent>();
        Object[] cpLibComps = new Object[]{};
        HashSet j2eeComponentSet = new HashSet();
        HashSet j2eeLibComponentSet = new HashSet();
        if (this.isVersion5) {
            Object[] comps;
            if (this.j2eeComponentList.isEmpty()) {
                comps = this.getComponentsInEar(false);
                this.j2eeComponentList.addAll((Collection)Arrays.asList(comps));
            }
            if (this.j2eeLibElementList.isEmpty()) {
                comps = this.getComponentsInEar(true);
                this.j2eeLibElementList.addAll((Collection)Arrays.asList(comps));
            }
            cpComps = this.getCPComponentsInEar(false);
            this.j2eeComponentList.addAll((Collection)Arrays.asList(cpComps));
            cpLibComps = this.getCPComponentsInEar(true);
            this.j2eeLibElementList.addAll((Collection)Arrays.asList(cpLibComps));
            int i = 0;
            while (i < this.j2eeLibElementList.size()) {
                j2eeLibComponentSet.add(this.j2eeLibElementList.get(i));
                ++i;
            }
        } else {
            if (this.j2eeComponentList.isEmpty()) {
                Object[] comps = this.getComponentsInEar(false);
                this.j2eeComponentList.addAll((Collection)Arrays.asList(comps));
            }
            cpComps = this.getCPComponentsInEar(false);
            this.j2eeComponentList.addAll((Collection)Arrays.asList(cpComps));
        }
        int i = 0;
        while (i < this.j2eeComponentList.size()) {
            j2eeComponentSet.add(this.j2eeComponentList.get(i));
            ++i;
        }
        i = 0;
        while (i < items.length) {
            Object element = items[i].getData();
            if (element instanceof IVirtualComponent) {
                IVirtualComponent comp = (IVirtualComponent)element;
                if (j2eeComponentSet.contains(comp)) {
                    list.add(comp);
                }
                if (this.isVersion5) {
                    DoubleCheckboxTableItem dcbItem = (DoubleCheckboxTableItem)items[i];
                    boolean secondEnabled = dcbItem.getSecondEnabled();
                    if (this.shouldBeDisabled(comp) == secondEnabled) {
                        dcbItem.setSecondEnabled(!secondEnabled);
                    }
                    dcbItem.setSecondChecked(j2eeLibComponentSet.contains(comp));
                    if (j2eeLibComponentSet.contains(comp)) {
                        list.add(comp);
                    }
                }
            }
            ++i;
        }
        this.availableComponentsViewer.setCheckedElements(list.toArray());
        this.availableComponentsViewer.setGrayedElements(cpComps);
        if (this.isVersion5) {
            this.availableComponentsViewer.setGrayedElements(cpLibComps);
        }
        GridData btndata = new GridData(258);
        this.buttonColumn.setLayoutData((Object)btndata);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConflict(Object lib) {
        IProject libProj = lib instanceof IProject ? (IProject)lib : ((IVirtualComponent)lib).getProject();
        IProject earProject = this.earComponent.getProject();
        try {
            ComponentCore.createComponent((IProject)earProject);
            IProject[] earRefProjects = earProject.getReferencedProjects();
            int i = 0;
            while (true) {
                if (i >= earRefProjects.length) {
                    return false;
                }
                if (!J2EEProjectUtilities.isEARProject((IProject)earRefProjects[i]) && !earRefProjects[i].equals((Object)libProj)) {
                    IVirtualComponent cmp1 = ComponentCore.createComponent((IProject)earRefProjects[i]);
                    IVirtualReference[] refs = cmp1.getReferences();
                    int j = 0;
                    while (j < refs.length) {
                        if (refs[j].getReferencedComponent().getProject().equals((Object)libProj)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
            return false;
        }
    }

    private void handleSelectProjectJarButton() {
        IPath[] selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.propPage.getShell(), (IPath)this.project.getLocation(), (IPath[])new IPath[0]);
        if (selected != null) {
            int i = 0;
            while (i < selected.length) {
                String type = "lib/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)this.earComponent.getProject(), (String)(String.valueOf(type) + selected[i].makeRelative().toString()));
                this.addPotentialNewReference(archive);
                ++i;
            }
            this.refresh();
        }
    }

    private String getURIMappingName(IVirtualComponent archive) {
        IPath componentPath = Path.fromOSString((String)archive.getName());
        String uriMapName = componentPath.lastSegment().replace(' ', '_');
        IVirtualReference[] existingRefs = this.earComponent.getReferences();
        int i = 0;
        while (i < existingRefs.length) {
            existingRefs[i].getReferencedComponent().getName();
            if (existingRefs[i].getArchiveName().equals(uriMapName)) {
                boolean dupeArchiveName = true;
                int j = 1;
                while (dupeArchiveName) {
                    int lastDotIndex = uriMapName.lastIndexOf(46);
                    String increment = "_" + j;
                    uriMapName = lastDotIndex != -1 ? String.valueOf(uriMapName.substring(0, lastDotIndex)) + increment + uriMapName.substring(lastDotIndex) : String.valueOf(uriMapName.substring(0)) + increment;
                    int k = 0;
                    while (k < existingRefs.length) {
                        dupeArchiveName = existingRefs[k].getArchiveName().equals(uriMapName);
                        if (dupeArchiveName) break;
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return uriMapName;
    }

    private String getVirtualComponentNameWithExtension(IVirtualComponent virtComp) {
        String virtCompURIMapName = this.getURIMappingName(virtComp);
        boolean linkedToEAR = true;
        try {
            if (virtComp.isBinary()) {
                linkedToEAR = ((J2EEModuleVirtualArchiveComponent)virtComp).isLinkedToEAR();
                ((J2EEModuleVirtualArchiveComponent)virtComp).setLinkedToEAR(false);
            }
            if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)virtComp)) {
                if (!virtCompURIMapName.endsWith(".war")) {
                    virtCompURIMapName = String.valueOf(virtCompURIMapName) + ".war";
                }
            } else if (JavaEEProjectUtilities.isJCAComponent((IVirtualComponent)virtComp)) {
                if (!virtCompURIMapName.endsWith(".rar")) {
                    virtCompURIMapName = String.valueOf(virtCompURIMapName) + ".rar";
                }
            } else if (!virtCompURIMapName.endsWith(".jar")) {
                virtCompURIMapName = String.valueOf(virtCompURIMapName) + ".jar";
            }
        }
        finally {
            if (virtComp.isBinary()) {
                ((J2EEModuleVirtualArchiveComponent)virtComp).setLinkedToEAR(linkedToEAR);
            }
        }
        return virtCompURIMapName;
    }
}

