/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.wizard.NewWebWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class NewWebArtifactWizard
extends NewWebWizard {
    protected static final String PAGE_ONE = "pageOne";
    protected static final String PAGE_TWO = "pageTwo";
    protected static final String PAGE_THREE = "pageThree";

    public NewWebArtifactWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(this.getTitle());
        this.setDefaultPageImageDescriptor(this.getImage());
    }

    protected boolean runForked() {
        return false;
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected abstract String getTitle();

    protected abstract ImageDescriptor getImage();

    protected ImageDescriptor getImageFromJ2EEPlugin(String key) {
        URL url = (URL)J2EEPlugin.getDefault().getImage(key);
        return ImageDescriptor.createFromURL((URL)url);
    }

    protected void openJavaClass() {
        try {
            String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
            IFile file = (IFile)javaProject.findType(className).getResource();
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            ServletUIPlugin.log(cantOpen);
        }
    }

    protected void openWebFile() {
        try {
            String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            IVirtualComponent component = ComponentCore.createComponent((IProject)p);
            IContainer webContent = component.getRootFolder().getUnderlyingFolder();
            IFile file = webContent.getFile((IPath)new Path(className));
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            ServletUIPlugin.log(cantOpen);
        }
    }

    protected void openEditor(final IFile file) {
        if (this.getDataModel().getBooleanProperty("NewJavaClassDataModel.OPEN_IN_EDITOR") && file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        ServletUIPlugin.log((Exception)((Object)e));
                    }
                }
            });
        }
    }
}

