/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.wizard.AnnotationsStandaloneGroup;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.plugin.WEBUIMessages;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class NewWebClassWizardPage
extends NewJavaClassWizardPage {
    protected AnnotationsStandaloneGroup annotationsGroup;
    protected Button existingClassButton;
    protected Label existingClassLabel;
    protected Text existingClassText;
    protected Button existingButton;

    public NewWebClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.projectNameLabel.setText(WEBUIMessages.WEB_PROJECT_LBL);
        this.addSeperator(composite, 3);
        this.createUseExistingGroup(composite);
        this.createAnnotationsGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        if (selection instanceof CompressedJavaProject) {
            return ((CompressedJavaProject)selection).getProject().getProject();
        }
        return super.getExtendedSelectedProject(selection);
    }

    protected abstract String getUseExistingCheckboxText();

    protected abstract String getUseExistingProperty();

    protected abstract void handleClassButtonSelected();

    private void createAnnotationsGroup(Composite parent) {
        if (this.isWebDocletProject()) {
            this.annotationsGroup = new AnnotationsStandaloneGroup(parent, (Object)this.model, "jst.ejb".equals(this.projectType), "jst.web".equals(this.projectType));
            if (!this.model.isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
                return;
            }
            IProject project = ProjectUtilities.getProject((String)this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
            this.annotationsGroup.setEnablement(project);
        } else {
            this.model.setProperty("IAnnotationsDataModel.useAnnotations", (Object)false);
        }
    }

    private void createUseExistingGroup(Composite composite) {
        this.existingButton = new Button(composite, 32);
        this.existingButton.setText(this.getUseExistingCheckboxText());
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.existingButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.existingButton, this.getUseExistingProperty(), null);
        this.existingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebClassWizardPage.this.handleExistingButtonSelected();
            }
        });
        this.existingClassLabel = new Label(composite, 16384);
        this.existingClassLabel.setText(IWebWizardConstants.CLASS_NAME_LABEL);
        this.existingClassLabel.setLayoutData((Object)new GridData(32));
        this.existingClassLabel.setEnabled(false);
        this.existingClassText = new Text(composite, 2060);
        this.existingClassText.setLayoutData((Object)new GridData(768));
        this.existingClassText.setEnabled(false);
        this.synchHelper.synchText(this.existingClassText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.existingClassButton = new Button(composite, 8);
        this.existingClassButton.setText(IWebWizardConstants.BROWSE_BUTTON_LABEL);
        this.existingClassButton.setLayoutData((Object)new GridData(256));
        this.existingClassButton.setEnabled(false);
        this.existingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebClassWizardPage.this.handleClassButtonSelected();
            }
        });
    }

    private void handleExistingButtonSelected() {
        boolean enable = this.existingButton.getSelection();
        this.existingClassLabel.setEnabled(enable);
        this.existingClassButton.setEnabled(enable);
        this.packageText.setEnabled(!enable);
        this.packageButton.setEnabled(!enable);
        this.packageLabel.setEnabled(!enable);
        this.classText.setEnabled(!enable);
        this.classLabel.setEnabled(!enable);
        this.superText.setEnabled(!enable);
        this.superButton.setEnabled(!enable);
        this.superLabel.setEnabled(!enable);
    }

    private boolean isWebDocletProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && !"".equals(projectName.trim())) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject.hasProjectFacet(WebFacetUtils.WEB_XDOCLET_FACET);
            }
            catch (CoreException e) {
                ServletUIPlugin.log((Exception)((Object)e));
            }
        }
        return false;
    }
}

