/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal.dialog;

import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;

public class ResultsDialog
extends IconAndMessageDialog {
    private ValidationResult _result;
    private long _time;
    private int _resourceCount;
    private Button _hideButton;

    public ResultsDialog(Shell parentShell, ValidationResult results, long time, int resourceCount) {
        super(parentShell);
        this._result = results;
        this._time = time;
        this._resourceCount = resourceCount;
    }

    protected void okPressed() {
        if (this._hideButton != null) {
            GlobalPreferences gp = ValManager.getDefault().getGlobalPreferences();
            gp.setConfirmDialog(!this._hideButton.getSelection());
            ValPrefManagerGlobal.getDefault().savePreferences(gp);
        }
        super.okPressed();
    }

    public int open() {
        if (!ErrorDialog.AUTOMATED_MODE) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    protected Image getImage() {
        if (this._result.getSeverityError() > 0) {
            return this.getErrorImage();
        }
        if (this._result.getSeverityWarning() > 0) {
            return this.getWarningImage();
        }
        return this.getInfoImage();
    }

    protected Control createDialogArea(Composite parent) {
        this.message = this.getMessage();
        this.createMessageArea(parent);
        new Label(parent, 0).setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.addHideCheckbox(parent);
        Control c = super.createDialogArea(parent);
        return c;
    }

    private void addHideCheckbox(Composite parent) {
        this._hideButton = new Button(parent, 32);
        GridDataFactory.swtDefaults().align(1, 1).span(2, 1).applyTo((Control)this._hideButton);
        this._hideButton.setText(ValUIMessages.DoNotShowResults);
        if (ValManager.getDefault().getGlobalPreferences().getConfirmDialog()) {
            this._hideButton.getSelection();
        }
        this._hideButton.setSelection(!ValManager.getDefault().getGlobalPreferences().getConfirmDialog());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ValidationUIMessages.ValResults);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        ok.setFocus();
    }

    private String getMessage() {
        if (this._resourceCount > 1) {
            if (this._result.getSeverityError() > 1) {
                return NLS.bind((String)ValidationUIMessages.ValErrorsResources, (Object[])new Object[]{this._result.getSeverityError(), this._resourceCount, Misc.getTimeMS((long)this._time)});
            }
            if (this._result.getSeverityError() == 1) {
                return NLS.bind((String)ValidationUIMessages.ValError1Resources, (Object)this._resourceCount, (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityWarning() > 1) {
                return NLS.bind((String)ValidationUIMessages.ValWarnResources, (Object[])new Object[]{this._result.getSeverityWarning(), this._resourceCount, Misc.getTimeMS((long)this._time)});
            }
            if (this._result.getSeverityWarning() == 1) {
                return NLS.bind((String)ValidationUIMessages.ValWarn1Resources, (Object)this._resourceCount, (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityInfo() > 1) {
                return NLS.bind((String)ValidationUIMessages.ValInfoResources, (Object[])new Object[]{this._result.getSeverityInfo(), this._resourceCount, Misc.getTimeMS((long)this._time)});
            }
            if (this._result.getSeverityInfo() == 1) {
                return NLS.bind((String)ValidationUIMessages.ValInfo1Resources, (Object)this._resourceCount, (Object)Misc.getTimeMS((long)this._time));
            }
        } else if (this._resourceCount == 1) {
            if (this._result.getSeverityError() > 1) {
                return NLS.bind((String)ValidationUIMessages.ValErrorsResource1, (Object)this._result.getSeverityError(), (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityError() == 1) {
                return NLS.bind((String)ValidationUIMessages.ValError1Resource1, (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityWarning() > 1) {
                return NLS.bind((String)ValidationUIMessages.ValWarnResource1, (Object)this._result.getSeverityWarning(), (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityWarning() == 1) {
                return NLS.bind((String)ValidationUIMessages.ValWarn1Resource1, (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityInfo() > 1) {
                return NLS.bind((String)ValidationUIMessages.ValInfoResource1, (Object)this._result.getSeverityInfo(), (Object)Misc.getTimeMS((long)this._time));
            }
            if (this._result.getSeverityInfo() == 1) {
                return NLS.bind((String)ValidationUIMessages.ValInfo1Resource1, (Object)Misc.getTimeMS((long)this._time));
            }
        }
        return ValidationUIMessages.ValSuccess;
    }
}

