/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.ui.internal.cmp.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.EjbAnnotationsUiPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class ConnectionSelectionPage
extends DataModelWizardPage
implements SelectionListener {
    protected boolean myFirstTime = true;
    protected Button reconnectButton;
    private Button newConnectionButton;
    private boolean connected;
    private org.eclipse.swt.widgets.List existingConnectionsList;
    private Hashtable existingConnections;
    private Label propertiesLabel;
    private Table connectionPropertiesTable;

    public ConnectionSelectionPage(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(model, pageName, title, titleImage);
    }

    public ConnectionSelectionPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IEJBAnnotationConstants.CMP_CONNECTION_PAGE_DESC);
        this.setTitle(IEJBAnnotationConstants.CMP_CONNECTION_PAGE_TITLE);
    }

    public Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.newConnectionButton = new Button(composite, 8);
        this.newConnectionButton.setText(IEJBAnnotationConstants.CMP_CONNECTION_NEW_BUTTON);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.newConnectionButton.setLayoutData((Object)gd);
        Composite indentationComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        indentationComposite.setLayout((Layout)layout);
        indentationComposite.setLayoutData((Object)new GridData(1808));
        Group existingConnectionsGroup = new Group(indentationComposite, 0);
        existingConnectionsGroup.setText(IEJBAnnotationConstants.CMP_CONNECTION_AVAILABLE);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        existingConnectionsGroup.setLayout((Layout)layout);
        gd = new GridData(1808);
        existingConnectionsGroup.setLayoutData((Object)gd);
        this.existingConnectionsList = new org.eclipse.swt.widgets.List((Composite)existingConnectionsGroup, 2560);
        gd = new GridData(768);
        gd.heightHint = 100;
        this.existingConnectionsList.setLayoutData((Object)gd);
        this.propertiesLabel = new Label((Composite)existingConnectionsGroup, 0);
        this.propertiesLabel.setText(IEJBAnnotationConstants.CMP_CONNECTION_PROPERTIES);
        gd = new GridData();
        this.propertiesLabel.setLayoutData((Object)gd);
        this.connectionPropertiesTable = new Table((Composite)existingConnectionsGroup, 2048);
        gd = new GridData(1808);
        this.connectionPropertiesTable.setLayoutData((Object)gd);
        this.connectionPropertiesTable.setLinesVisible(true);
        this.connectionPropertiesTable.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.connectionPropertiesTable, 0);
        tc1.setText(IEJBAnnotationConstants.CMP_CONNECTION_PROPERTY);
        tc1.setResizable(true);
        tc1.setWidth(140);
        TableColumn tc2 = new TableColumn(this.connectionPropertiesTable, 0);
        tc2.setText(IEJBAnnotationConstants.CMP_CONNECTION_VALUE);
        tc2.setResizable(true);
        tc2.setWidth(250);
        this.initializeDialogUnits((Control)composite);
        this.setControl((Control)composite);
        this.newConnectionButton.addListener(13, (Listener)this);
        this.existingConnectionsList.addListener(13, (Listener)this);
        this.newConnectionButton.setSelection(true);
        this.initializeValues();
        this.setPageComplete(true);
        this.addReconnectButton(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.newConnectionButton) {
            try {
                EjbAnnotationsUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.rdb.server.ui.navigator.serverExplorer");
            }
            catch (PartInitException partInitException) {}
            IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
            ArrayList<String> nameList = new ArrayList<String>(profiles.length);
            int i = 0;
            int n = profiles.length;
            while (i < n) {
                if (!nameList.contains(profiles[i].getName())) {
                    nameList.add(profiles[i].getName().toLowerCase());
                }
                ++i;
            }
            nameList.toArray(new String[nameList.size()]);
            AddProfileViewAction action = new AddProfileViewAction("org.eclipse.datatools.connectivity.db.category");
            action.run();
            this.initializeValues();
        } else if (source == this.existingConnectionsList) {
            this.updateConnectionProperties();
            this.setPageComplete(true);
            this.reconnectButton.setEnabled(true);
        }
        this.reconnectButton.setEnabled(true);
        this.isValidConnection();
    }

    private void addReconnectButton(Composite parent) {
        this.reconnectButton = new Button(parent, 8);
        this.reconnectButton.setText("Reconnect");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 1;
        this.reconnectButton.setLayoutData((Object)data);
        this.reconnectButton.addSelectionListener((SelectionListener)this);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
    }

    public void widgetSelected(SelectionEvent evt) {
        Object source = evt.getSource();
        if (source == this.reconnectButton) {
            this.getSelectedConnection();
            try {
                this.getSelectedConnection().connect(null);
                this.reconnectButton.setEnabled(false);
                this.connected = true;
            }
            catch (Exception ex) {
                this.reconnectButton.setEnabled(true);
                this.connected = false;
                MessageDialog.openError((Shell)this.getShell(), (String)"Cannot connect", (String)ex.getMessage());
            }
            this.isValidConnection();
        }
    }

    private void initializeValues() {
        this.existingConnectionsList.removeAll();
        IConnectionProfile[] connInfos = this.getConnectionsToDisplay();
        if (connInfos != null) {
            this.existingConnections = new Hashtable();
            List<IConnectionProfile> sortedConnections = Arrays.asList(connInfos);
            this.sortConnections(sortedConnections);
            Iterator<IConnectionProfile> connections = sortedConnections.iterator();
            while (connections.hasNext()) {
                IConnectionProfile con = connections.next();
                this.existingConnections.put(con.getName(), con);
                this.existingConnectionsList.add(con.getName());
            }
        }
        if (this.existingConnectionsList.getItemCount() > 0) {
            this.existingConnectionsList.select(0);
            this.updateConnectionProperties();
        }
        this.newConnectionButton.setSelection(true);
    }

    protected void sortConnections(List connections) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IConnectionProfile)o1).getName();
                String s2 = ((IConnectionProfile)o2).getName();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(connections, c);
    }

    public IConnectionProfile getSelectedConnection() {
        if (this.existingConnections == null || this.existingConnectionsList == null || this.existingConnectionsList.getSelection().length == 0) {
            return null;
        }
        IConnectionProfile connection = (IConnectionProfile)this.existingConnections.get(this.existingConnectionsList.getSelection()[0]);
        return connection;
    }

    protected IConnectionProfile[] getConnectionsToDisplay() {
        return ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
    }

    public void refresh() {
        this.reconnectButton.setEnabled(true);
        this.connected = false;
        this.initializeValues();
        this.isValidConnection();
    }

    private void updateConnectionProperties() {
        Properties properties;
        IConnectionProfile selectedConnection;
        this.connectionPropertiesTable.removeAll();
        if (this.existingConnectionsList.getSelectionIndex() > -1 && (selectedConnection = (IConnectionProfile)this.existingConnections.get(this.existingConnectionsList.getSelection()[0])) != null && (properties = selectedConnection.getBaseProperties()) != null) {
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                Object pkey = keys.nextElement();
                TableItem tableItem = new TableItem(this.connectionPropertiesTable, 0);
                tableItem.setText(new String[]{pkey.toString(), properties.getProperty((String)pkey)});
            }
        }
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    public boolean isPageComplete() {
        return this.connected;
    }

    protected boolean isValidConnection() {
        boolean isOK = false;
        try {
            IConnectionProfile connectionInfo = this.getSelectedConnection();
            if (connectionInfo != null) {
                isOK = this.getSelectedConnection().isConnected();
            }
        }
        catch (Throwable throwable) {}
        if (isOK) {
            this.setErrorMessage(null);
            this.setMessage("Connected succesfully", 0);
            this.connected = true;
            this.setPageComplete(true);
            return true;
        }
        this.setErrorMessage("No Connection");
        this.connected = false;
        this.setPageComplete(false);
        return false;
    }

    class NewConnectionWizard
    extends NewConnectionProfileWizard {
        NewConnectionWizard() {
        }

        public void addCustomPages() {
        }

        public Properties getProfileProperties() {
            return new Properties();
        }
    }
}

