/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelquery;

import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.XMLAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.w3c.dom.Document;

class XHTMLAssociationProvider
extends XMLAssociationProvider {
    private static final boolean USE_QUICK_CACHE = true;
    protected URIResolver idResolver;
    private String fCachedGrammerURI;
    private String fCachedPublicID;
    private String fCachedSystemID;
    private boolean cached;

    public XHTMLAssociationProvider(CMDocumentCache cache, URIResolver idResolver) {
        super(cache);
        this.idResolver = idResolver;
        this.documentManager.setPropertyEnabled("performURIResolution", false);
    }

    public CMDocument getXHTMLCMDocument(String publicId, String systemId) {
        if (this.idResolver == null) {
            return null;
        }
        String grammerURI = null;
        if (this.cached && this.sameAs(this.fCachedPublicID, publicId) && this.sameAs(this.fCachedSystemID, systemId)) {
            grammerURI = this.fCachedGrammerURI;
        } else {
            this.fCachedGrammerURI = grammerURI = this.idResolver.resolve(null, publicId, systemId);
            this.fCachedPublicID = publicId;
            this.fCachedSystemID = systemId;
            this.cached = true;
        }
        if (grammerURI == null) {
            return null;
        }
        CMDocument cmDocument = this.documentManager.getCMDocument(publicId, grammerURI, null);
        return cmDocument;
    }

    protected String resolveGrammarURI(Document document, String publicId, String systemId) {
        return this.idResolver.resolve(null, publicId, systemId);
    }

    private boolean sameAs(String a, String b) {
        boolean result = false;
        result = a == null ? b == null : a.equals(b);
        return result;
    }

    public String getCachedGrammerURI() {
        return this.fCachedGrammerURI;
    }
}

