/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.SourceViewerCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.elementedit.ElementEditFactoryRegistry;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.IDropCustomizer;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PaletteDropInsertCommand
extends SourceViewerCommand {
    private final Logger _log = PDPlugin.getLogger(PaletteDropInsertCommand.class);
    private TagToolPaletteEntry _tagItem;
    private int _location;
    private Element _element;
    private IAdaptable _customizationData;

    public PaletteDropInsertCommand(String label, StructuredTextEditor editor, TagToolPaletteEntry tagItem, int location) {
        super(label, editor);
        this._tagItem = tagItem;
        this._location = location;
    }

    public void doExecute() {
        Node node;
        try {
            node = this.getSourceEditingTextTools().getNode(this._location);
        }
        catch (Exception e) {
            this._log.error("Bad text insertion location", (Throwable)e);
            return;
        }
        IDOMPosition position = null;
        position = node != null ? SourceViewerDragDropHelper.getInstance().findPosition(this._location, node) : (this.getModel().getDocument().getFirstChild() != null ? SourceViewerDragDropHelper.getInstance().findPosition(this.getModel().getDocument().getEndOffset(), this.getModel().getDocument().getFirstChild()) : new DOMPosition((Node)this.getModel().getDocument(), 0));
        IStatus status = this.performCustomization();
        if (status.getSeverity() == 0) {
            Element element = CommandUtil.excuteInsertion(this._tagItem, this.getModel(), position, this.getCustomizationData());
            if (element != null) {
                this.formatNode(element);
            }
            this._element = element;
        }
    }

    protected IStatus performCustomization() {
        IDropCustomizer customizer;
        IStatus status = Status.OK_STATUS;
        TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)this._tagItem.getURI(), (String)this._tagItem.getTagName());
        IElementEdit elementEdit = ElementEditFactoryRegistry.getInstance().createElementEdit(tagId);
        if (elementEdit != null && (customizer = elementEdit.getDropCustomizer(tagId)) != null && (status = customizer.runCustomizer()).getSeverity() == 0) {
            this.setCustomizationData(customizer.getDropCustomizationData());
        }
        return status;
    }

    public void setCustomizationData(IAdaptable customizationData) {
        this._customizationData = customizationData;
    }

    protected final IAdaptable getCustomizationData() {
        return this._customizationData;
    }

    public void setSelection() {
        if (this._element != null) {
            int offset = EditModelQuery.getNodeStartIndex(this._element);
            int length = EditModelQuery.getNodeEndIndex(this._element) - offset;
            this._editor.getTextViewer().setSelectedRange(offset, length);
        }
    }
}

