/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.w3c.dom.Element;

public class UpdateAttributeValueCommand
extends BaseCommand {
    protected Element element;
    protected String attributeName;
    protected String attributeValue;
    protected boolean deleteIfValueEmpty = false;

    public UpdateAttributeValueCommand(Element element, String attributeName, String attributeValue, boolean deleteIfValueEmpty) {
        this.element = element;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.deleteIfValueEmpty = deleteIfValueEmpty;
    }

    public UpdateAttributeValueCommand(Element element, String attributeName, String attributeValue, String label) {
        this(element, attributeName, attributeValue, false);
        this.setLabel(NLS.bind((String)Messages._UI_ACTION_CHANGE, (Object)label));
    }

    public UpdateAttributeValueCommand(Element element, String attributeName, String attributeValue) {
        this(element, attributeName, attributeValue, false);
        this.setLabel(NLS.bind((String)Messages._UI_ACTION_CHANGE, (Object)attributeName));
    }

    public void setDeleteIfEmpty(boolean v) {
        this.deleteIfValueEmpty = v;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.element);
            if (this.deleteIfValueEmpty && (this.attributeValue == null || this.attributeValue.equals(""))) {
                this.element.removeAttribute(this.attributeName);
            } else {
                this.element.setAttribute(this.attributeName, this.attributeValue);
            }
            this.doPostProcessing();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.endRecording();
    }

    protected void doPostProcessing() {
    }
}

