/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractLabelAndHelpOperation;
import org.w3c.dom.Element;

public class InputTextOperation
extends AbstractLabelAndHelpOperation {
    protected void appendControl(Element srcElement, Element parentElement) {
        Element controlElement;
        int rows = this.getRows(srcElement);
        if (rows < 2) {
            controlElement = this.appendChildElement("input", parentElement);
            this.appendAttribute(controlElement, "size", String.valueOf(this.getColumns(srcElement)));
            this.appendAttribute(controlElement, "type", this.getType(srcElement));
            String value = srcElement.getAttribute("value");
            if (value != null) {
                this.appendAttribute(controlElement, "value", value);
            }
        } else {
            controlElement = this.appendChildElement("textarea", parentElement);
            this.appendAttribute(controlElement, "cols", String.valueOf(this.getColumns(srcElement)));
            this.appendAttribute(controlElement, "rows", String.valueOf(this.getRows(srcElement)));
            this.appendAttribute(controlElement, "wrap", this.getWrap(srcElement));
            String value = srcElement.getAttribute("value");
            if (value != null) {
                this.appendChildText(value, controlElement);
            }
        }
        this.appendAttribute(controlElement, "style", this.calculateStyle("font-family:Arial,Helvetica,Geneva,sans-serif;font-size:10pt;font-weight:normal;color:#000000;", srcElement, "contentStyle"));
    }

    private int getRows(Element srcElement) {
        String rowsValue;
        int rows = 1;
        if (srcElement != null && (rowsValue = srcElement.getAttribute("rows")) != null && rowsValue.length() > 0) {
            try {
                rows = Integer.parseInt(rowsValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return rows;
    }

    private String getWrap(Element srcElement) {
        String wrapValue;
        String wrap = "soft";
        if (srcElement != null && (wrapValue = srcElement.getAttribute("wrap")) != null && wrapValue.length() > 0) {
            wrap = wrapValue;
        }
        return wrap;
    }

    private String getType(Element srcElement) {
        String secret;
        String type = "text";
        if (srcElement != null && Boolean.valueOf(secret = srcElement.getAttribute("secret")).booleanValue()) {
            type = "password";
        }
        return type;
    }
}

