/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryValidationEvent;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryValidationListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JSFLibraryEditControl
extends Composite
implements ModifyListener,
SelectionListener {
    private Text txtName;
    private Label lblName;
    private CCombo cboVersions;
    private Label lblVersions;
    private Button chkDeploy;
    private Button chkImpl;
    private Composite btnBar;
    private Button btnAdd;
    private Button btnRemove;
    private TableViewer jars;
    private boolean initing = false;
    private JSFLibrary workingCopyLibrary;
    private String validationMsg;
    private Set _listeners;
    private int _isNew = -1;

    public JSFLibraryEditControl(JSFLibrary workingCopyLibrary, Composite parent) {
        super(parent, 0);
        this.workingCopyLibrary = workingCopyLibrary;
        this._listeners = new HashSet(1);
        this.createControl(parent);
    }

    public void addValidationListener(JSFLibraryValidationListener listener) {
        this.removeValidationListener(listener);
        this._listeners.add(listener);
    }

    public void removeValidationListener(JSFLibraryValidationListener listener) {
        this._listeners.remove(listener);
    }

    public void createControl(Composite parent) {
        this.initing = true;
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(1808));
        this.lblName = new Label((Composite)this, 0);
        this.lblName.setText(Messages.JSFLibraryWizard_LibraryName);
        this.lblName.setLayoutData((Object)new GridData(1));
        this.txtName = new Text((Composite)this, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener((ModifyListener)this);
        this.lblVersions = new Label((Composite)this, 0);
        this.lblVersions.setText(Messages.JSFLibraryWizard_VersionSupported);
        this.cboVersions = new CCombo((Composite)this, 2060);
        this.cboVersions.setLayoutData((Object)new GridData(768));
        this.cboVersions.addModifyListener((ModifyListener)this);
        Group jarsComp = new Group((Composite)this, 0);
        jarsComp.setText(Messages.JSFLibraryWizard_LibraryJars);
        GridLayout gl1 = new GridLayout(2, false);
        jarsComp.setLayout((Layout)gl1);
        GridData gd2 = new GridData(1808);
        gd2.horizontalSpan = 2;
        jarsComp.setLayoutData((Object)gd2);
        this.createJarsViewer(jarsComp);
        this.createButtons((Composite)jarsComp);
        this.chkImpl = new Button((Composite)this, 32);
        this.chkImpl.setText(Messages.JSFLibraryWizard_IsJSFImplementation);
        GridData gd3 = new GridData();
        gd3.horizontalSpan = 2;
        this.chkImpl.setLayoutData((Object)gd3);
        this.chkImpl.addSelectionListener((SelectionListener)this);
        this.chkDeploy = new Button((Composite)this, 32);
        this.chkDeploy.setText(Messages.JSFLibraryWizard_DeployJars);
        GridData gd4 = new GridData();
        gd4.horizontalSpan = 2;
        this.chkDeploy.setLayoutData((Object)gd4);
        this.chkDeploy.setVisible(false);
        this.loadVersions();
        if (!this.isNew()) {
            this.txtName.setText(this.workingCopyLibrary.getName());
            if (this.workingCopyLibrary.getJSFVersion().getName().equals(JSFVersion.UNKNOWN_LITERAL.getName())) {
                this.cboVersions.setText(Messages.JSFLibraryEditControl_ImplVersion_UNKNOWN);
            } else {
                this.cboVersions.setText(this.workingCopyLibrary.getJSFVersion().getName());
            }
            this.chkDeploy.setSelection(this.workingCopyLibrary.isDeployed());
            this.chkImpl.setSelection(this.workingCopyLibrary.isImplementation());
        }
        this.jars.setInput((Object)this.workingCopyLibrary);
        this.initing = false;
        this.txtName.setFocus();
    }

    private void createJarsViewer(Group jarsComp) {
        this.jars = new TableViewer((Composite)jarsComp, 2050);
        this.jars.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof JSFLibrary) {
                    return ((JSFLibrary)inputElement).getArchiveFiles().toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.jars.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){
            private Image jarImg = null;

            public Image getImage(Object element) {
                if (this.jarImg == null) {
                    ImageDescriptor desc = JSFUiPlugin.getImageDescriptor("obj16/jar_obj.gif");
                    this.jarImg = desc.createImage();
                }
                return this.jarImg;
            }

            public String getText(Object element) {
                StringBuffer labelBuf = new StringBuffer();
                if (element instanceof ArchiveFile) {
                    ArchiveFile archive = (ArchiveFile)element;
                    labelBuf.append(archive.getName());
                    if (!archive.exists()) {
                        labelBuf.append(Messages.JSFLibrariesPreferencePage_MISSING_DESC);
                    }
                    labelBuf.append(" - ").append(archive.getPath());
                }
                return labelBuf.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
                if (this.jarImg != null) {
                    this.jarImg.dispose();
                }
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.jars.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFLibraryEditControl.this.updateButtons();
            }
        });
        GridData gd = new GridData(1808);
        this.jars.getControl().setLayoutData((Object)gd);
    }

    private void updateButtons() {
        this.btnRemove.setEnabled(!((StructuredSelection)this.jars.getSelection()).isEmpty());
    }

    private void createButtons(Composite c) {
        this.btnBar = new Composite(c, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        this.btnBar.setLayout((Layout)gl);
        this.btnBar.setLayoutData((Object)new GridData(3));
        this.btnAdd = new Button(this.btnBar, 0);
        this.btnAdd.setText(Messages.JSFLibraryWizard_Add);
        this.btnAdd.setLayoutData((Object)new GridData(258));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String cur = null;
                String[] chosenJars = JSFLibraryEditControl.this.openExtJarFileDialog(cur);
                if (chosenJars != null) {
                    int i = 0;
                    while (i < chosenJars.length) {
                        String jar = chosenJars[i];
                        if (!JSFLibraryEditControl.this.workingCopyLibrary.containsArchiveFile(jar)) {
                            ArchiveFile archive = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
                            archive.setSourceLocation(jar);
                            archive.setRelativeDestLocation("WEB-INF/lib");
                            JSFLibraryEditControl.this.workingCopyLibrary.getArchiveFiles().add((Object)archive);
                        }
                        ++i;
                    }
                    JSFLibraryEditControl.this.jars.refresh();
                    JSFLibraryEditControl.this.validate();
                }
            }
        });
        this.btnRemove = new Button(this.btnBar, 0);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setText(Messages.JSFLibraryWizard_Remove);
        this.btnRemove.setLayoutData((Object)new GridData(258));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JSFLibraryEditControl.this.jars.getSelection() instanceof StructuredSelection) {
                    StructuredSelection objs = (StructuredSelection)JSFLibraryEditControl.this.jars.getSelection();
                    if (objs != null) {
                        for (Object obj : objs) {
                            ArchiveFile jar = (ArchiveFile)obj;
                            JSFLibraryEditControl.this.workingCopyLibrary.getArchiveFiles().remove((Object)jar);
                        }
                    }
                    JSFLibraryEditControl.this.jars.refresh();
                    JSFLibraryEditControl.this.validate();
                }
            }
        });
    }

    private void loadVersions() {
        this.cboVersions.removeAll();
        for (JSFVersion ver : JSFVersion.VALUES) {
            if (ver.getName().equals(JSFVersion.UNKNOWN_LITERAL.getName())) {
                this.cboVersions.add(Messages.JSFLibraryEditControl_ImplVersion_UNKNOWN);
                continue;
            }
            this.cboVersions.add(ver.getName());
        }
    }

    private String[] openExtJarFileDialog(String existing) {
        String title = Messages.JSFLibraryWizard_ExtJarFileDialogTitle;
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        String filterPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath().toString();
        dialog.setFilterPath(filterPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        String[] elems = new String[fileNames.length];
        Path file = new Path(res);
        IPath apath = file.removeLastSegments(1);
        int i = 0;
        while (i < fileNames.length) {
            elems[i] = apath.append(fileNames[i]).toString();
            ++i;
        }
        return elems;
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
        this.updateButtons();
    }

    private void fireValidateEvent(final JSFLibraryValidationEvent jSFLibraryValidationEvent) {
        new Runnable(){

            public void run() {
                for (JSFLibraryValidationListener listener : JSFLibraryEditControl.this._listeners) {
                    listener.notifyValidation(jSFLibraryValidationEvent);
                }
            }
        }.run();
    }

    public void widgetSelected(SelectionEvent e) {
        this.validate();
        this.updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void validate() {
        if (this.initing) {
            return;
        }
        this.validationMsg = null;
        if (this.validateName() && this.validateJars()) {
            this.validateVersion();
        }
        this.fireValidateEvent(new JSFLibraryValidationEvent(this.validationMsg));
    }

    private boolean validateJars() {
        if (this.workingCopyLibrary.getArchiveFiles().isEmpty()) {
            this.validationMsg = Messages.JSFLibraryWizard_ValidateNoJars;
            return false;
        }
        return true;
    }

    private boolean validateVersion() {
        return true;
    }

    private boolean validateName() {
        if (this.txtName.getText() == null || this.txtName.getText().trim().equals("")) {
            this.validationMsg = Messages.JSFLibraryWizard_ValidateNoLibraryName;
            return false;
        }
        String aName = this.txtName.getText().trim();
        if ((this.isNew() || !this.isNew() && !this.getCurrentLibraryName().equals(aName)) && this.isNameInRegistry((Collection)JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getAllJSFLibraries(), aName)) {
            this.validationMsg = Messages.JSFLibraryWizard_ValidateExistingLibraryName;
            return false;
        }
        return true;
    }

    private boolean isNew() {
        if (this._isNew == -1) {
            int n = this._isNew = this.workingCopyLibrary.getName() == null ? 1 : 0;
        }
        return this._isNew == 1;
    }

    private String getCurrentLibraryName() {
        return this.workingCopyLibrary.getName();
    }

    private boolean isNameInRegistry(Collection c, String name) {
        for (JSFLibrary lib : c) {
            if (!lib.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getJSFLibraryName() {
        return this.txtName.getText().trim();
    }

    public boolean getIsDeployed() {
        return this.chkDeploy.getSelection();
    }

    public boolean getIsImplementation() {
        return this.chkImpl.getSelection();
    }

    public JSFVersion getJSFVersion() {
        if (this.cboVersions.getSelectionIndex() >= 0) {
            JSFVersion ver = (JSFVersion)JSFVersion.VALUES.get(this.cboVersions.getSelectionIndex());
            return ver;
        }
        return JSFVersion.UNKNOWN_LITERAL;
    }

    public void setImplOnly(boolean implsOnly) {
        if (implsOnly) {
            this.chkImpl.setSelection(true);
            this.chkImpl.setEnabled(false);
        }
    }

    public void setNonImplOnly(boolean nonImplsOnly) {
        if (nonImplsOnly) {
            this.chkImpl.setSelection(false);
            this.chkImpl.setEnabled(false);
        }
    }
}

