/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.EjbAnnotationFactory;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;
import org.eclipse.jst.jee.model.internal.common.MyModelProviderEvent;
import org.eclipse.jst.jee.model.internal.common.Result;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAnnotationReader
extends AbstractAnnotationModelProvider<EJBJar> {
    private static final String JAVA_EXTENSION = "java";
    private static int instances = 0;
    private IProject clientProject;
    private Map<IFile, JavaEEObject> resourceToModel;
    private ManyToOneRelation<BeanInterfaceRef, IFile> beanRefToResolvedInterface;
    private EjbAnnotationFactory annotationFactory;

    public EJBAnnotationReader(IFacetedProject project, IProject clientProject) {
        super(project);
        this.clientProject = clientProject;
        ++instances;
    }

    protected void loadModel() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.facetedProject.getProject());
        HashSet<IFile> javaFiles = new HashSet<IFile>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            this.visitJavaFiles(javaFiles, root);
            ++n2;
        }
        if (this.clientProject != null) {
            IJavaProject clientProjectJavaView = JavaCore.create((IProject)this.facetedProject.getProject());
            IPackageFragmentRoot[] iPackageFragmentRootArray2 = clientProjectJavaView.getAllPackageFragmentRoots();
            int n3 = iPackageFragmentRootArray2.length;
            n = 0;
            while (n < n3) {
                IPackageFragmentRoot root = iPackageFragmentRootArray2[n];
                this.visitJavaFiles(javaFiles, root);
                ++n;
            }
        }
        this.resourceToModel = new HashMap<IFile, JavaEEObject>();
        this.beanRefToResolvedInterface = new ManyToOneRelation();
        for (IFile file : javaFiles) {
            Result result = this.analyzeFileForBean(file);
            if (result == null) continue;
            this.processResult(file, result);
        }
    }

    protected void preLoad() {
        this.modelObject = EjbFactory.eINSTANCE.createEJBJar();
        ((EJBJar)this.modelObject).setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        this.annotationFactory = EjbAnnotationFactory.createFactory();
    }

    private void visitJavaFiles(final Collection<IFile> javaFiles, final IPackageFragmentRoot root) throws CoreException {
        if (root.getKind() != 1) {
            return;
        }
        root.getCorrespondingResource().accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    if (proxy.getName().endsWith(".java")) {
                        IFile file = (IFile)proxy.requestResource();
                        if (root.getJavaProject().isOnClasspath((IResource)file)) {
                            javaFiles.add(file);
                        }
                    }
                    return false;
                }
                return true;
            }
        }, 0);
    }

    private void processResult(IFile file, Result result) throws JavaModelException {
        JavaEEObject modelObject = result.getMainObject();
        if (SessionBean.class.isInstance(modelObject)) {
            this.sessionBeanFound(file, (SessionBean)modelObject, result.getDependedTypes());
        } else if (MessageDrivenBean.class.isInstance(modelObject)) {
            this.messageBeanFound(file, (MessageDrivenBean)modelObject, result.getDependedTypes());
        }
        for (JavaEEObject additional : result.getAdditional()) {
            if (!SecurityRole.class.isInstance(additional)) continue;
            this.securityRoleFound((JavaEEObject)((SessionBean)this.resourceToModel.get(file)), (SecurityRole)additional);
        }
    }

    private Result analyzeFileForBean(IFile file) throws JavaModelException {
        Assert.isTrue((boolean)JAVA_EXTENSION.equals(file.getFileExtension()), (String)"A file with extension different from \"java\" is analyzed for beans");
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (compilationUnit == null) {
            return null;
        }
        IType rootType = compilationUnit.findPrimaryType();
        if (rootType == null || !rootType.isClass()) {
            return null;
        }
        return this.annotationFactory.createJavaeeObject(rootType);
    }

    private void messageBeanFound(IFile file, MessageDrivenBean messageBean, Collection<IType> dependedTypes) throws JavaModelException {
        if (((EJBJar)this.modelObject).getEnterpriseBeans() == null) {
            ((EJBJar)this.modelObject).setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        }
        ((EJBJar)this.modelObject).getEnterpriseBeans().getMessageDrivenBeans().add(messageBean);
        this.connectBeanWithTypes(file, (JavaEEObject)messageBean, dependedTypes);
    }

    private void sessionBeanFound(IFile file, SessionBean sessionBean, Collection<IType> dependedTypes) throws JavaModelException {
        if (((EJBJar)this.modelObject).getEnterpriseBeans() == null) {
            ((EJBJar)this.modelObject).setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        }
        ((EJBJar)this.modelObject).getEnterpriseBeans().getSessionBeans().add(sessionBean);
        this.connectBeanWithTypes(file, (JavaEEObject)sessionBean, dependedTypes);
    }

    private void connectBeanWithTypes(IFile file, JavaEEObject bean, Collection<IType> dependedTypes) throws JavaModelException {
        this.resourceToModel.put(file, bean);
        new HashSet(dependedTypes.size());
        for (IType type : dependedTypes) {
            IResource resource;
            if (type.isBinary() || !type.isInterface() || (resource = type.getCompilationUnit().getCorrespondingResource()) == null || !resource.exists()) continue;
            this.beanRefToResolvedInterface.connect((Object)new BeanInterfaceRef(type.getFullyQualifiedName(), bean), (Object)((IFile)resource));
        }
    }

    public void dispose() {
        MyModelProviderEvent modelEvent = this.createModelProviderEvent();
        modelEvent.addResource((Object)this.facetedProject.getProject());
        modelEvent.setEventCode(modelEvent.getEventCode() | 0x10);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.resourceToModel = null;
        this.beanRefToResolvedInterface = null;
        this.modelObject = null;
        this.notifyListeners((IModelProviderEvent)modelEvent);
        this.clearListeners();
    }

    protected boolean isProjectRelative(IProject project) {
        if (super.isProjectRelative(project)) {
            return true;
        }
        return this.clientProject != null && project.equals((Object)this.clientProject.getProject());
    }

    protected synchronized void processAddedFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (unit == null) {
            return;
        }
        HashSet<IFile> filesToRebuild = new HashSet<IFile>();
        IType rootType = unit.getTypes()[0];
        if (rootType.isClass()) {
            Result result = this.analyzeFileForBean(file);
            if (result == null) {
                return;
            }
            this.processResult(file, result);
            modelEvent.addResource((Object)file);
        } else if (rootType.isInterface()) {
            String rootTypeSimpleName = rootType.getElementName();
            for (SessionBean bean : ((EJBJar)this.getConcreteModel()).getEnterpriseBeans().getSessionBeans()) {
                for (String inter : bean.getBusinessLocals()) {
                    if (!rootTypeSimpleName.equals(inter)) continue;
                    filesToRebuild.add(this.getResourceFromModel((JavaEEObject)bean));
                }
                if (rootTypeSimpleName.equals(bean.getLocalHome()) || rootTypeSimpleName.equals(bean.getHome())) {
                    filesToRebuild.add(this.getResourceFromModel((JavaEEObject)bean));
                }
                this.findDependedFiles((JavaEEObject)bean, rootTypeSimpleName, bean.getEjbLocalRefs(), bean.getResourceRefs(), filesToRebuild);
            }
            for (SessionBean bean : ((EJBJar)this.getConcreteModel()).getEnterpriseBeans().getMessageDrivenBeans()) {
                this.findDependedFiles((JavaEEObject)bean, rootTypeSimpleName, bean.getEjbLocalRefs(), bean.getResourceRefs(), filesToRebuild);
            }
        }
        if (filesToRebuild.isEmpty()) {
            return;
        }
        for (IFile changedFile : filesToRebuild) {
            this.processRemovedFile(modelEvent, changedFile);
            this.processAddedFile(modelEvent, changedFile);
        }
        filesToRebuild.clear();
    }

    private IFile getResourceFromModel(JavaEEObject bean) {
        for (Map.Entry<IFile, JavaEEObject> entry : this.resourceToModel.entrySet()) {
            if (!entry.getValue().equals(bean)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void findDependedFiles(JavaEEObject bean, String rootTypeSimpleName, Collection<EjbLocalRef> ejbRefs, Collection<ResourceRef> resourceRefs, Collection<IFile> filesToRebuild) {
        Iterator<EjbLocalRef> refsIter = ejbRefs.iterator();
        while (refsIter.hasNext()) {
            String localRefInterface = refsIter.next().getLocal();
            if (!rootTypeSimpleName.equals(localRefInterface)) continue;
            filesToRebuild.add(this.getResourceFromModel(bean));
        }
        refsIter = resourceRefs.iterator();
        while (refsIter.hasNext()) {
            String resourceRef = ((ResourceRef)refsIter.next()).getResType();
            if (!rootTypeSimpleName.equals(resourceRef)) continue;
            filesToRebuild.add(this.getResourceFromModel(bean));
        }
    }

    protected synchronized void processRemovedFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        if (this.resourceToModel.containsKey(file)) {
            this.processRemoveBean(modelEvent, file);
        } else if (this.beanRefToResolvedInterface.containsTarget((Object)file)) {
            this.processRemoveInterface(modelEvent, file);
        }
    }

    private void processRemoveInterface(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        Collection refs = this.beanRefToResolvedInterface.getSources((Object)file);
        HashSet<IFile> filesToRebuild = new HashSet<IFile>();
        for (BeanInterfaceRef ref : refs) {
            filesToRebuild.add(this.getResourceFromModel(ref.getModelObject()));
        }
        if (filesToRebuild.isEmpty()) {
            return;
        }
        for (IFile changedFile : filesToRebuild) {
            this.processRemovedFile(modelEvent, changedFile);
            this.processAddedFile(modelEvent, changedFile);
        }
        filesToRebuild.clear();
        this.beanRefToResolvedInterface.disconnect((Object)file);
    }

    private void processRemoveBean(IModelProviderEvent modelEvent, IFile file) throws JavaModelException {
        EObject modelObject = (EObject)this.resourceToModel.get(file);
        EcoreUtil.remove((EObject)modelObject);
        this.resourceToModel.remove(this.getResourceFromModel((JavaEEObject)modelObject));
        modelEvent.setEventCode(modelEvent.getEventCode() | 4);
        modelEvent.addResource((Object)file);
        this.disconnectFromRoles((JavaEEObject)modelObject);
    }

    protected synchronized void processChangedFile(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        if (this.resourceToModel.containsKey(file)) {
            this.processChangedBean(modelEvent, file);
        } else if (this.beanRefToResolvedInterface.containsTarget((Object)file)) {
            this.processChangedInterface(modelEvent, file);
        } else {
            this.processAddedFile(modelEvent, file);
        }
    }

    private void processChangedBean(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        EObject oldBean = (EObject)this.resourceToModel.get(file);
        IFile beanFile = this.getResourceFromModel((JavaEEObject)oldBean);
        this.processRemovedFile(modelEvent, beanFile);
        this.processAddedFile(modelEvent, beanFile);
    }

    private void processChangedInterface(IModelProviderEvent modelEvent, IFile file) throws CoreException {
        Collection references = this.beanRefToResolvedInterface.getSources((Object)file);
        for (BeanInterfaceRef ref : references) {
            IFile next = this.getResourceFromModel(ref.getModelObject());
            this.processRemovedFile(modelEvent, next);
            this.processAddedFile(modelEvent, next);
        }
    }

    public void modify(Runnable runnable, IPath modelPath) {
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        return null;
    }

    protected Collection<SecurityRoleRef> getSecurityRoleRefs(JavaEEObject target) {
        if (SessionBean.class.isInstance(target)) {
            return ((SessionBean)target).getSecurityRoleRefs();
        }
        return null;
    }

    protected Collection<SecurityRole> getSecurityRoles() {
        if (((EJBJar)this.modelObject).getAssemblyDescriptor() == null) {
            ((EJBJar)this.modelObject).setAssemblyDescriptor(EjbFactory.eINSTANCE.createAssemblyDescriptor());
        }
        return ((EJBJar)this.modelObject).getAssemblyDescriptor().getSecurityRoles();
    }

    private static class BeanInterfaceRef {
        private String interfacee;
        private JavaEEObject modelObject;

        public BeanInterfaceRef(String interfacee, JavaEEObject modelObject) {
            this.interfacee = interfacee;
            this.modelObject = modelObject;
        }

        public String getInterfacee() {
            return this.interfacee;
        }

        public JavaEEObject getModelObject() {
            return this.modelObject;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.interfacee == null ? 0 : this.interfacee.hashCode());
            result = 31 * result + (this.modelObject == null ? 0 : this.modelObject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanInterfaceRef other = (BeanInterfaceRef)obj;
            if (this.interfacee == null ? other.interfacee != null : !this.interfacee.equals(other.interfacee)) {
                return false;
            }
            return !(this.modelObject == null ? other.modelObject != null : !this.modelObject.equals(other.modelObject));
        }
    }
}

