/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationImpl;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EarUtilities
extends JavaEEProjectUtilities {
    public static IVirtualComponent getModule(IVirtualComponent earComponent, String moduleName) {
        if (moduleName == null) {
            return null;
        }
        if (moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar")) {
            moduleName = moduleName.substring(0, moduleName.length() - ".jar".length());
        }
        IVirtualReference[] references = EarUtilities.getComponentReferences(earComponent);
        int i = 0;
        while (i < references.length) {
            IVirtualComponent component = references[i].getReferencedComponent();
            if (component.getName().equals(moduleName)) {
                return component;
            }
            ++i;
        }
        return null;
    }

    public static IVirtualReference[] getJ2EEModuleReferences(IVirtualComponent earComponent) {
        ArrayList<String> j2eeTypes = new ArrayList<String>();
        j2eeTypes.add("jst.appclient");
        j2eeTypes.add("jst.connector");
        j2eeTypes.add("jst.ejb");
        j2eeTypes.add("jst.web");
        return EarUtilities.getComponentReferences(earComponent, j2eeTypes);
    }

    public static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent) {
        return EarUtilities.getComponentReferences(earComponent, Collections.EMPTY_LIST);
    }

    public static IVirtualReference getComponentReference(IVirtualComponent earComponent, String componentName) {
        IVirtualReference[] refs = EarUtilities.getComponentReferences(earComponent, Collections.EMPTY_LIST);
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            if (reference.getReferencedComponent().getName().equals(componentName)) {
                return reference;
            }
            ++i;
        }
        return null;
    }

    private static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent, List componentTypes) {
        List components = EarUtilities.getComponentReferencesAsList(earComponent, componentTypes);
        if (components.size() > 0) {
            return components.toArray(new IVirtualReference[components.size()]);
        }
        return NO_REFERENCES;
    }

    private static List getComponentReferencesAsList(IVirtualComponent earComponent, List componentTypes) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        if (earComponent != null && EarUtilities.isEARProject(earComponent.getProject())) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(EarUtilities.getJ2EEComponentType(module))) {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    public static boolean uriExists(String currentURI, IProject earProject) {
        StructureEdit edit = null;
        try {
            edit = StructureEdit.getStructureEditForRead((IProject)earProject);
            if (edit != null && edit.getComponent() != null) {
                EList referencedComps = edit.getComponent().getReferencedComponents();
                int i = 0;
                while (i < referencedComps.size()) {
                    String existingURI;
                    ReferencedComponent ref = (ReferencedComponent)referencedComps.get(i);
                    EObject module = ref.getDependentObject();
                    if (module != null && module instanceof org.eclipse.jst.j2ee.application.Module && (existingURI = ((org.eclipse.jst.j2ee.application.Module)module).getUri()) != null && existingURI.equals(currentURI)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return false;
    }

    public static IProject[] getReferencingEARProjects(IProject project) {
        if (project != null && EarUtilities.isEARProject(project)) {
            return new IProject[]{project};
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualComponent[] refComponents = component.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (EarUtilities.isEARProject(refComponents[i].getProject())) {
                    result.add(refComponents[i].getProject());
                }
                ++i;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static boolean isStandaloneProject(IProject project) {
        return EarUtilities.getReferencingEARProjects(project).length == 0;
    }

    public static IVirtualReference[] getUtilityModuleReferences(IVirtualComponent earComponent) {
        if (earComponent != null && EarUtilities.isEARProject(earComponent.getProject())) {
            List explicitUtilityReferences = EarUtilities.getComponentReferencesAsList(earComponent, Collections.singletonList("jst.utility"));
            List<String> implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb");
            List implicitUtilityReferences = EarUtilities.getComponentReferencesAsList(earComponent, implicitUtilityReferenceTypes);
            IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider(earComponent.getProject());
            ICommonApplication application = (ICommonApplication)earModel.getModelObject();
            Module module = null;
            IVirtualReference reference = null;
            Iterator referenceItr = implicitUtilityReferences.iterator();
            while (referenceItr.hasNext()) {
                module = null;
                reference = (IVirtualReference)referenceItr.next();
                if (application instanceof org.eclipse.jst.javaee.application.internal.impl.ApplicationImpl) {
                    module = ((org.eclipse.jst.javaee.application.internal.impl.ApplicationImpl)application).getFirstModule(reference.getArchiveName());
                } else if (application instanceof ApplicationImpl) {
                    module = ((ApplicationImpl)application).getFirstModule(reference.getArchiveName());
                }
                if (module == null) continue;
                referenceItr.remove();
            }
            ArrayList allUtilityModuleReferences = new ArrayList();
            allUtilityModuleReferences.addAll(explicitUtilityReferences);
            allUtilityModuleReferences.addAll(implicitUtilityReferences);
            if (allUtilityModuleReferences.size() > 0) {
                return allUtilityModuleReferences.toArray(new IVirtualReference[allUtilityModuleReferences.size()]);
            }
        }
        return NO_REFERENCES;
    }
}

