/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    public static final char QUOTE = '\"';

    public static String pad(String string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static void padOn(String string, int length, Writer writer) {
        StringTools.padOn(string, length, ' ', writer);
    }

    public static void padOn(String string, int length, StringBuffer sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static void padOn(String string, int length, StringBuilder sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static String pad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static char[] pad(char[] string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static void padOn(char[] string, int length, Writer writer) {
        StringTools.padOn(string, length, ' ', writer);
    }

    public static void padOn(char[] string, int length, StringBuffer sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static void padOn(char[] string, int length, StringBuilder sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static char[] pad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static String padOrTruncate(String string, int length) {
        return StringTools.padOrTruncate(string, length, ' ');
    }

    public static void padOrTruncateOn(String string, int length, Writer writer) {
        StringTools.padOrTruncateOn(string, length, ' ', writer);
    }

    public static void padOrTruncateOn(String string, int length, StringBuffer sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static void padOrTruncateOn(String string, int length, StringBuilder sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static String padOrTruncate(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(0, length);
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOrTruncateOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string.substring(0, length), writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOrTruncateOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(0, length));
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOrTruncateOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(0, length));
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static char[] padOrTruncate(char[] string, int length) {
        return StringTools.padOrTruncate(string, length, ' ');
    }

    public static void padOrTruncateOn(char[] string, int length, Writer writer) {
        StringTools.padOrTruncateOn(string, length, ' ', writer);
    }

    public static void padOrTruncate(char[] string, int length, StringBuffer sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static void padOrTruncate(char[] string, int length, StringBuilder sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static char[] padOrTruncate(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            char[] result = new char[length];
            System.arraycopy(string, 0, result, 0, length);
            return result;
        }
        return StringTools.pad_(string, length, c);
    }

    public static void padOrTruncateOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string, 0, length, writer);
        } else {
            StringTools.padOn_(string, length, c, writer);
        }
    }

    public static void padOrTruncateOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    public static void padOrTruncateOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringTools.padOn_(string, length, c, sb);
        }
    }

    private static String pad_(String string, int length, char c) {
        return new String(StringTools.pad_(string.toCharArray(), length, c));
    }

    private static void padOn_(String string, int length, char c, Writer writer) {
        StringTools.writeStringOn(string, writer);
        StringTools.fill_(string, length, c, writer);
    }

    private static void fill_(String string, int length, char c, Writer writer) {
        StringTools.fill_(string.length(), length, c, writer);
    }

    private static void fill_(char[] string, int length, char c, Writer writer) {
        StringTools.fill_(string.length, length, c, writer);
    }

    private static void fill_(int stringLength, int length, char c, Writer writer) {
        StringTools.writeStringOn(CollectionTools.fill(new char[length - stringLength], c), writer);
    }

    private static void padOn_(String string, int length, char c, StringBuffer sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    private static void fill_(String string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string.length(), length, c, sb);
    }

    private static void fill_(char[] string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string.length, length, c, sb);
    }

    private static void fill_(int stringLength, int length, char c, StringBuffer sb) {
        sb.append(CollectionTools.fill(new char[length - stringLength], c));
    }

    private static void padOn_(String string, int length, char c, StringBuilder sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    private static void fill_(String string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string.length(), length, c, sb);
    }

    private static void fill_(char[] string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string.length, length, c, sb);
    }

    private static void fill_(int stringLength, int length, char c, StringBuilder sb) {
        sb.append(CollectionTools.fill(new char[length - stringLength], c));
    }

    private static char[] pad_(char[] string, int length, char c) {
        char[] result = new char[length];
        int stringLength = string.length;
        System.arraycopy(string, 0, result, 0, stringLength);
        Arrays.fill(result, stringLength, length, c);
        return result;
    }

    private static void padOn_(char[] string, int length, char c, Writer writer) {
        StringTools.writeStringOn(string, writer);
        StringTools.fill_(string, length, c, writer);
    }

    private static void padOn_(char[] string, int length, char c, StringBuffer sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    private static void padOn_(char[] string, int length, char c, StringBuilder sb) {
        sb.append(string);
        StringTools.fill_(string, length, c, sb);
    }

    public static String zeroPad(String string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static void zeroPadOn(String string, int length, Writer writer) {
        StringTools.frontPadOn(string, length, '0', writer);
    }

    public static void zeroPadOn(String string, int length, StringBuffer sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static void zeroPadOn(String string, int length, StringBuilder sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static String frontPad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static char[] zeroPad(char[] string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static void zeroPadOn(char[] string, int length, Writer writer) {
        StringTools.frontPadOn(string, length, '0', writer);
    }

    public static void zeroPadOn(char[] string, int length, StringBuffer sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static void zeroPadOn(char[] string, int length, StringBuilder sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static char[] frontPad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static String zeroPadOrTruncate(String string, int length) {
        return StringTools.frontPadOrTruncate(string, length, '0');
    }

    public static void zeroPadOrTruncateOn(String string, int length, Writer writer) {
        StringTools.frontPadOrTruncateOn(string, length, '0', writer);
    }

    public static void zeroPadOrTruncateOn(String string, int length, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static void zeroPadOrTruncateOn(String string, int length, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static String frontPadOrTruncate(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(stringLength - length);
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, Writer writer) {
        int stringLength = string.length();
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string.substring(stringLength - length), writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, StringBuffer sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(stringLength - length));
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, StringBuilder sb) {
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string.substring(stringLength - length));
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static char[] zeroPadOrTruncate(char[] string, int length) {
        return StringTools.frontPadOrTruncate(string, length, '0');
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, Writer writer) {
        StringTools.frontPadOrTruncateOn(string, length, '0', writer);
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static char[] frontPadOrTruncate(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            char[] result = new char[length];
            System.arraycopy(string, stringLength - length, result, 0, length);
            return result;
        }
        return StringTools.frontPad_(string, length, c);
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string, stringLength - length, length, writer);
        } else {
            StringTools.frontPadOn_(string, length, c, writer);
        }
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringTools.frontPadOn_(string, length, c, sb);
        }
    }

    private static String frontPad_(String string, int length, char c) {
        return new String(StringTools.frontPad_(string.toCharArray(), length, c));
    }

    private static char[] frontPad_(char[] string, int length, char c) {
        char[] result = new char[length];
        int stringLength = string.length;
        int padLength = length - stringLength;
        System.arraycopy(string, 0, result, padLength, stringLength);
        Arrays.fill(result, 0, padLength, c);
        return result;
    }

    private static void frontPadOn_(String string, int length, char c, Writer writer) {
        StringTools.fill_(string, length, c, writer);
        StringTools.writeStringOn(string, writer);
    }

    private static void frontPadOn_(char[] string, int length, char c, Writer writer) {
        StringTools.fill_(string, length, c, writer);
        StringTools.writeStringOn(string, writer);
    }

    private static void frontPadOn_(String string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    private static void frontPadOn_(char[] string, int length, char c, StringBuffer sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    private static void frontPadOn_(String string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    private static void frontPadOn_(char[] string, int length, char c, StringBuilder sb) {
        StringTools.fill_(string, length, c, sb);
        sb.append(string);
    }

    public static String quote(String string) {
        return StringTools.wrap(string, '\"');
    }

    public static void quoteOn(String string, Writer writer) {
        StringTools.wrapOn(string, '\"', writer);
    }

    public static void quoteOn(String string, StringBuffer sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static void quoteOn(String string, StringBuilder sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static Iterator<String> quote(Iterator<String> strings) {
        return new TransformationIterator<String, String>(strings){

            @Override
            protected String transform(String string) {
                return StringTools.quote(string);
            }
        };
    }

    public static String wrap(String string, char wrap) {
        return new String(StringTools.wrap(string.toCharArray(), wrap));
    }

    public static void wrapOn(String string, char wrap, Writer writer) {
        StringTools.writeCharOn(wrap, writer);
        StringTools.writeStringOn(string, writer);
        StringTools.writeCharOn(wrap, writer);
    }

    public static void wrapOn(String string, char wrap, StringBuffer sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static void wrapOn(String string, char wrap, StringBuilder sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static Iterator<String> wrap(Iterator<String> strings, final char wrap) {
        return new TransformationIterator<String, String>(strings){

            @Override
            protected String transform(String string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static String wrap(String string, String wrap) {
        return new String(StringTools.wrap(string.toCharArray(), wrap.toCharArray()));
    }

    public static void wrapOn(String string, String wrap, Writer writer) {
        StringTools.writeStringOn(wrap, writer);
        StringTools.writeStringOn(string, writer);
        StringTools.writeStringOn(wrap, writer);
    }

    public static void wrapOn(String string, String wrap, StringBuffer sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static void wrapOn(String string, String wrap, StringBuilder sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static Iterator<String> wrap(Iterator<String> strings, final String wrap) {
        return new TransformationIterator<String, String>(strings){

            @Override
            protected String transform(String string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static char[] quote(char[] string) {
        return StringTools.wrap(string, '\"');
    }

    public static void quoteOn(char[] string, Writer writer) {
        StringTools.wrapOn(string, '\"', writer);
    }

    public static void quoteOn(char[] string, StringBuffer sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static void quoteOn(char[] string, StringBuilder sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static Iterator<char[]> quoteCharArrays(Iterator<char[]> strings) {
        return new TransformationIterator<char[], char[]>(strings){

            @Override
            protected char[] transform(char[] string) {
                return StringTools.quote(string);
            }
        };
    }

    public static char[] wrap(char[] string, char wrap) {
        int len = string.length;
        char[] result = new char[len + 2];
        result[0] = wrap;
        System.arraycopy(string, 0, result, 1, len);
        result[len + 1] = wrap;
        return result;
    }

    public static void wrapOn(char[] string, char wrap, Writer writer) {
        StringTools.writeCharOn(wrap, writer);
        StringTools.writeStringOn(string, writer);
        StringTools.writeCharOn(wrap, writer);
    }

    public static void wrapOn(char[] string, char wrap, StringBuffer sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static void wrapOn(char[] string, char wrap, StringBuilder sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static Iterator<char[]> wrapCharArrays(Iterator<char[]> strings, final char wrap) {
        return new TransformationIterator<char[], char[]>(strings){

            @Override
            protected char[] transform(char[] string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static char[] wrap(char[] string, char[] wrap) {
        int stringLength = string.length;
        int wrapLength = wrap.length;
        char[] result = new char[stringLength + 2 * wrapLength];
        System.arraycopy(wrap, 0, result, 0, wrapLength);
        System.arraycopy(string, 0, result, wrapLength, stringLength);
        System.arraycopy(wrap, 0, result, stringLength + wrapLength, wrapLength);
        return result;
    }

    public static void wrapOn(char[] string, char[] wrap, Writer writer) {
        StringTools.writeStringOn(wrap, writer);
        StringTools.writeStringOn(string, writer);
        StringTools.writeStringOn(wrap, writer);
    }

    public static void wrapOn(char[] string, char[] wrap, StringBuffer sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static void wrapOn(char[] string, char[] wrap, StringBuilder sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static Iterator<char[]> wrapCharArrays(Iterator<char[]> strings, final char[] wrap) {
        return new TransformationIterator<char[], char[]>(strings){

            @Override
            protected char[] transform(char[] string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static String removeFirstOccurrence(String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            return string;
        }
        if (index == 0) {
            return string.substring(1);
        }
        int last = string.length() - 1;
        if (index == last) {
            return string.substring(0, last);
        }
        return string.substring(0, index).concat(string.substring(index + 1));
    }

    public static void removeFirstOccurrenceOn(String string, char c, Writer writer) {
        int index = string.indexOf(c);
        if (index == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeFirstOccurrenceOn_(string.toCharArray(), c, writer, index);
        }
    }

    public static void removeFirstOccurrenceOn(String string, char c, StringBuffer sb) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeFirstOccurrenceOn_(string.toCharArray(), c, sb, index);
        }
    }

    public static void removeFirstOccurrenceOn(String string, char c, StringBuilder sb) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeFirstOccurrenceOn_(string.toCharArray(), c, sb, index);
        }
    }

    public static char[] removeFirstOccurrence(char[] string, char c) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            return string;
        }
        int last = string.length - 1;
        char[] result = new char[last];
        if (index == 0) {
            System.arraycopy(string, 1, result, 0, last);
        } else if (index == last) {
            System.arraycopy(string, 0, result, 0, last);
        } else {
            System.arraycopy(string, 0, result, 0, index);
            System.arraycopy(string, index + 1, result, index, last - index);
        }
        return result;
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, Writer writer) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeFirstOccurrenceOn_(string, c, writer, index);
        }
    }

    private static void removeFirstOccurrenceOn_(char[] string, char c, Writer writer, int index) {
        int last = string.length - 1;
        if (index == 0) {
            StringTools.writeStringOn(string, 1, last, writer);
        } else if (index == last) {
            StringTools.writeStringOn(string, 0, last, writer);
        } else {
            StringTools.writeStringOn(string, 0, index, writer);
            StringTools.writeStringOn(string, index + 1, last - index, writer);
        }
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, StringBuffer sb) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeFirstOccurrenceOn_(string, c, sb, index);
        }
    }

    private static void removeFirstOccurrenceOn_(char[] string, char c, StringBuffer sb, int index) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, StringBuilder sb) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringTools.removeFirstOccurrenceOn_(string, c, sb, index);
        }
    }

    private static void removeFirstOccurrenceOn_(char[] string, char c, StringBuilder sb, int index) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static String removeAllOccurrences(String string, char c) {
        int first = string.indexOf(c);
        return first == -1 ? string : new String(StringTools.removeAllOccurrences_(string.toCharArray(), c, first));
    }

    public static void removeAllOccurrencesOn(String string, char c, Writer writer) {
        int first = string.indexOf(c);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllOccurrencesOn_(string.toCharArray(), c, first, writer);
        }
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuffer sb) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string.toCharArray(), c, first, sb);
        }
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuilder sb) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string.toCharArray(), c, first, sb);
        }
    }

    public static char[] removeAllOccurrences(char[] string, char c) {
        int first = CollectionTools.indexOf(string, c);
        return first == -1 ? string : StringTools.removeAllOccurrences_(string, c, first);
    }

    private static char[] removeAllOccurrences_(char[] string, char c, int first) {
        StringBuilder sb = new StringBuilder(string.length);
        StringTools.removeAllOccurrencesOn_(string, c, first, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void removeAllOccurrencesOn(char[] string, char c, Writer writer) {
        int first = CollectionTools.indexOf(string, c);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllOccurrencesOn_(string, c, first, writer);
        }
    }

    private static void removeAllOccurrencesOn_(char[] string, char c, int first, Writer writer) {
        StringTools.writeStringOn(string, 0, first, writer);
        int len = string.length;
        int i = first;
        while (i < len) {
            char d = string[i];
            if (d != c) {
                StringTools.writeCharOn(d, writer);
            }
            ++i;
        }
    }

    public static void removeAllOccurrencesOn(char[] string, char c, StringBuffer sb) {
        int first = CollectionTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string, c, first, sb);
        }
    }

    private static void removeAllOccurrencesOn_(char[] string, char c, int first, StringBuffer sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllOccurrencesOn(char[] string, char c, StringBuilder sb) {
        int first = CollectionTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllOccurrencesOn_(string, c, first, sb);
        }
    }

    private static void removeAllOccurrencesOn_(char[] string, char c, int first, StringBuilder sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static void removeAllSpacesOn(String string, Writer writer) {
        StringTools.removeAllOccurrencesOn(string, ' ', writer);
    }

    public static void removeAllSpacesOn(String string, StringBuffer sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static void removeAllSpacesOn(String string, StringBuilder sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static char[] removeAllSpaces(char[] string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static void removeAllSpacesOn(char[] string, Writer writer) {
        StringTools.removeAllOccurrencesOn(string, ' ', writer);
    }

    public static void removeAllSpacesOn(char[] string, StringBuffer sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static void removeAllSpacesOn(char[] string, StringBuilder sb) {
        StringTools.removeAllOccurrencesOn(string, ' ', sb);
    }

    public static String removeAllWhitespace(String string) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        return first == -1 ? string : new String(StringTools.removeAllWhitespace_(string2, first));
    }

    public static void removeAllWhitespaceOn(String string, Writer writer) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllWhitespaceOn_(string2, first, writer);
        }
    }

    public static void removeAllWhitespaceOn(String string, StringBuffer sb) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string2, first, sb);
        }
    }

    public static void removeAllWhitespaceOn(String string, StringBuilder sb) {
        char[] string2 = string.toCharArray();
        int first = StringTools.indexOfWhitespace_(string2);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string2, first, sb);
        }
    }

    public static char[] removeAllWhitespace(char[] string) {
        int first = StringTools.indexOfWhitespace_(string);
        return first == -1 ? string : StringTools.removeAllWhitespace_(string, first);
    }

    private static int indexOfWhitespace_(char[] string) {
        int len = string.length;
        int i = 0;
        while (i < len) {
            if (Character.isWhitespace(string[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static char[] removeAllWhitespace_(char[] string, int first) {
        StringBuilder sb = new StringBuilder(string.length);
        StringTools.removeAllWhitespaceOn_(string, first, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void removeAllWhitespaceOn(char[] string, Writer writer) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.removeAllWhitespaceOn_(string, first, writer);
        }
    }

    private static void removeAllWhitespaceOn_(char[] string, int first, Writer writer) {
        StringTools.writeStringOn(string, 0, first, writer);
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                StringTools.writeCharOn(c, writer);
            }
            ++i;
        }
    }

    public static void removeAllWhitespaceOn(char[] string, StringBuffer sb) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string, first, sb);
        }
    }

    private static void removeAllWhitespaceOn_(char[] string, int first, StringBuffer sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void removeAllWhitespaceOn(char[] string, StringBuilder sb) {
        int first = StringTools.indexOfWhitespace_(string);
        if (first == -1) {
            sb.append(string);
        } else {
            StringTools.removeAllWhitespaceOn_(string, first, sb);
        }
    }

    private static void removeAllWhitespaceOn_(char[] string, int first, StringBuilder sb) {
        sb.append(string, 0, first);
        int len = string.length;
        int i = first;
        while (i < len) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static int commonPrefixLength(String s1, String s2) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return StringTools.commonPrefixLength_(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(String s1, String s2, int max) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray(), max);
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        return StringTools.commonPrefixLength_(s1, s2, Math.min(max, Math.min(s1.length, s2.length)));
    }

    private static int commonPrefixLength_(char[] s1, char[] s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1[i] != s2[i]) {
                return i;
            }
            ++i;
        }
        return max;
    }

    private static char[] capitalize_(char[] string) {
        string[0] = Character.toUpperCase(string[0]);
        return string;
    }

    public static char[] capitalize(char[] string) {
        if (string.length == 0 || Character.isUpperCase(string[0])) {
            return string;
        }
        return StringTools.capitalize_(string);
    }

    public static String capitalize(String string) {
        if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return new String(StringTools.capitalize_(string.toCharArray()));
    }

    private static void capitalizeOn_(char[] string, StringBuffer sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void capitalizeOn(char[] string, StringBuffer sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string, sb);
        }
    }

    public static void capitalizeOn(String string, StringBuffer sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void capitalizeOn_(char[] string, StringBuilder sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void capitalizeOn(char[] string, StringBuilder sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string, sb);
        }
    }

    public static void capitalizeOn(String string, StringBuilder sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void capitalizeOn_(char[] string, Writer writer) {
        StringTools.writeCharOn(Character.toUpperCase(string[0]), writer);
        StringTools.writeStringOn(string, 1, string.length - 1, writer);
    }

    public static void capitalizeOn(char[] string, Writer writer) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOn_(string, writer);
        }
    }

    public static void capitalizeOn(String string, Writer writer) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOn_(string.toCharArray(), writer);
        }
    }

    private static char[] uncapitalize_(char[] string) {
        string[0] = Character.toLowerCase(string[0]);
        return string;
    }

    private static boolean stringNeedNotBeUncapitalized_(char[] string) {
        if (string.length == 0) {
            return true;
        }
        if (Character.isLowerCase(string[0])) {
            return true;
        }
        return string.length > 1 && Character.isUpperCase(string[1]) && Character.isUpperCase(string[0]);
    }

    public static char[] uncapitalize(char[] string) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            return string;
        }
        return StringTools.uncapitalize_(string);
    }

    private static boolean stringNeedNotBeUncapitalized_(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (Character.isLowerCase(string.charAt(0))) {
            return true;
        }
        return string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0));
    }

    public static String uncapitalize(String string) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            return string;
        }
        return new String(StringTools.uncapitalize_(string.toCharArray()));
    }

    private static void uncapitalizeOn_(char[] string, StringBuffer sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalizeOn(char[] string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string, sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void uncapitalizeOn_(char[] string, StringBuilder sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalizeOn(char[] string, StringBuilder sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string, sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuilder sb) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOn_(string.toCharArray(), sb);
        }
    }

    private static void uncapitalizeOn_(char[] string, Writer writer) {
        StringTools.writeCharOn(Character.toLowerCase(string[0]), writer);
        StringTools.writeStringOn(string, 1, string.length - 1, writer);
    }

    public static void uncapitalizeOn(char[] string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOn_(string, writer);
        }
    }

    public static void uncapitalizeOn(String string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized_(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOn_(string.toCharArray(), writer);
        }
    }

    public static String buildToStringFor(Object o, Object additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn(o, sb);
        sb.append(" (");
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String buildToStringFor(Object o) {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn(o, sb);
        return sb.toString();
    }

    public static void buildSimpleToStringOn(Object o, StringBuffer sb) {
        sb.append(ClassTools.toStringClassNameForObject(o));
        sb.append('[');
        sb.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8));
        sb.append(']');
    }

    public static void buildSimpleToStringOn(Object o, StringBuilder sb) {
        sb.append(ClassTools.toStringClassNameForObject(o));
        sb.append('[');
        sb.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8));
        sb.append(']');
    }

    public static boolean stringIsEmpty(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return StringTools.stringIsEmpty_(string.toCharArray());
    }

    public static boolean stringIsEmpty(char[] string) {
        if (string == null || string.length == 0) {
            return true;
        }
        return StringTools.stringIsEmpty_(string);
    }

    private static boolean stringIsEmpty_(char[] s) {
        int i = s.length;
        while (i-- > 0) {
            if (Character.isWhitespace(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean stringsAreEqualIgnoreCase(char[] s1, char[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        int i = s1.length;
        while (i-- > 0) {
            if (StringTools.charactersAreEqualIgnoreCase(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringStartsWithIgnoreCase(char[] string, char[] prefix) {
        if (string.length < prefix.length) {
            return false;
        }
        int i = prefix.length;
        while (i-- > 0) {
            if (StringTools.charactersAreEqualIgnoreCase(string[i], prefix[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringStartsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean charactersAreEqualIgnoreCase(char c1, char c2) {
        return c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString) {
        int len = camelCaseString.length();
        if (len == 0) {
            return camelCaseString;
        }
        return new String(StringTools.convertCamelCaseToAllCaps_(camelCaseString.toCharArray(), len));
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString) {
        int len = camelCaseString.length;
        if (len == 0) {
            return camelCaseString;
        }
        return StringTools.convertCamelCaseToAllCaps_(camelCaseString, len);
    }

    private static char[] convertCamelCaseToAllCaps_(char[] camelCaseString, int len) {
        StringBuilder sb = new StringBuilder(len * 2);
        StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, StringBuffer sb) {
        int len = camelCaseString.length();
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, StringBuffer sb) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, StringBuilder sb) {
        int len = camelCaseString.length();
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, StringBuilder sb) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, Writer writer) {
        int len = camelCaseString.length();
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), len, writer);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, Writer writer) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, len, writer);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                StringTools.writeCharOn('_', writer);
            }
            StringTools.writeCharOn(Character.toUpperCase(c), writer);
            prev = c;
            ++i;
        }
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString, int maxLength) {
        int len = camelCaseString.length();
        if (len == 0 || maxLength == 0) {
            return camelCaseString;
        }
        return new String(StringTools.convertCamelCaseToAllCaps_(camelCaseString.toCharArray(), maxLength, len));
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength) {
        int len = camelCaseString.length;
        if (len == 0 || maxLength == 0) {
            return camelCaseString;
        }
        return StringTools.convertCamelCaseToAllCaps_(camelCaseString, maxLength, len);
    }

    private static char[] convertCamelCaseToAllCaps_(char[] camelCaseString, int maxLength, int len) {
        StringBuilder sb = new StringBuilder(maxLength);
        StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, StringBuffer sb) {
        int len = camelCaseString.length();
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), maxLength, len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, StringBuffer sb) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int maxLength, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, StringBuilder sb) {
        int len = camelCaseString.length();
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), maxLength, len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, StringBuilder sb) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int maxLength, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, Writer writer) {
        int len = camelCaseString.length();
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString.toCharArray(), maxLength, len, writer);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, Writer writer) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOn_(camelCaseString, maxLength, len, writer);
        }
    }

    private static void convertCamelCaseToAllCapsOn_(char[] camelCaseString, int maxLength, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int writerLength = 0;
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak_(prev, c, next)) {
                StringTools.writeCharOn('_', writer);
                if (++writerLength == maxLength) {
                    return;
                }
            }
            StringTools.writeCharOn(Character.toUpperCase(c), writer);
            if (++writerLength == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    private static boolean camelCaseWordBreak_(char prev, char c, char next) {
        if (prev == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return false;
        }
        if (Character.isLowerCase(prev)) {
            return true;
        }
        if (next == '\u0000') {
            return false;
        }
        return Character.isLowerCase(next);
    }

    public static String convertUnderscoresToCamelCase(String underscoreString) {
        return StringTools.convertUnderscoresToCamelCase(underscoreString, true);
    }

    public static char[] convertUnderscoresToCamelCase(char[] underscoreString) {
        return StringTools.convertUnderscoresToCamelCase(underscoreString, true);
    }

    public static String convertUnderscoresToCamelCase(String underscoreString, boolean capitalizeFirstLetter) {
        int len = underscoreString.length();
        if (len == 0) {
            return underscoreString;
        }
        return new String(StringTools.convertUnderscoresToCamelCase_(underscoreString.toCharArray(), capitalizeFirstLetter, len));
    }

    public static char[] convertUnderscoresToCamelCase(char[] underscoreString, boolean capitalizeFirstLetter) {
        int len = underscoreString.length;
        if (len == 0) {
            return underscoreString;
        }
        return StringTools.convertUnderscoresToCamelCase_(underscoreString, capitalizeFirstLetter, len);
    }

    private static char[] convertUnderscoresToCamelCase_(char[] underscoreString, boolean capitalizeFirstLetter, int len) {
        StringBuilder sb = new StringBuilder(len);
        StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, StringBuffer sb) {
        int len = underscoreString.length();
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString.toCharArray(), capitalizeFirstLetter, len, sb);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, StringBuffer sb) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, sb);
        }
    }

    private static void convertUnderscoresToCamelCaseOn_(char[] underscoreString, boolean capitalizeFirstLetter, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    if (capitalizeFirstLetter) {
                        sb.append(Character.toUpperCase(c));
                    } else {
                        sb.append(Character.toLowerCase(c));
                    }
                } else if (prev == '_') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, StringBuilder sb) {
        int len = underscoreString.length();
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString.toCharArray(), capitalizeFirstLetter, len, sb);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, StringBuilder sb) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, sb);
        }
    }

    private static void convertUnderscoresToCamelCaseOn_(char[] underscoreString, boolean capitalizeFirstLetter, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    if (capitalizeFirstLetter) {
                        sb.append(Character.toUpperCase(c));
                    } else {
                        sb.append(Character.toLowerCase(c));
                    }
                } else if (prev == '_') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, Writer writer) {
        int len = underscoreString.length();
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString.toCharArray(), capitalizeFirstLetter, len, writer);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, Writer writer) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOn_(underscoreString, capitalizeFirstLetter, len, writer);
        }
    }

    private static void convertUnderscoresToCamelCaseOn_(char[] underscoreString, boolean capitalizeFirstLetter, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    if (capitalizeFirstLetter) {
                        StringTools.writeCharOn(Character.toUpperCase(c), writer);
                    } else {
                        StringTools.writeCharOn(Character.toLowerCase(c), writer);
                    }
                } else if (prev == '_') {
                    StringTools.writeCharOn(Character.toUpperCase(c), writer);
                } else {
                    StringTools.writeCharOn(Character.toLowerCase(c), writer);
                }
            }
            ++i;
        }
    }

    public static char[] convertToCharArray(StringBuffer sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static char[] convertToCharArray(StringBuilder sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    private static void writeStringOn(char[] string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(char[] string, int off, int len, Writer writer) {
        try {
            writer.write(string, off, len);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(String string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeCharOn(char c, Writer writer) {
        try {
            writer.write(c);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }
}

