/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.utility.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedObject<T>
implements Cloneable,
Serializable {
    private T value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedObject(T value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedObject(T value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedObject() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T value() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(T value) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.value != value) {
                this.value = value;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(null);
        }
    }

    public Object mutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(T v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value != v) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIsNot(T v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value == v) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(T v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(v);
            this.setValue(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotNull();
            this.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(T v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (timeout != 0L) break block5;
                this.waitUntilValueIs(v);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value != v && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value == v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIsNot(T v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (timeout != 0L) break block5;
                this.waitUntilValueIsNot(v);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value == v && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value != v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(null, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIsNot(null, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(T v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIsNot(v, timeout);
            if (success) {
                this.setValue(v);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetNull(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilNotNull(timeout);
            if (success) {
                this.setValue(null);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedObject<T> clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                SynchronizedObject clone = (SynchronizedObject)super.clone();
                return clone;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SynchronizedObject)) {
            return false;
        }
        T v1 = this.value();
        T v2 = ((SynchronizedObject)obj).value();
        return v1 == null ? v2 == null : v1.equals(v2);
    }

    public int hashCode() {
        T v = this.value();
        return v == null ? 0 : v.hashCode();
    }

    public String toString() {
        return String.valueOf(this.value());
    }
}

