/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneListIterator<E>
implements ListIterator<E> {
    private final ListIterator<Object> nestedListIterator;
    private int cursor;
    private String state;
    private final Mutator<E> mutator;
    private static final String UNKNOWN = "unknown";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";

    public CloneListIterator(List<? extends E> list) {
        this(list, Mutator.ReadOnly.instance());
    }

    public CloneListIterator(List<? extends E> list, Mutator<E> mutator) {
        this.nestedListIterator = CollectionTools.list(list.toArray()).listIterator();
        this.mutator = mutator;
        this.cursor = 0;
        this.state = UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.nestedListIterator.hasNext();
    }

    @Override
    public E next() {
        E next = this.nestedNext();
        ++this.cursor;
        this.state = NEXT;
        return next;
    }

    @Override
    public void remove() {
        this.nestedListIterator.remove();
        if (this.state == PREVIOUS) {
            this.remove(this.cursor);
        } else {
            --this.cursor;
            this.remove(this.cursor);
        }
    }

    @Override
    public int nextIndex() {
        return this.nestedListIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.nestedListIterator.previousIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.nestedListIterator.hasPrevious();
    }

    @Override
    public E previous() {
        E previous = this.nestedPrevious();
        --this.cursor;
        this.state = PREVIOUS;
        return previous;
    }

    @Override
    public void add(E o) {
        this.nestedListIterator.add(o);
        this.add(this.cursor, o);
        ++this.cursor;
    }

    @Override
    public void set(E o) {
        this.nestedListIterator.set(o);
        if (this.state == PREVIOUS) {
            this.set(this.cursor, o);
        } else {
            this.set(this.cursor - 1, o);
        }
    }

    protected E nestedNext() {
        return (E)this.nestedListIterator.next();
    }

    protected E nestedPrevious() {
        return (E)this.nestedListIterator.previous();
    }

    protected void add(int index, E o) {
        this.mutator.add(index, o);
    }

    protected void remove(int index) {
        this.mutator.remove(index);
    }

    protected void set(int index, E o) {
        this.mutator.set(index, o);
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mutator<T> {
        public void add(int var1, T var2);

        public void remove(int var1);

        public void set(int var1, T var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ReadOnly<S>
        implements Mutator<S> {
            public static final Mutator INSTANCE = new ReadOnly();

            public static <R> Mutator<R> instance() {
                return INSTANCE;
            }

            private ReadOnly() {
            }

            @Override
            public void add(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "CloneListIterator.Mutator.ReadOnly";
            }
        }
    }
}

