/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueListAdapter<T extends Model>
extends ValueAspectAdapter<T> {
    protected final String[] listNames;
    protected final ListChangeListener valueListListener;

    public ValueListAdapter(WritablePropertyValueModel<T> valueHolder, String ... listNames) {
        super(valueHolder);
        this.listNames = listNames;
        this.valueListListener = this.buildValueListListener();
    }

    protected ListChangeListener buildValueListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                ValueListAdapter.this.valueAspectChanged();
            }

            public void itemsRemoved(ListChangeEvent event) {
                ValueListAdapter.this.valueAspectChanged();
            }

            public void itemsReplaced(ListChangeEvent event) {
                ValueListAdapter.this.valueAspectChanged();
            }

            public void itemsMoved(ListChangeEvent event) {
                ValueListAdapter.this.valueAspectChanged();
            }

            public void listCleared(ListChangeEvent event) {
                ValueListAdapter.this.valueAspectChanged();
            }

            public void listChanged(ListChangeEvent event) {
                ValueListAdapter.this.valueAspectChanged();
            }

            public String toString() {
                return "value list listener: " + Arrays.asList(ValueListAdapter.this.listNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.value).addListChangeListener(listName, this.valueListListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.value).removeListChangeListener(listName, this.valueListListener);
            ++n2;
        }
    }
}

