/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class BusinessInterface {
    private IType javaType;
    private String name;
    private BusinessInterfaceType type;

    public BusinessInterface(IType javaType, BusinessInterfaceType type) {
        this(javaType.getFullyQualifiedName(), type);
        this.javaType = javaType;
    }

    public BusinessInterface(String name, BusinessInterfaceType type) {
        this.name = name;
        this.type = type;
    }

    public String getFullyQualifiedName() {
        return this.name;
    }

    public String getSimpleName() {
        return Signature.getSimpleName((String)this.name);
    }

    public IType getJavaType() {
        return this.javaType;
    }

    public boolean exists() {
        return this.javaType != null;
    }

    public BusinessInterfaceType getType() {
        return this.type;
    }

    public boolean isLocal() {
        return this.type == BusinessInterfaceType.LOCAL;
    }

    public boolean isRemote() {
        return this.type == BusinessInterfaceType.REMOTE;
    }

    public boolean hasUnimplementedMethod() throws JavaModelException {
        if (this.javaType != null) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.javaType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                int flags;
                IMethod method = iMethodArray[n2];
                boolean resolved = method.isResolved();
                if (!resolved && (Flags.isAbstract((int)(flags = method.getFlags())) || Flags.isInterface((int)flags))) {
                    method.getParameterTypes();
                }
                ++n2;
            }
        }
        return false;
    }

    public void setFullyQualifiedName(String newName) {
        this.name = newName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BusinessInterfaceType {
        LOCAL,
        REMOTE;

    }
}

