/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.AddSessionBeanOperation;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewEnterpriseBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.ejb.internal.operations.StateType;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSessionBeanClassDataModelProvider
extends NewEnterpriseBeanClassDataModelProvider {
    public static final int STATE_TYPE_STATELESS_INDEX = 0;
    public static final int STATE_TYPE_STATEFUL_INDEX = 1;
    private static final String LOCAL_SUFFIX = "Local";
    private static final String REMOTE_SUFFIX = "Remote";
    private static final String LOCAL_HOME_SUFFIX = "LocalHome";
    private static final String REMOTE_HOME_SUFFIX = "RemoteHome";
    private static final String LOCAL_COMPONENT_SUFFIX = "LocalComponent";
    private static final String REMOTE_COMPONENT_SUFFIX = "RemoteComponent";

    public IDataModelOperation getDefaultOperation() {
        return new AddSessionBeanOperation(this.getDataModel());
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = super.getPropertyNames();
        propertyNames.add("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL");
        propertyNames.add("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_COMPONENT_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_COMPONENT_INTERFACE");
        return propertyNames;
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE_HOME")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL_HOME")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.STATE_TYPE")) {
            return StateType.STATELESS.toString();
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            ArrayList<BusinessInterface> listResult = new ArrayList<BusinessInterface>();
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            if (((Boolean)this.getProperty("INewSessionBeanClassDataModelProperties.REMOTE")).booleanValue() && className.length() > 0) {
                BusinessInterface remoteInterface = new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.REMOTE);
                listResult.add(remoteInterface);
            }
            if (((Boolean)this.getProperty("INewSessionBeanClassDataModelProperties.LOCAL")).booleanValue() && className.length() > 0) {
                BusinessInterface localInterface = new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.LOCAL);
                listResult.add(localInterface);
            }
            return listResult;
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + (className != null && className.length() > 0 ? REMOTE_SUFFIX : "");
        }
        if ("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + (className != null && className.length() > 0 ? LOCAL_SUFFIX : "");
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + REMOTE_HOME_SUFFIX;
        }
        if ("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + LOCAL_HOME_SUFFIX;
        }
        if ("INewSessionBeanClassDataModelProperties.LOCAL_COMPONENT_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + LOCAL_COMPONENT_SUFFIX;
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_COMPONENT_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + REMOTE_COMPONENT_SUFFIX;
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            if (!this.getDataModel().isPropertySet("NewJavaClassDataModel.INTERFACES")) {
                this.getDataModel().notifyPropertyChange("NewJavaClassDataModel.INTERFACES", 2);
                this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE", 1);
            } else {
                this.updateBusinessInterfaces("INewSessionBeanClassDataModelProperties.REMOTE");
            }
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL") && !this.getDataModel().isPropertySet("NewJavaClassDataModel.INTERFACES")) {
            this.getDataModel().notifyPropertyChange("NewJavaClassDataModel.INTERFACES", 2);
            this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE", 1);
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE".equals(propertyName)) {
            if (this.getRemoteProperty() != null) {
                this.getRemoteProperty().setFullyQualifiedName(propertyValue.toString());
            }
        } else if ("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE".equals(propertyName)) {
            if (this.getLocalProperty() != null) {
                this.getLocalProperty().setFullyQualifiedName(propertyName);
            }
        } else if ("NewJavaClassDataModel.CLASS_NAME".equals(propertyName) || "NewJavaClassDataModel.JAVA_PACKAGE".equals(propertyName)) {
            BusinessInterface localInterface;
            IDataModel dataModel = this.getDataModel();
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            BusinessInterface remoteInterface = this.getRemoteProperty();
            if (remoteInterface != null) {
                remoteInterface.setFullyQualifiedName(String.valueOf(className) + REMOTE_SUFFIX);
                dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE", 2);
            }
            if ((localInterface = this.getLocalProperty()) != null) {
                localInterface.setFullyQualifiedName(String.valueOf(className) + LOCAL_SUFFIX);
                dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE", 2);
            }
            dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE", 2);
            dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE", 2);
            dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_COMPONENT_INTERFACE", 2);
            dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_COMPONENT_INTERFACE", 2);
        }
        return result;
    }

    @Override
    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.STATE_TYPE")) {
            return DataModelPropertyDescriptor.createDescriptors((Object[])new String[]{StateType.STATELESS.toString(), StateType.STATEFUL.toString()}, (String[])new String[]{EJBCreationResourceHandler.STATE_TYPE_STATELESS, EJBCreationResourceHandler.STATE_TYPE_STATEFUL});
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    private void updateBusinessInterfaces(String propertyName) {
        List list = (List)this.getProperty("NewJavaClassDataModel.INTERFACES");
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            if (this.getBooleanProperty(propertyName)) {
                list.add(new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.REMOTE));
            } else {
                BusinessInterface remoteInterface = this.getRemoteProperty();
                int indexOf = list.indexOf(remoteInterface);
                list.remove(indexOf);
            }
        } else if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL")) {
            if (this.getBooleanProperty(propertyName)) {
                Signature.getSimpleName((String)this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
                list.add(new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.LOCAL));
            } else {
                BusinessInterface localInterface = this.getLocalProperty();
                int indexOf = list.indexOf(localInterface);
                list.remove(indexOf);
            }
        }
    }

    private BusinessInterface getRemoteProperty() {
        List businessInterfaces = (List)this.getProperty("NewJavaClassDataModel.INTERFACES");
        for (BusinessInterface iface : businessInterfaces) {
            if (iface.getJavaType() != null || !iface.isRemote()) continue;
            return iface;
        }
        return null;
    }

    private BusinessInterface getLocalProperty() {
        List businessInterfaces = (List)this.getProperty("NewJavaClassDataModel.INTERFACES");
        for (BusinessInterface iface : businessInterfaces) {
            if (iface.getJavaType() != null || !iface.isLocal()) continue;
            return iface;
        }
        return null;
    }

    @Override
    public IStatus validate(String propertyName) {
        if ("INewEnterpriseBeanClassDataModelProperties.EJB_NAME".equals(propertyName)) {
            return this.validateEjbName();
        }
        if ("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE".equals(propertyName)) {
            if (this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL")) {
                return this.validateEjbInterface(this.getStringProperty(propertyName));
            }
        } else if ("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE".equals(propertyName)) {
            if (this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE")) {
                return this.validateEjbInterface(this.getStringProperty(propertyName));
            }
        } else if ("INewSessionBeanClassDataModelProperties.LOCAL_COMPONENT_INTERFACE".equals(propertyName) || "INewSessionBeanClassDataModelProperties.REMOTE_COMPONENT_INTERFACE".equals(propertyName) || "INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE".equals(propertyName) || "INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE".equals(propertyName)) {
            return this.validateComponentHomeInterfaces();
        }
        return super.validate(propertyName);
    }

    protected IStatus validateEjbInterface(String fullyQualifiedName) {
        IStatus existsStatus;
        IStatus status = this.validateJavaTypeName(fullyQualifiedName);
        if (status.getSeverity() != 4 && (existsStatus = this.canCreateTypeInClasspath(Signature.getQualifier((String)fullyQualifiedName), Signature.getSimpleName((String)fullyQualifiedName))).matches(6)) {
            status = existsStatus;
        }
        return status;
    }

    private IStatus validateEjbName() {
        IModelProvider provider;
        EJBJar modelObject;
        EnterpriseBeans enterpriseBeans;
        String projectName = this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0 && (enterpriseBeans = (modelObject = (EJBJar)(provider = ModelProviderManager.getModelProvider((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))).getModelObject()).getEnterpriseBeans()) != null) {
            List sessionBeans = enterpriseBeans.getSessionBeans();
            for (Object object : sessionBeans) {
                SessionBean session = (SessionBean)object;
                if (!session.getEjbName().equals(this.getDataModel().getStringProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME"))) continue;
                return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.ERR_BEAN_ALREADY_EXISTS);
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateComponentHomeInterfaces() {
        IStatus result = Status.OK_STATUS;
        String projectName = this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                String localComponentInterface;
                String localHomeInterface;
                IType findType;
                if (this.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME")) {
                    String remoteComponentInterface;
                    String remoteHomeInterface = this.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE");
                    result = this.validate2xInterfaces(javaProject, remoteHomeInterface, remoteComponentInterface = this.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_COMPONENT_INTERFACE"), false);
                    if (!result.isOK()) {
                        return result;
                    }
                    if (result.isOK()) {
                        findType = javaProject.findType(remoteHomeInterface);
                        if (findType == null || !findType.exists()) {
                            result = this.validateEjbInterface(remoteHomeInterface);
                        }
                        if (((findType = javaProject.findType(remoteComponentInterface)) == null || !findType.exists()) && result.isOK()) {
                            result = this.validateEjbInterface(remoteComponentInterface);
                        }
                    }
                }
                if (this.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME") && (result = this.validate2xInterfaces(javaProject, localHomeInterface = this.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE"), localComponentInterface = this.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_COMPONENT_INTERFACE"), true)).isOK()) {
                    findType = javaProject.findType(localHomeInterface);
                    if (findType == null || !findType.exists()) {
                        result = this.validateEjbInterface(localHomeInterface);
                    }
                    if (((findType = javaProject.findType(localComponentInterface)) == null || !findType.exists()) && result.isOK()) {
                        result = this.validateEjbInterface(localComponentInterface);
                    }
                }
            }
            catch (JavaModelException e) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(EJBCreationResourceHandler.ERR_COULD_NOT_RESOLVE_INTERFACE) + e.getMessage()));
            }
        }
        return result;
    }

    private IStatus validate2xInterfaces(IJavaProject javaProject, String rhI, String rI, boolean isLocal) throws JavaModelException {
        IType component;
        IType home;
        block12: {
            block13: {
                block10: {
                    block11: {
                        home = javaProject.findType(rhI);
                        component = javaProject.findType(rI);
                        if (home == null) break block10;
                        if (!home.isInterface()) break block11;
                        String[] stringArray = new String[1];
                        String string = stringArray[0] = isLocal ? "EjbLocalHome" : "EjbHome";
                        if (this.hasRequiredElementInSignature(home.getSuperInterfaceTypeSignatures(), stringArray)) break block10;
                    }
                    String msg = isLocal ? EJBCreationResourceHandler.ERR_LOCAL_HOME_NOT_INTERFACE : EJBCreationResourceHandler.ERR_REMOTE_HOME_NOT_INTERFACE;
                    return new Status(4, "org.eclipse.jst.j2ee.ejb", msg);
                }
                if (component == null) break block12;
                if (!component.isInterface()) break block13;
                String[] stringArray = new String[1];
                String string = stringArray[0] = isLocal ? "EjbLocalObject" : "EjbObject";
                if (this.hasRequiredElementInSignature(component.getSuperInterfaceTypeSignatures(), stringArray)) break block12;
            }
            String msg = isLocal ? EJBCreationResourceHandler.ERR_LOCAL_COMPONENT_NOT_INTERFACE : EJBCreationResourceHandler.ERR_REMOTE_COMPONENT_NOT_INTERFACE;
            return new Status(4, "org.eclipse.jst.j2ee.ejb", msg);
        }
        if (home == null) {
            return Status.OK_STATUS;
        }
        IMethod createMehod = home.getMethod("create", null);
        if (createMehod == null || !createMehod.exists() || !this.hasRequiredElementInSignature(createMehod.getExceptionTypes(), new String[]{"CreateException", "RemoteException"})) {
            String msg = isLocal ? EJBCreationResourceHandler.ERR_LOCAL_HOME_MISSING_CREATE_METHOD : EJBCreationResourceHandler.ERR_REMOTE_HOME_MISSING_CREATE_METHOD;
            return new Status(4, "org.eclipse.jst.j2ee.ejb", msg);
        }
        if (component == null && !rI.endsWith("." + Signature.getSignatureSimpleName((String)createMehod.getReturnType()))) {
            String msg = isLocal ? EJBCreationResourceHandler.ERR_LOCAL_HOME_CREATE_METHOD_RETURN_TYPE_INVALID : EJBCreationResourceHandler.ERR_REMOTE_HOME_CREATE_METHOD_RETURN_TYPE_INVALID;
            return new Status(4, "org.eclipse.jst.j2ee.ejb", msg);
        }
        if (!component.getElementName().equals(Signature.getSignatureSimpleName((String)createMehod.getReturnType()))) {
            String msg = isLocal ? EJBCreationResourceHandler.ERR_LOCAL_HOME_CREATE_METHOD_RETURN_TYPE_INVALID : EJBCreationResourceHandler.ERR_REMOTE_HOME_CREATE_METHOD_RETURN_TYPE_INVALID;
            return new Status(4, "org.eclipse.jst.j2ee.ejb", msg);
        }
        return Status.OK_STATUS;
    }

    private boolean hasRequiredElementInSignature(String[] allElementNames, String[] wanted) {
        if (allElementNames == null || allElementNames.length == 0) {
            return false;
        }
        int found = 0;
        int j = 0;
        while (j < wanted.length) {
            if (wanted[j] != null) {
                int i = 0;
                while (i < allElementNames.length) {
                    if (allElementNames[i] != null && wanted[j].equals(Signature.toString((String)allElementNames[i]))) {
                        if (++found != wanted.length) break;
                        return true;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return false;
    }

    protected IStatus validateJavaTypeName(String className) {
        IStatus javaStatus = JavaConventions.validateJavaTypeName((String)className);
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_CLASS_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_CLASS_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

