/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.common;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.InjectionTarget;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ResAuthType;
import org.eclipse.jst.javaee.core.ResSharingScopeType;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.jee.model.internal.common.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationFactory {
    protected static boolean isArrayOfObject(Object value) {
        return Object[].class.isInstance(value);
    }

    protected Object getAnnotatedValue(String name, IMemberValuePair[] memberValuePairs) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
        int n = memberValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (name.equals(pair.getMemberName())) {
                return pair.getValue();
            }
            ++n2;
        }
        return null;
    }

    protected boolean containsImport(ICompilationUnit unit, String importt) throws JavaModelException {
        IImportDeclaration[] iImportDeclarationArray = unit.getImports();
        int n = iImportDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration declaration = iImportDeclarationArray[n2];
            if (declaration.getElementName().equals(importt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IType resolveType(IType declaringType, String toResolve) throws JavaModelException {
        if (toResolve == null) {
            return null;
        }
        String[][] fullTypeName = declaringType.resolveType(toResolve);
        if (fullTypeName != null) {
            return declaringType.getJavaProject().findType(fullTypeName[0][0], fullTypeName[0][1]);
        }
        return null;
    }

    protected void processEjbAnnotation(IAnnotation annotation, List<EjbLocalRef> localRefs, IMember member, Collection<IType> dependedTypes) throws JavaModelException {
        int memberType = member.getElementType();
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        IType cfr_ignored_0 = (IType)(member.getElementType() == 7 ? member : member.getDeclaringType());
        String beanInterfaceValue = (String)this.getAnnotatedValue("beanInterface", pairs);
        beanInterfaceValue = this.internalProcessInjection(beanInterfaceValue, member, dependedTypes);
        if (beanInterfaceValue == null) {
            return;
        }
        String refName = (String)this.getAnnotatedValue("name", pairs);
        if (refName == null) {
            refName = this.getMemberQualifiedName(member);
        }
        EjbLocalRef ref = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ref.setEjbRefName(refName);
        localRefs.add(ref);
        ref.setLocal(beanInterfaceValue);
        ref.setLocalHome(beanInterfaceValue);
        ref.setEjbLink((String)this.getAnnotatedValue("beanName", pairs));
        ref.setMappedName((String)this.getAnnotatedValue("mappedName", pairs));
        if (memberType == 9 || memberType == 8) {
            InjectionTarget injectionTarget = JavaeeFactory.eINSTANCE.createInjectionTarget();
            int index = refName.indexOf(47);
            injectionTarget.setInjectionTargetClass(refName.substring(0, index));
            injectionTarget.setInjectionTargetName(refName.substring(index + 1));
            ref.getInjectionTargets().add(injectionTarget);
        }
    }

    protected void processResourceRefAnnotation(IAnnotation annotation, List<ResourceRef> resourceRefs, IMember member, Collection<IType> dependedTypes) throws JavaModelException {
        String value;
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        String specifiedType = (String)this.getAnnotatedValue("type", pairs);
        if ((specifiedType = this.internalProcessInjection(specifiedType, member, dependedTypes)) == null) {
            return;
        }
        String name = (String)this.getAnnotatedValue("name", pairs);
        if (name == null) {
            name = this.getMemberQualifiedName(member);
        }
        ResourceRef ref = JavaeeFactory.eINSTANCE.createResourceRef();
        ref.setResRefName(name);
        ref.setResType(specifiedType);
        ref.setMappedName((String)this.getAnnotatedValue("mappedName", pairs));
        String description = (String)this.getAnnotatedValue("description", pairs);
        if (description != null) {
            Description desc = JavaeeFactory.eINSTANCE.createDescription();
            desc.setValue(description);
            ref.getDescriptions().clear();
            ref.getDescriptions().add(desc);
        }
        if ("AuthenticationType.CONTAINER".equals(value = (String)this.getAnnotatedValue("authenticationType", pairs))) {
            ref.setResAuth(ResAuthType.CONTAINER_LITERAL);
        } else if ("CONTAINER".equals(value) && this.containsImport(member.getCompilationUnit(), "AuthenticationType.CONTAINER")) {
            ref.setResAuth(ResAuthType.CONTAINER_LITERAL);
        }
        Boolean shareable = (Boolean)this.getAnnotatedValue("shareable", pairs);
        if (Boolean.FALSE.equals(shareable)) {
            ref.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
        }
        resourceRefs.add(ref);
    }

    private String internalProcessInjection(String specifiedType, IMember member, Collection<IType> dependedTypes) throws JavaModelException {
        boolean methodOrField = member.getElementType() == 9 || member.getElementType() == 8;
        IType declaringType = (IType)(member.getElementType() == 7 ? member : member.getDeclaringType());
        String memberType = this.getUnresolvedType(member);
        if (this.getClassTypeSignature(memberType) == null && methodOrField) {
            return null;
        }
        if (specifiedType == null && memberType == null) {
            return null;
        }
        IType resolvedType = this.resolveType(declaringType, memberType);
        if (methodOrField && resolvedType != null) {
            if (resolvedType.isInterface()) {
                memberType = resolvedType.getFullyQualifiedName();
            } else {
                return null;
            }
        }
        IType resolvedSpecifiedType = null;
        if (specifiedType == null) {
            specifiedType = memberType;
            resolvedSpecifiedType = resolvedType;
        } else {
            resolvedSpecifiedType = this.resolveType(declaringType, specifiedType);
        }
        if (resolvedSpecifiedType != null) {
            if (resolvedSpecifiedType.isInterface()) {
                specifiedType = resolvedSpecifiedType.getFullyQualifiedName();
                dependedTypes.add(resolvedSpecifiedType);
            } else {
                return null;
            }
        }
        return specifiedType;
    }

    private String getMemberQualifiedName(IMember member) {
        String memberName = member.getElementName();
        int elementType = member.getElementType();
        if (elementType == 9 && memberName.startsWith("set")) {
            char ch = Character.toLowerCase(memberName.charAt(3));
            memberName = String.valueOf(ch) + memberName.substring(4);
        }
        return elementType == 7 ? ((IType)member).getFullyQualifiedName() : String.valueOf(member.getDeclaringType().getFullyQualifiedName()) + "/" + memberName;
    }

    private String getUnresolvedType(IMember member) throws JavaModelException {
        int memberType = member.getElementType();
        member.getDeclaringType();
        String unresolvedTypeName = null;
        if (memberType == 8) {
            unresolvedTypeName = Signature.toString((String)((IField)member).getTypeSignature());
        } else if (memberType == 9) {
            IMethod method = (IMethod)member;
            if (method.getNumberOfParameters() != 1) {
                return null;
            }
            unresolvedTypeName = Signature.toString((String)method.getParameterTypes()[0]);
        } else if (memberType == 7) {
            return null;
        }
        return unresolvedTypeName;
    }

    private String getClassTypeSignature(String toResolve) {
        if (toResolve == null) {
            return null;
        }
        if (Signature.getTypeSignatureKind((String)(toResolve = Signature.createTypeSignature((String)toResolve, (boolean)false))) != 1) {
            return null;
        }
        return toResolve;
    }

    protected void processDeclareRoles(Result result, List<SecurityRoleRef> securityRoleRefs, IAnnotation annotation, IType type) throws JavaModelException {
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        Object values = this.getAnnotatedValue("value", pairs);
        if (!AbstractAnnotationFactory.isArrayOfObject(values)) {
            return;
        }
        Object[] objectArray = (Object[])values;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object roleName = objectArray[n2];
            SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
            role.setRoleName((String)roleName);
            result.getAdditional().add((JavaEEObject)role);
            SecurityRoleRef ref = JavaeeFactory.eINSTANCE.createSecurityRoleRef();
            ref.setRoleName((String)roleName);
            securityRoleRefs.add(ref);
            ++n2;
        }
    }

    protected void processResourcesAnnotation(IAnnotation annotation, List<ResourceRef> resourceRefs, IType type, Collection<IType> dependedTypes) throws JavaModelException {
        Object[] values;
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        if (!AbstractAnnotationFactory.isArrayOfObject(pairs[0].getValue())) {
            return;
        }
        Object[] objectArray = values = (Object[])pairs[0].getValue();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object resourceAnnotation = objectArray[n2];
            this.processResourceRefAnnotation((IAnnotation)resourceAnnotation, resourceRefs, (IMember)type, dependedTypes);
            ++n2;
        }
    }

    protected void processRunAs(IAnnotation annotation, RunAs runAs) throws JavaModelException {
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        if (pairs.length == 1) {
            String value = (String)this.getAnnotatedValue("value", pairs);
            runAs.setRoleName(value);
        }
    }
}

