/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class EditValidateUtil {
    private static final Logger _logger = PDPlugin.getLogger(EditValidateUtil.class);
    private static final boolean ALERT = false;
    private static final boolean REPORT = false;

    public static boolean validPosition(IDOMPosition position) {
        try {
            boolean result = true;
            Assert.isTrue((position != null && position.getContainerNode() != null && position.getOffset() >= 0 ? 1 : 0) != 0);
            Node container = position.getContainerNode();
            result &= EditValidateUtil.validNode(container);
            int offset = position.getOffset();
            if (position.isText()) {
                int length = ((Text)container).getLength();
                Assert.isTrue((offset <= length ? 1 : 0) != 0);
            } else if (position instanceof DOMPosition && offset > 0) {
                Assert.isTrue((container.hasChildNodes() && container.getChildNodes().getLength() >= offset ? 1 : 0) != 0);
            }
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validPosition(DesignPosition position) {
        try {
            boolean result = true;
            Assert.isTrue((position != null && position.getContainerPart() != null && position.getContainerNode() != null && position.getOffset() >= 0 ? 1 : 0) != 0);
            Node container = position.getContainerNode();
            result &= EditValidateUtil.validNode(container);
            int offset = position.getOffset();
            if (EditModelQuery.isText(container)) {
                int length = ((Text)container).getLength();
                Assert.isTrue((offset <= length ? 1 : 0) != 0);
            } else if (position instanceof DesignRefPosition && offset > 0) {
                Assert.isTrue((container.hasChildNodes() && container.getChildNodes().getLength() >= offset ? 1 : 0) != 0);
            }
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validText(Node node) {
        try {
            boolean result = true;
            Assert.isTrue((node.getNodeType() == 3 ? 1 : 0) != 0);
            Assert.isTrue((((Text)node).getData() != null ? 1 : 0) != 0);
            return result &= EditValidateUtil.validNode(node);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validNode(Node node) {
        try {
            Assert.isTrue((boolean)(node instanceof IDOMNode));
            Assert.isTrue((node.getNodeType() == 9 || node.getParentNode() != null ? 1 : 0) != 0);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validRange(DOMRange range) {
        try {
            boolean result = true;
            IDOMPosition start = range.getStartPosition();
            IDOMPosition end = range.getEndPosition();
            result &= EditValidateUtil.validPosition(start);
            return result &= EditValidateUtil.validPosition(end);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validStringIndex(Node text, int index) {
        try {
            Assert.isTrue((index >= 0 && ((Text)text).getLength() >= index ? 1 : 0) != 0);
            return EditValidateUtil.validText(text);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validStringIndexOffset(Node text, int index, int offset) {
        try {
            Assert.isTrue((index >= 0 && index + offset >= 0 && ((Text)text).getLength() >= index + offset && ((Text)text).getLength() >= index ? 1 : 0) != 0);
            return EditValidateUtil.validText(text);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isValidForEditing(IDOMPosition pos, boolean forward) {
        if (pos == null) {
            return false;
        }
        if (pos.isText()) {
            return true;
        }
        Node container = pos.getContainerNode();
        if (EditModelQuery.isChild("head", container, true)) {
            return false;
        }
        Node sibling = EditModelQuery.getInstance().getSibling(pos, forward);
        if (sibling != null) {
            if (EditModelQuery.isText(sibling)) {
                return true;
            }
            Assert.isTrue((sibling.getLocalName() != null ? 1 : 0) != 0);
            if (EditModelQuery.UNREMOVEBLE_TAGS.contains(sibling.getLocalName().toLowerCase())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidForEditing(Node node) {
        return !EditModelQuery.isChild("head", node, true);
    }

    private EditValidateUtil() {
    }
}

