/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.common;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergedModelProvider<T>
implements IModelProvider {
    protected IModelProvider ddProvider;
    protected IModelProvider annotationModelProvider;
    protected boolean isOnceDisposed = false;
    private Collection<IModelProviderListener> listeners;
    protected IProject project;
    private AnnotationModelListener annotationModelListener;
    private XmlModelListener xmlModelListener;
    protected T mergedModel;

    public AbstractMergedModelProvider(IProject project) {
        this.project = project;
    }

    public void addListener(IModelProviderListener listener) {
        this.getListeners().add(listener);
    }

    public Object getModelObject() {
        return this.getMergedModel();
    }

    public void modify(Runnable runnable, IPath modelPath) {
    }

    public void removeListener(IModelProviderListener listener) {
        this.getListeners().remove(listener);
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        if (this.ddProvider == null) {
            this.getModelObject();
        }
        return this.ddProvider.validateEdit(modelPath, context);
    }

    protected abstract void annotationModelChanged(IModelProviderEvent var1);

    protected abstract void xmlModelChanged(IModelProviderEvent var1);

    protected abstract T merge(T var1, T var2);

    protected abstract IModelProvider loadAnnotationModel(T var1) throws CoreException;

    protected abstract IModelProvider loadDeploymentDescriptorModel() throws CoreException;

    protected Collection<IModelProviderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<IModelProviderListener>();
        }
        return this.listeners;
    }

    protected T getMergedModel() {
        try {
            if (this.mergedModel == null) {
                this.mergedModel = this.loadModel();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return this.mergedModel;
    }

    protected T loadModel() throws CoreException {
        if (!this.project.isAccessible()) {
            throw new IllegalStateException("The project <" + this.project + "> is not accessible.");
        }
        this.ddProvider = this.loadDeploymentDescriptorModel();
        if (this.ddProvider == null || this.ddProvider.getModelObject() == null) {
            return null;
        }
        this.annotationModelProvider = this.loadAnnotationModel(this.ddProvider.getModelObject());
        if (this.annotationModelProvider == null || this.annotationModelProvider.getModelObject() == null) {
            return null;
        }
        Object ddModel = this.ddProvider.getModelObject();
        Object annotationModel = this.annotationModelProvider.getModelObject();
        this.enableInternalNotifications();
        this.isOnceDisposed = false;
        return (T)this.merge(ddModel, annotationModel);
    }

    protected void initMergedModelResource(EObject ddModel) {
        Resource resourceDD = ddModel.eResource();
        Resource resourceMM = ((EObject)this.mergedModel).eResource();
        if (resourceDD != null && resourceMM == null) {
            ResourceImpl resRes = new ResourceImpl(resourceDD.getURI());
            resRes.getContents().add((Object)((EObject)this.mergedModel));
        }
    }

    protected final void enableInternalNotifications() {
        this.xmlModelListener = new XmlModelListener();
        this.ddProvider.addListener((IModelProviderListener)this.xmlModelListener);
        this.annotationModelListener = new AnnotationModelListener();
        this.annotationModelProvider.addListener((IModelProviderListener)this.annotationModelListener);
    }

    protected final void disableInternalNotifications() {
        this.ddProvider.removeListener((IModelProviderListener)this.xmlModelListener);
        this.annotationModelProvider.removeListener((IModelProviderListener)this.annotationModelListener);
    }

    protected void notifyListeners(IModelProviderEvent event) {
        event.setModel((IModelProvider)this);
        event.setProject(this.project);
        for (IModelProviderListener listener : this.getListeners()) {
            listener.modelsChanged(event);
        }
    }

    protected boolean shouldDispose(IModelProviderEvent event) {
        return event.getEventCode() == 64;
    }

    public boolean isDisposed() {
        return this.isOnceDisposed || this.ddProvider == null && this.annotationModelProvider == null;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.disableInternalNotifications();
        this.ddProvider = null;
        this.annotationModelProvider = null;
        this.mergedModel = null;
        this.isOnceDisposed = true;
    }

    private class AnnotationModelListener
    implements IModelProviderListener {
        private AnnotationModelListener() {
        }

        public void modelsChanged(IModelProviderEvent event) {
            AbstractMergedModelProvider.this.annotationModelChanged(event);
        }
    }

    private class XmlModelListener
    implements IModelProviderListener {
        private XmlModelListener() {
        }

        public void modelsChanged(IModelProviderEvent event) {
            AbstractMergedModelProvider.this.xmlModelChanged(event);
        }
    }
}

