/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpathdep;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyValidator;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ClasspathDependencyUtil
implements IClasspathDependencyConstants {
    public static Map getRawComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject, IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
    }

    public static Map getRawComponentClasspathDependencies(IJavaProject javaProject, IClasspathDependencyConstants.DependencyAttributeType attributeType) throws CoreException {
        if (javaProject == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<IClasspathEntry, IClasspathAttribute> referencedRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, attributeType);
            if (attrib != null) {
                referencedRawEntries.put(entry, attrib);
            }
            ++i;
        }
        return referencedRawEntries;
    }

    public static List getPotentialComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        ArrayList<IClasspathEntry> potentialRawEntries = new ArrayList<IClasspathEntry>();
        if (javaProject == null || !javaProject.getProject().isAccessible()) {
            return Collections.EMPTY_LIST;
        }
        IProject project = javaProject.getProject();
        ClasspathDependencyValidator.ClasspathDependencyValidatorData data = new ClasspathDependencyValidator.ClasspathDependencyValidatorData(project);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry);
            if (attrib == null) {
                IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, null, true, project, data);
                boolean error = false;
                int j = 0;
                while (j < msgs.length) {
                    if (msgs[j].getSeverity() == 1) {
                        error = true;
                        break;
                    }
                    ++j;
                }
                if (!error) {
                    potentialRawEntries.add(entry);
                }
            }
            ++i;
        }
        return potentialRawEntries;
    }

    private static boolean isValid(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project, ClasspathDependencyValidator.ClasspathDependencyValidatorData data) {
        IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, project, data);
        boolean valid = true;
        int j = 0;
        while (j < msgs.length) {
            if (msgs[j].getSeverity() == 1) {
                valid = false;
                break;
            }
            ++j;
        }
        return valid;
    }

    public static Map getComponentClasspathDependencies(IJavaProject javaProject, boolean isWebApp) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(javaProject, isWebApp, true);
    }

    public static Map getComponentClasspathDependencies(IJavaProject javaProject, boolean isWebApp, boolean onlyValid) throws CoreException {
        ClasspathDependencyValidator.ClasspathDependencyValidatorData data = new ClasspathDependencyValidator.ClasspathDependencyValidatorData(javaProject.getProject());
        Map referencedRawEntries = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject);
        HashMap<IClasspathEntry, IClasspathAttribute> validRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        for (IClasspathEntry entry : referencedRawEntries.keySet()) {
            IClasspathAttribute attrib;
            if (!ClasspathDependencyUtil.isValid(entry, attrib = (IClasspathAttribute)referencedRawEntries.get(entry), isWebApp, javaProject.getProject(), data)) continue;
            validRawEntries.put(entry, attrib);
        }
        if (validRawEntries.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        HashMap<IPath, IClasspathEntry> pathToResolvedEntry = new HashMap<IPath, IClasspathEntry>();
        int j = 0;
        while (j < entries.length) {
            pathToResolvedEntry.put(entries[j].getPath(), entries[j]);
            ++j;
        }
        LinkedHashMap<IClasspathEntry, IClasspathAttribute> referencedEntries = new LinkedHashMap<IClasspathEntry, IClasspathAttribute>();
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int j2 = 0;
        while (j2 < roots.length) {
            IPath pkgFragPath;
            IClasspathEntry resolvedEntry;
            IClasspathAttribute resolvedAttrib;
            IPackageFragmentRoot root = roots[j2];
            IClasspathEntry rawEntry = root.getRawClasspathEntry();
            IClasspathAttribute attrib = (IClasspathAttribute)validRawEntries.get(rawEntry);
            if (!(attrib == null || (resolvedAttrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(resolvedEntry = (IClasspathEntry)pathToResolvedEntry.get(pkgFragPath = root.getPath()))) != null && !resolvedAttrib.getName().equals("org.eclipse.jst.component.dependency") || onlyValid && !ClasspathDependencyUtil.isValid(resolvedEntry, resolvedAttrib != null ? resolvedAttrib : attrib, isWebApp, javaProject.getProject(), data))) {
                if (resolvedAttrib != null) {
                    attrib = resolvedAttrib;
                }
                referencedEntries.put(resolvedEntry, attrib);
            }
            ++j2;
        }
        return referencedEntries;
    }

    public static IPath getEntryLocation(IClasspathEntry entry) {
        IPath entryPath;
        if (entry == null) {
            return null;
        }
        IPath entryLocation = entryPath = entry.getPath();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            entryLocation = resource.getLocation();
        }
        return entryLocation;
    }

    public static IResource getEntryResource(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath entryPath = entry.getPath();
        return ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
    }

    public static IProject isClasspathProjectReference(IVirtualReference ref) {
        VirtualArchiveComponent comp;
        if (ref == null) {
            return null;
        }
        if (ref.getReferencedComponent() instanceof VirtualArchiveComponent && (comp = (VirtualArchiveComponent)ref.getReferencedComponent()).getArchiveType().equals("cpe") && comp.getUnderlyingDiskFile() == null) {
            return comp.getProject();
        }
        return null;
    }

    public static boolean isClassFolderEntry(IClasspathEntry entry) {
        IPath entryPath;
        if (entry == null || entry.getEntryKind() != 1) {
            return false;
        }
        IPath entryLocation = entryPath = entry.getPath();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            entryLocation = resource.getLocation();
        }
        boolean isFile = true;
        if (entryLocation.toFile().isDirectory()) {
            isFile = false;
        }
        return !isFile;
    }

    public static IPath getClasspathVirtualReferenceLocation(IVirtualReference ref) {
        VirtualArchiveComponent comp;
        if (ref == null) {
            return null;
        }
        if (ref.getReferencedComponent() instanceof VirtualArchiveComponent && (comp = (VirtualArchiveComponent)ref.getReferencedComponent()).getArchiveType().equals("cpe")) {
            File cpEntryFile = comp.getUnderlyingDiskFile();
            IPath cpEntryPath = null;
            if (cpEntryFile != null && cpEntryFile.exists()) {
                cpEntryPath = new Path(cpEntryFile.getAbsolutePath());
            } else {
                IFile iFile = comp.getUnderlyingWorkbenchFile();
                if (iFile != null) {
                    cpEntryPath = iFile.getLocation();
                } else {
                    IContainer container = ClasspathDependencyUtil.getClassFolder((IVirtualComponent)comp);
                    if (container != null) {
                        return container.getLocation();
                    }
                }
            }
            return cpEntryPath;
        }
        return null;
    }

    public static IPath getRuntimePath(IClasspathAttribute attrib, boolean isWebApp, boolean isClassFolder) {
        if (attrib != null && !attrib.getName().equals("org.eclipse.jst.component.dependency")) {
            return null;
        }
        if (attrib == null || attrib.getValue() == null || attrib.getValue().length() == 0) {
            return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, isClassFolder);
        }
        return new Path(attrib.getValue());
    }

    public static boolean isClassFolderReference(IVirtualReference ref) {
        ref.getRuntimePath();
        IVirtualComponent comp = ref.getReferencedComponent();
        if (comp instanceof ClasspathDependencyVirtualComponent) {
            ClasspathDependencyVirtualComponent cpComp = (ClasspathDependencyVirtualComponent)comp;
            return cpComp.isClassFolder();
        }
        return false;
    }

    public static IContainer getClassFolder(IVirtualComponent comp) {
        if (comp instanceof ClasspathDependencyVirtualComponent) {
            ClasspathDependencyVirtualComponent cpComp = (ClasspathDependencyVirtualComponent)comp;
            return cpComp.getClassFolder();
        }
        return null;
    }

    public static IPath getDefaultRuntimePath(boolean isWebApp) {
        return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, false);
    }

    public static IPath getDefaultRuntimePath(boolean isWebApp, boolean isClassFolder) {
        if (isWebApp) {
            return isClassFolder ? WEB_INF_CLASSES_PATH : WEB_INF_LIB_PATH;
        }
        return isClassFolder ? RUNTIME_MAPPING_INTO_COMPONENT_PATH : RUNTIME_MAPPING_INTO_CONTAINER_PATH;
    }

    public static String getArchiveName(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        boolean isClassFolder = ClasspathDependencyUtil.isClassFolderEntry(entry);
        if (isClassFolder) {
            IResource resource = ClasspathDependencyUtil.getEntryResource(entry);
            if (resource == null) {
                return ClasspathDependencyUtil.getEntryLocation(entry).lastSegment();
            }
            return resource.getFullPath().toString();
        }
        IPath entryLocation = ClasspathDependencyUtil.getEntryLocation(entry);
        return entryLocation.lastSegment();
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry) {
        return ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY);
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry, IClasspathDependencyConstants.DependencyAttributeType attributeType) {
        if (entry == null) {
            return null;
        }
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            IClasspathAttribute attribute = attributes[i];
            String name = attribute.getName();
            if (name.equals("org.eclipse.jst.component.dependency") ? attributeType == IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY || attributeType == IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY : name.equals("org.eclipse.jst.component.nondependency") && (attributeType == IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY || attributeType == IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_NONDEPENDENCY)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public static boolean isClasspathComponentDependency(IVirtualComponent component) {
        if (component == null) {
            return false;
        }
        if (component instanceof VirtualArchiveComponent) {
            VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)component;
            return archiveComp.getArchiveType().equals("cpe");
        }
        return false;
    }

    public static String getClasspathComponentDependencyDisplayString(IVirtualComponent component) {
        URI archiveURI = URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)component));
        return archiveURI.lastSegment();
    }
}

