/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator<E>
implements Iterator<E> {
    private final Collection<Iterator<? extends E>> iterators;
    private final Midwife<E> midwife;
    private Iterator<? extends E> currentIterator;

    public TreeIterator(Iterator<? extends E> roots) {
        this(roots, Midwife.Disabled.instance());
    }

    public TreeIterator(E root) {
        this(root, Midwife.Disabled.instance());
    }

    public TreeIterator(E root, Midwife<E> midwife) {
        this(new SingleElementIterator<E>(root), midwife);
    }

    public TreeIterator(Iterator<? extends E> roots, Midwife<E> midwife) {
        this.currentIterator = roots;
        this.iterators = new LinkedList<Iterator<? extends E>>();
        this.midwife = midwife;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.currentIterator.hasNext()) {
            return this.nextInternal();
        }
        Iterator<Iterator<E>> stream = this.iterators.iterator();
        while (stream.hasNext()) {
            this.currentIterator = stream.next();
            if (this.currentIterator.hasNext()) break;
            stream.remove();
        }
        return this.nextInternal();
    }

    private E nextInternal() {
        E next = this.currentIterator.next();
        this.iterators.add(this.children(next));
        return next;
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    protected Iterator<? extends E> children(E next) {
        return this.midwife.children(next);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.currentIterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Midwife<T> {
        public Iterator<? extends T> children(T var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Disabled<S>
        implements Midwife<S> {
            public static final Midwife INSTANCE = new Disabled();

            public static <R> Midwife<R> instance() {
                return INSTANCE;
            }

            private Disabled() {
            }

            @Override
            public Iterator<S> children(S next) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "TreeIterator.Midwife.Disabled";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Null<S>
        implements Midwife<S> {
            public static final Midwife INSTANCE = new Null();

            public static <R> Midwife<R> instance() {
                return INSTANCE;
            }

            private Null() {
            }

            @Override
            public Iterator<S> children(S next) {
                return EmptyIterator.instance();
            }

            public String toString() {
                return "TreeIterator.Midwife.Null";
            }
        }
    }
}

