/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValPrefManagerProject {
    private IProject _project;
    private static List<IValChangedListener> _listeners = new LinkedList<IValChangedListener>();
    private List<Validator> _validators;

    public ValPrefManagerProject(IProject project) {
        assert (project != null);
        this._project = project;
    }

    public static void addListener(IValChangedListener listener) {
        if (_listeners.contains(listener)) {
            return;
        }
        _listeners.add(listener);
    }

    public static void removeListener(IValChangedListener listener) {
        _listeners.remove(listener);
    }

    private static void updateListeners(IProject project) {
        for (IValChangedListener cl : _listeners) {
            cl.validatorsForProjectChanged(project, true);
        }
    }

    public boolean hasProjectSpecificSettings() {
        IEclipsePreferences pref = this.getPreferences();
        if (pref == null) {
            return false;
        }
        int version = pref.getInt("vf.version", 0);
        return version != 0;
    }

    public List<Validator> getValidators(Map<String, Validator> baseValidators) throws BackingStoreException {
        List<Validator> vals = this._validators;
        if (vals == null) {
            this._validators = vals = this.loadValidators(baseValidators);
        }
        return vals;
    }

    private List<Validator> loadValidators(Map<String, Validator> baseValidators) throws BackingStoreException {
        LinkedList<Validator> list = new LinkedList<Validator>();
        IEclipsePreferences pref = this.getPreferences();
        if (pref.nodeExists("vals")) {
            Preferences vals = pref.node("vals");
            String[] stringArray = vals.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Validator base = baseValidators.get(id);
                Validator v = ValPrefManagerGlobal.loadValidator(id, vals, base);
                if (v != null) {
                    Validator.V2 v2 = v.asV2Validator();
                    if (v2 != null) {
                        v2.setLevel(Validator.Level.Project);
                    }
                    list.add(v);
                }
                ++n2;
            }
        }
        return list;
    }

    public boolean loadProjectPreferencesShallow(ProjectPreferences pp) {
        IEclipsePreferences pref = this.getPreferences();
        if (pref == null) {
            return false;
        }
        int version = pref.getInt("vf.version", 0);
        if (version == 0) {
            return false;
        }
        if (version != 3) {
            ValPrefManagerGlobal.migrate(version, pref);
        }
        pp.setOverride(pref.getBoolean("override", false));
        pp.setSuspend(pref.getBoolean("suspend", false));
        return true;
    }

    public boolean loadProjectPreferences(ProjectPreferences pp, Map<String, Validator> baseValidators) throws BackingStoreException {
        if (!this.loadProjectPreferencesShallow(pp)) {
            return false;
        }
        IEclipsePreferences pref = this.getPreferences();
        if (!pref.nodeExists("vals")) {
            return true;
        }
        Preferences vp = pref.node("vals");
        LinkedList<Validator> list = new LinkedList<Validator>();
        String[] stringArray = vp.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Validator base = baseValidators.get(id);
            Validator v = ValPrefManagerGlobal.loadValidator(id, vp, base);
            if (v != null) {
                Validator.V2 v2 = v.asV2Validator();
                if (v2 != null) {
                    v2.setLevel(Validator.Level.Project);
                }
                list.add(v);
            }
            ++n2;
        }
        Validator[] vals = new Validator[list.size()];
        list.toArray(vals);
        pp.setValidators(vals);
        return true;
    }

    private IEclipsePreferences getPreferences() {
        ProjectScope projectContext = new ProjectScope(this._project);
        IEclipsePreferences pref = projectContext.getNode("org.eclipse.wst.validation");
        return pref;
    }

    public void savePreferences(ProjectPreferences projectPreferences, Validator[] validators) {
        IEclipsePreferences pref = this.getPreferences();
        pref.putBoolean("suspend", projectPreferences.getSuspend());
        pref.putBoolean("override", projectPreferences.getOverride());
        pref.putInt("vf.version", 3);
        Preferences vals = pref.node("vals");
        try {
            Validator[] workspaceVals = ValManager.getDefault().getValidators();
            HashMap<String, Validator> base = new HashMap<String, Validator>(workspaceVals.length);
            Validator[] validatorArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            pref.flush();
            ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(projectPreferences.getProject());
            pc.setEnabledBuildValidators(this.getEnabledBuildValidators(validators));
            pc.setEnabledManualValidators(this.getEnabledManualValidators(validators));
            pc.passivate();
            pc.store();
            ValPrefManagerProject.updateListeners(this._project);
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private Set<ValidatorMetaData> getEnabledBuildValidators(Validator[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator.V1 v1;
            Validator v = validatorArray[n2];
            if (v.isBuildValidation() && (v1 = v.asV1Validator()) != null) {
                set.add(v1.getVmd());
            }
            ++n2;
        }
        return set;
    }

    private Set<ValidatorMetaData> getEnabledManualValidators(Validator[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator.V1 v1;
            Validator v = validatorArray[n2];
            if (v.isManualValidation() && (v1 = v.asV1Validator()) != null) {
                set.add(v1.getVmd());
            }
            ++n2;
        }
        return set;
    }

    public void loadMessages(Validator validator, Map<String, MessageSeveritySetting> settings) {
        try {
            ValPrefManagerGlobal.loadMessageSettings(validator, settings, (Preferences)this.getPreferences());
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }
}

