/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class FacetContainerUtils {
    public static IPath getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public static IProject getProjectName(String project) {
        String projectString = FacetContainerUtils.replaceEscapecharactors(project.toString());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(FacetContainerUtils.getProjectNameFromFramewokNameString(projectString));
    }

    public static IPath getProjectRoot(String project) {
        String projectString = FacetContainerUtils.replaceEscapecharactors(project.toString());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(FacetContainerUtils.getProjectNameFromFramewokNameString(projectString)).getLocation();
    }

    public static String pathToWebProjectContainer(String project) {
        IPath projectRoot = FacetContainerUtils.getProjectRoot(project);
        IPath currentDynamicWebProjectDir = J2EEUtils.getWebContentPath((IProject)FacetContainerUtils.getProjectName(project));
        IPath currentDynamicWebProjectDirWithoutProjectRoot = J2EEUtils.getWebContentPath((IProject)FacetContainerUtils.getProjectName(project)).removeFirstSegments(1).makeAbsolute();
        if (projectRoot.toOSString().contains(FacetContainerUtils.getWorkspace().toOSString())) {
            return FacetContainerUtils.getWorkspace().append(currentDynamicWebProjectDir).toOSString();
        }
        return projectRoot.append(currentDynamicWebProjectDirWithoutProjectRoot).toOSString();
    }

    public static String pathToWebProjectContainerWEBINF(String project) {
        IPath projectRoot = FacetContainerUtils.getProjectRoot(project);
        IPath webContainerWEBINFDir = J2EEUtils.getWebInfPath((IProject)FacetContainerUtils.getProjectName(project));
        IPath webContainerWEBINFDirWithoutProjectRoot = J2EEUtils.getWebInfPath((IProject)FacetContainerUtils.getProjectName(project)).removeFirstSegments(1).makeAbsolute();
        if (projectRoot.toOSString().contains(FacetContainerUtils.getWorkspace().toOSString())) {
            return FacetContainerUtils.getWorkspace().append(webContainerWEBINFDir).toOSString();
        }
        return projectRoot.append(webContainerWEBINFDirWithoutProjectRoot).toOSString();
    }

    public static String pathToWebProjectContainerMETAINF(String project) {
        String containerDirectory = FacetContainerUtils.pathToWebProjectContainer(project);
        String webContainerMETAINF = "META-INF";
        String webContainerMETAINFString = Axis2CoreUtils.addAnotherNodeToPath(containerDirectory, webContainerMETAINF);
        return webContainerMETAINFString;
    }

    public static String pathToWebProjectContainerAxis2Web(String project) {
        String containerDirectory = FacetContainerUtils.pathToWebProjectContainer(project);
        String webContainerAxis2Web = "axis2-web";
        String webContainerAxis2WebString = Axis2CoreUtils.addAnotherNodeToPath(containerDirectory, webContainerAxis2Web);
        return webContainerAxis2WebString;
    }

    public static String pathToWebProjectContainerLib(String project) {
        String webContainerWEBINFString = FacetContainerUtils.pathToWebProjectContainerWEBINF(project);
        return Axis2CoreUtils.addAnotherNodeToPath(webContainerWEBINFString, "lib");
    }

    public static String pathToWebProjectContainerWebXML(String project) {
        String webContainerWEBINFString = FacetContainerUtils.pathToWebProjectContainerWEBINF(project);
        return Axis2CoreUtils.addAnotherNodeToPath(webContainerWEBINFString, "web.xml");
    }

    private static String replaceEscapecharactors(String vulnarableString) {
        if (vulnarableString.indexOf("/") != -1) {
            vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
        }
        return vulnarableString;
    }

    private static String getProjectNameFromFramewokNameString(String frameworkProjectString) {
        if (frameworkProjectString.indexOf(FacetContainerUtils.getSplitCharactor()) == -1) {
            return frameworkProjectString;
        }
        return frameworkProjectString.split(FacetContainerUtils.getSplitCharactors())[1];
    }

    private static String getSplitCharactor() {
        if (File.separatorChar == '\\') {
            return "\\";
        }
        return File.separator;
    }

    public static String pathToAxis2CoreFacetTempDirectory(String project) {
        String pluginAxis2CoreTempDir = WebServiceAxis2CorePlugin.getInstance().getStateLocation().toOSString();
        String projectString = FacetContainerUtils.replaceEscapecharactors(project);
        return FileUtils.addAnotherNodeToPath(pluginAxis2CoreTempDir, projectString);
    }

    private static String getSplitCharactors() {
        if (File.separatorChar == '\\') {
            return "\\" + File.separator;
        }
        return File.separator;
    }

    public static String getDeployedWSDLURL(IProject serverProject, String ServerFactoryId, String ServerInstanceId, String serviceName) {
        String deployedWSDLURLpath = null;
        IServer server = null;
        if (ServerInstanceId != null) {
            server = ServerCore.findServer((String)ServerInstanceId);
        }
        if ((deployedWSDLURLpath = ServerUtils.getEncodedWebComponentURL((IProject)serverProject, (String)ServerFactoryId, (IServer)server)) == null) {
            deployedWSDLURLpath = "http://localhost:8080";
        }
        String[] deployedWSDLURLParts = new String[]{"services", serviceName};
        return String.valueOf(FileUtils.addNodesToURL(deployedWSDLURLpath, deployedWSDLURLParts)) + "?wsdl";
    }
}

