/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.util.ModelUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentGeneralSection
extends AbstractFacesConfigSection {
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private StringDialogField componentTypeField;
    private ClassButtonDialogField componentClassField;
    private ComponentGeneralAdapter componentGeneralAdapter;

    public ComponentGeneralSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.ComponentGeneralSection_Name);
        this.getSection().setDescription(EditorMessages.ComponentGeneralSection_Description);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        GridData td = new GridData(768);
        container.setLayoutData((Object)td);
        toolkit.paintBordersFor(container);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(EditorMessages.ComponentGeneralSection_Label_DisplayName);
        this.displayNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDisplayNameValue = ((StringDialogField)field).getText().trim();
                Command cmd = null;
                ComponentType component = (ComponentType)ComponentGeneralSection.this.getInput();
                EditingDomain editingDomain = ComponentGeneralSection.this.getEditingDomain();
                if (component.getDisplayName().size() > 0) {
                    DisplayNameType displayName = (DisplayNameType)component.getDisplayName().get(0);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)displayName, (Object)FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent(), (Object)newDisplayNameValue);
                } else {
                    DisplayNameType displayNameType = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                    displayNameType.setTextContent(newDisplayNameValue);
                    displayNameType.eAdapters().add((Object)ComponentGeneralSection.this.getComponentGeneralAdapter());
                    cmd = AddCommand.create((EditingDomain)editingDomain, (Object)component, (Object)FacesConfigPackage.eINSTANCE.getComponentType_DisplayName(), (Object)displayNameType);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                }
            }
        });
        this.descriptionField = new StringDialogField(2);
        this.descriptionField.setLabelText(EditorMessages.ComponentGeneralSection_Label_Description);
        this.descriptionField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDescriptionValue = ((StringDialogField)field).getText().trim();
                newDescriptionValue = ModelUtil.escapeEntities(newDescriptionValue);
                Command cmd = null;
                ComponentType component = (ComponentType)ComponentGeneralSection.this.getInput();
                EditingDomain editingDomain = ComponentGeneralSection.this.getEditingDomain();
                if (component.getDescription().size() > 0) {
                    DescriptionType description = (DescriptionType)component.getDescription().get(0);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)description, (Object)FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent(), (Object)newDescriptionValue);
                } else {
                    DescriptionType description = FacesConfigFactory.eINSTANCE.createDescriptionType();
                    description.setTextContent(newDescriptionValue);
                    description.eAdapters().add((Object)ComponentGeneralSection.this.getComponentGeneralAdapter());
                    cmd = AddCommand.create((EditingDomain)editingDomain, (Object)component, (Object)FacesConfigPackage.eINSTANCE.getComponentType_Description(), (Object)description);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                }
            }
        });
        this.componentTypeField = new StringDialogField();
        this.componentTypeField.setLabelText(EditorMessages.ComponentGeneralSection_Label_ComponentType);
        this.componentTypeField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.componentTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command command;
                ComponentTypeType componentType = FacesConfigFactory.eINSTANCE.createComponentTypeType();
                componentType.setTextContent(((StringDialogField)field).getText());
                EditingDomain editingDomain = ComponentGeneralSection.this.getEditingDomain();
                if (editingDomain != null && (command = SetCommand.create((EditingDomain)editingDomain, (Object)ComponentGeneralSection.this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getComponentType_ComponentType(), (Object)componentType)).canExecute()) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.componentClassField = new ClassButtonDialogField(null);
        this.componentClassField.setLabelText(EditorMessages.ComponentGeneralSection_Label_ComponentClass);
        this.componentClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.componentClassField.getTextControl(toolkit, container));
        this.componentClassField.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        this.componentClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command command;
                ComponentClassType componentClass = FacesConfigFactory.eINSTANCE.createComponentClassType();
                componentClass.setTextContent(((StringDialogField)field).getText());
                EditingDomain editingDomain = ComponentGeneralSection.this.getEditingDomain();
                if (editingDomain != null && (command = SetCommand.create((EditingDomain)editingDomain, (Object)ComponentGeneralSection.this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getComponentType_ComponentClass(), (Object)componentClass)).canExecute()) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.componentClassField.setSuperClassName("javax.faces.component.UIComponent");
    }

    public void refreshAll() {
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        Object input = this.getInput();
        if (input instanceof ComponentType) {
            ComponentType component = (ComponentType)input;
            this.refreshControls(component);
        }
    }

    private void refreshControls(ComponentType component) {
        if (component.getDisplayName().size() > 0) {
            DisplayNameType displayName = (DisplayNameType)component.getDisplayName().get(0);
            this.displayNameField.setTextWithoutUpdate(displayName.getTextContent());
        } else {
            this.displayNameField.setTextWithoutUpdate("");
        }
        if (component.getDescription().size() > 0) {
            DescriptionType description = (DescriptionType)component.getDescription().get(0);
            String descriptionString = description.getTextContent();
            descriptionString = ModelUtil.unEscapeEntities(descriptionString);
            this.descriptionField.setTextWithoutUpdate(descriptionString);
        } else {
            this.descriptionField.setTextWithoutUpdate("");
        }
        if (component.getComponentType() != null) {
            this.componentTypeField.setTextWithoutUpdate(component.getComponentType().getTextContent());
        } else {
            this.componentTypeField.setTextWithoutUpdate("");
        }
        if (component.getComponentClass() != null) {
            this.componentClassField.setTextWithoutUpdate(component.getComponentClass().getTextContent());
        } else {
            this.componentClassField.setTextWithoutUpdate("");
        }
    }

    protected void addAdaptersOntoInput(Object newInput) {
        DescriptionType description;
        DisplayNameType displayName;
        ComponentType component = (ComponentType)newInput;
        if (EcoreUtil.getExistingAdapter((Notifier)component, ComponentGeneralSection.class) == null) {
            component.eAdapters().add((Object)this.getComponentGeneralAdapter());
        }
        if (component.getDisplayName().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(displayName = (DisplayNameType)component.getDisplayName().get(0)), ComponentGeneralSection.class) == null) {
            displayName.eAdapters().add((Object)this.getComponentGeneralAdapter());
        }
        if (component.getDescription().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(description = (DescriptionType)component.getDescription().get(0)), ComponentGeneralSection.class) == null) {
            description.eAdapters().add((Object)this.getComponentGeneralAdapter());
        }
    }

    protected void removeAdaptersFromInput(Object oldInput) {
        DescriptionType description;
        DisplayNameType displayName;
        ComponentType component = (ComponentType)oldInput;
        if (EcoreUtil.getExistingAdapter((Notifier)component, ComponentGeneralSection.class) != null) {
            component.eAdapters().remove((Object)this.getComponentGeneralAdapter());
        }
        if (component.getDisplayName().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(displayName = (DisplayNameType)component.getDisplayName().get(0)), ComponentGeneralSection.class) != null) {
            displayName.eAdapters().remove((Object)this.getComponentGeneralAdapter());
        }
        if (component.getDescription().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(description = (DescriptionType)component.getDescription().get(0)), ComponentGeneralSection.class) != null) {
            description.eAdapters().remove((Object)this.getComponentGeneralAdapter());
        }
    }

    private Adapter getComponentGeneralAdapter() {
        if (this.componentGeneralAdapter == null) {
            this.componentGeneralAdapter = new ComponentGeneralAdapter();
        }
        return this.componentGeneralAdapter;
    }

    class ComponentGeneralAdapter
    extends AdapterImpl {
        ComponentGeneralAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == ComponentGeneralSection.class;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 3 || msg.getEventType() == 4 || msg.getEventType() == 1) {
                if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getComponentType_ComponentClass() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getComponentType_ComponentType() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getComponentType_DisplayName() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getComponentType_Description()) {
                    if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                        ComponentGeneralSection.this.refresh();
                    } else {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ComponentGeneralSection.this.refresh();
                            }
                        });
                    }
                } else if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent()) {
                    if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                        ComponentGeneralSection.this.refresh();
                    } else {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ComponentGeneralSection.this.refresh();
                            }
                        });
                    }
                }
            }
        }
    }
}

