/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IEqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class EqualExpression
extends BinaryExpression
implements IEqualExpression {
    public EqualExpression(Expression left, Expression right, int operator) {
        super(left, right, operator);
    }

    private void checkNullComparison(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo initsWhenTrue, FlowInfo initsWhenFalse) {
        LocalVariableBinding local = this.left.localVariableBinding();
        if (local != null && (local.type.tagBits & 2L) == 0L) {
            this.checkVariableComparison(scope, flowContext, flowInfo, initsWhenTrue, initsWhenFalse, local, this.right.nullStatus(flowInfo), this.left);
        }
        if ((local = this.right.localVariableBinding()) != null && (local.type.tagBits & 2L) == 0L) {
            this.checkVariableComparison(scope, flowContext, flowInfo, initsWhenTrue, initsWhenFalse, local, this.left.nullStatus(flowInfo), this.right);
        }
    }

    private void checkVariableComparison(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo initsWhenTrue, FlowInfo initsWhenFalse, LocalVariableBinding local, int nullStatus, Expression reference) {
        switch (nullStatus) {
            case 1: {
                if ((this.bits & 0xFC0) >> 6 == 18) {
                    flowContext.recordUsingNullReference(scope, local, reference, 256, flowInfo);
                    initsWhenTrue.markAsComparedEqualToNull(local);
                    initsWhenFalse.markAsComparedEqualToNonNull(local);
                    break;
                }
                flowContext.recordUsingNullReference(scope, local, reference, 512, flowInfo);
                initsWhenTrue.markAsComparedEqualToNonNull(local);
                initsWhenFalse.markAsComparedEqualToNull(local);
                break;
            }
            case -1: {
                if ((this.bits & 0xFC0) >> 6 == 18) {
                    flowContext.recordUsingNullReference(scope, local, reference, 513, flowInfo);
                    initsWhenTrue.markAsComparedEqualToNonNull(local);
                    break;
                }
                flowContext.recordUsingNullReference(scope, local, reference, 257, flowInfo);
            }
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo result = (this.bits & 0xFC0) >> 6 == 18 ? (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 5 ? (this.left.constant.booleanValue() ? this.right.analyseCode(currentScope, flowContext, flowInfo) : this.right.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition()) : (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 5 ? (this.right.constant.booleanValue() ? this.left.analyseCode(currentScope, flowContext, flowInfo) : this.left.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition()) : this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits())) : (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 5 ? (!this.left.constant.booleanValue() ? this.right.analyseCode(currentScope, flowContext, flowInfo) : this.right.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition()) : (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 5 ? (!this.right.constant.booleanValue() ? this.left.analyseCode(currentScope, flowContext, flowInfo) : this.left.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition()) : this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits()));
        if (result instanceof UnconditionalFlowInfo && (result.tagBits & 1) == 0) {
            result = FlowInfo.conditional(result.copy(), result.copy());
        }
        this.checkNullComparison(currentScope, flowContext, result, result.initsWhenTrue(), result.initsWhenFalse());
        return result;
    }

    public final void computeConstant(TypeBinding leftType, TypeBinding rightType) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperationEQUAL_EQUAL(this.left.constant, leftType.id, this.right.constant, rightType.id);
            if ((this.bits & 0xFC0) >> 6 == 29) {
                this.constant = BooleanConstant.fromValue(!this.constant.booleanValue());
            }
        } else {
            this.constant = Constant.NotAConstant;
        }
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        boolean leftIsCast = this.left instanceof CastExpression;
        if (leftIsCast) {
            this.left.bits |= 0x20;
        }
        TypeBinding originalLeftType = this.left.resolveType(scope);
        boolean rightIsCast = this.right instanceof CastExpression;
        if (rightIsCast) {
            this.right.bits |= 0x20;
        }
        TypeBinding originalRightType = this.right.resolveType(scope);
        if (originalLeftType == null || originalRightType == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        boolean use15specifics = scope.compilerOptions().sourceLevel >= 0x310000L;
        TypeBinding leftType = originalLeftType;
        TypeBinding rightType = originalRightType;
        if (use15specifics) {
            if (leftType != TypeBinding.NULL && leftType.isBaseType()) {
                if (!rightType.isBaseType()) {
                    rightType = scope.environment().computeBoxingType(rightType);
                }
            } else if (rightType != TypeBinding.NULL && rightType.isBaseType()) {
                leftType = scope.environment().computeBoxingType(leftType);
            }
        }
        if (leftType.isAnyType() || rightType.isAnyType()) {
            return TypeBinding.BOOLEAN;
        }
        if (leftType.isBasicType() && rightType.isBasicType()) {
            int leftTypeID = leftType.id;
            int rightTypeID = rightType.id;
            int operatorSignature = OperatorSignatures[18][(leftTypeID << 4) + rightTypeID];
            this.left.computeConversion(scope, TypeBinding.wellKnownType(scope, operatorSignature >>> 16 & 0xF), originalLeftType);
            this.right.computeConversion(scope, TypeBinding.wellKnownType(scope, operatorSignature >>> 8 & 0xF), originalRightType);
            this.bits |= operatorSignature & 0xF;
            if ((operatorSignature & 0xF) == 0) {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
            if (leftIsCast || rightIsCast) {
                CastExpression.checkNeedForArgumentCasts(scope, 18, operatorSignature, this.left, leftType.id, leftIsCast, this.right, rightType.id, rightIsCast);
            }
            this.computeConstant(leftType, rightType);
            this.resolvedType = TypeBinding.BOOLEAN;
            return this.resolvedType;
        }
        if (!(leftType.isBaseType() && leftType != TypeBinding.NULL || rightType.isBaseType() && rightType != TypeBinding.NULL || !this.checkCastTypesCompatibility(scope, leftType, rightType, null) && !this.checkCastTypesCompatibility(scope, rightType, leftType, null))) {
            boolean unnecessaryRightCast;
            if (rightType.id == 11 && leftType.id == 11) {
                this.computeConstant(leftType, rightType);
            } else {
                this.constant = Constant.NotAConstant;
            }
            ReferenceBinding objectType = scope.getJavaLangObject();
            this.left.computeConversion(scope, objectType, leftType);
            this.right.computeConversion(scope, objectType, rightType);
            boolean unnecessaryLeftCast = (this.left.bits & 0x4000) != 0;
            boolean bl = unnecessaryRightCast = (this.right.bits & 0x4000) != 0;
            if (unnecessaryLeftCast || unnecessaryRightCast) {
                TypeBinding alternateRightType;
                TypeBinding alternateLeftType = unnecessaryLeftCast ? ((CastExpression)this.left).expression.resolvedType : leftType;
                TypeBinding typeBinding = alternateRightType = unnecessaryRightCast ? ((CastExpression)this.right).expression.resolvedType : rightType;
                if (this.checkCastTypesCompatibility(scope, alternateLeftType, alternateRightType, null) || this.checkCastTypesCompatibility(scope, alternateRightType, alternateLeftType, null)) {
                    if (unnecessaryLeftCast) {
                        scope.problemReporter().unnecessaryCast((CastExpression)this.left);
                    }
                    if (unnecessaryRightCast) {
                        scope.problemReporter().unnecessaryCast((CastExpression)this.right);
                    }
                }
            }
            this.resolvedType = TypeBinding.BOOLEAN;
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        scope.problemReporter().notCompatibleTypesError(this, leftType, rightType);
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 31;
    }
}

