/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.ear;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class GroupEARProvider {
    private static final String PROJECT_RELATIVE_PATH = "META-INF/application.xml";
    private static Image EAR_IMAGE;
    private EARVirtualComponent earComponent;
    private IFile ddFile;

    public GroupEARProvider(EARVirtualComponent wtpComponent) {
        this.earComponent = wtpComponent;
    }

    public IProject getProject() {
        return this.earComponent.getProject();
    }

    public String getText() {
        return "Deployment Descriptor: " + this.earComponent.getName();
    }

    public EARVirtualComponent getEARVirtualComponent() {
        return this.earComponent;
    }

    public List getChildren() {
        return null;
    }

    public Image getImage() {
        return GroupEARProvider.getEarImage();
    }

    public static Image getEarImage() {
        if (EAR_IMAGE == null) {
            ImageDescriptor imageDescriptor = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.EAR_IMAGE);
            EAR_IMAGE = imageDescriptor.createImage();
        }
        return EAR_IMAGE;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        this.ddFile = virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
        return this.ddFile;
    }
}

