/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context;

import java.util.ListIterator;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.caching.Caching;
import org.eclipse.jpt.eclipselink.core.internal.context.caching.EclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.internal.context.connection.Connection;
import org.eclipse.jpt.eclipselink.core.internal.context.connection.EclipseLinkConnection;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.EclipseLinkCustomization;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.EclipseLinkLogging;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logging;
import org.eclipse.jpt.eclipselink.core.internal.context.options.EclipseLinkOptions;
import org.eclipse.jpt.eclipselink.core.internal.context.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.SchemaGeneration;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJpaProperties
extends AbstractModel
implements EclipseLinkProperties {
    private PersistenceUnit persistenceUnit;
    private Caching caching;
    private Connection connection;
    private Customization customization;
    private Logging logging;
    private Options options;
    private SchemaGeneration schemaGeneration;
    private ListValueModel<Property> propertiesAdapter;
    private ListValueModel<Property> propertyListAdapter;
    private static final long serialVersionUID = 1L;

    public EclipseLinkJpaProperties(PersistenceUnit parent) {
        this.initialize(parent);
    }

    protected void initialize(PersistenceUnit parent) {
        this.persistenceUnit = parent;
        SimplePropertyValueModel persistenceUnitHolder = new SimplePropertyValueModel((Object)this.persistenceUnit);
        this.propertiesAdapter = this.buildPropertiesAdapter((PropertyValueModel<PersistenceUnit>)persistenceUnitHolder);
        this.propertyListAdapter = this.buildPropertyListAdapter(this.propertiesAdapter);
        this.caching = this.buildCaching();
        this.connection = this.buildConnection();
        this.customization = this.buildCustomization();
        this.logging = this.buildLogging();
        this.options = this.buildOptions();
        this.schemaGeneration = this.buildSchemaGeneration();
    }

    private ListValueModel<Property> buildPropertyListAdapter(ListValueModel<Property> propertiesAdapter) {
        return new ItemPropertyListValueModelAdapter(propertiesAdapter, new String[]{"value"});
    }

    private ListValueModel<Property> buildPropertiesAdapter(PropertyValueModel<PersistenceUnit> subjectHolder) {
        return new ListAspectAdapter<PersistenceUnit, Property>(subjectHolder, new String[]{"properties"}){

            protected ListIterator<Property> listIterator_() {
                return ((PersistenceUnit)this.subject).properties();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).propertiesSize();
            }
        };
    }

    private Caching buildCaching() {
        return new EclipseLinkCaching(this.persistenceUnit(), this.propertyListAdapter());
    }

    private Connection buildConnection() {
        return new EclipseLinkConnection(this.persistenceUnit(), this.propertyListAdapter());
    }

    private Customization buildCustomization() {
        return new EclipseLinkCustomization(this.persistenceUnit(), this.propertyListAdapter());
    }

    private Logging buildLogging() {
        return new EclipseLinkLogging(this.persistenceUnit(), this.propertyListAdapter());
    }

    private Options buildOptions() {
        return new EclipseLinkOptions(this.persistenceUnit(), this.propertyListAdapter());
    }

    private SchemaGeneration buildSchemaGeneration() {
        return new EclipseLinkSchemaGeneration(this.persistenceUnit(), this.propertyListAdapter());
    }

    @Override
    public Caching getCaching() {
        return this.caching;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Customization getCustomization() {
        return this.customization;
    }

    @Override
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public SchemaGeneration getSchemaGeneration() {
        return this.schemaGeneration;
    }

    public ListValueModel<Property> propertiesAdapter() {
        return this.propertiesAdapter;
    }

    public ListValueModel<Property> propertyListAdapter() {
        return this.propertyListAdapter;
    }

    @Override
    public PersistenceUnit persistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    @Override
    public boolean itemIsProperty(Property item) {
        throw new UnsupportedOperationException();
    }

    public void propertyChanged(PropertyChangeEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String propertyIdFor(Property property) {
        throw new UnsupportedOperationException();
    }
}

