/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.css.core.internal.document.CSSSelectorCombinator;
import org.eclipse.wst.css.core.internal.document.CSSSimpleSelector;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;

public class CSSSelectorParser {
    private static final int IDLE = 0;
    private static final int ATTRIBUTE = 1;
    private static final int SIMPLE = 2;
    private List fTokens = null;
    private List fItems = null;
    private List fErrors = null;

    CSSSelectorParser(List tokens) {
        this.fTokens = new ArrayList(tokens);
    }

    List getSelector() {
        if (this.fItems == null) {
            this.parseSelector();
        }
        return this.fItems;
    }

    private void parseSelector() {
        this.fItems = new ArrayList();
        ArrayList<CSSTextToken> attrBuf = null;
        CSSSimpleSelector item = null;
        int status = 0;
        Iterator i = this.fTokens.iterator();
        while (i.hasNext()) {
            CSSTextToken token = (CSSTextToken)i.next();
            if (token == null || token.kind == "S" || token.kind == "COMMENT") continue;
            switch (status) {
                case 0: {
                    if (this.isTag(token)) {
                        item = this.createSimple();
                        this.appendTag(item, token);
                        status = 2;
                        break;
                    }
                    if (this.isID(token)) {
                        item = this.createSimple();
                        this.appendID(item, token);
                        status = 2;
                        break;
                    }
                    if (this.isClass(token)) {
                        item = this.createSimple();
                        this.appendClass(item, token);
                        status = 2;
                        break;
                    }
                    if (this.isPseudo(token)) {
                        item = this.createSimple();
                        this.appendPseudo(item, token);
                        status = 2;
                        break;
                    }
                    if (this.isAttributeBegin(token)) {
                        item = this.createSimple();
                        status = 1;
                        break;
                    }
                    this.addError(token);
                    break;
                }
                case 2: {
                    if (this.isID(token)) {
                        this.appendID(item, token);
                        break;
                    }
                    if (this.isClass(token)) {
                        this.appendClass(item, token);
                        break;
                    }
                    if (this.isPseudo(token)) {
                        this.appendPseudo(item, token);
                        break;
                    }
                    if (this.isAttributeBegin(token)) {
                        status = 1;
                        break;
                    }
                    if (this.isCombinator(token)) {
                        this.closeItem(item);
                        this.closeItem(this.createCombinator(token));
                        status = 0;
                        break;
                    }
                    this.addError(token);
                    break;
                }
                case 1: {
                    if (this.isAttributeEnd(token)) {
                        this.appendAttribute(item, attrBuf);
                        attrBuf = null;
                        status = 2;
                        break;
                    }
                    if (attrBuf == null) {
                        attrBuf = new ArrayList<CSSTextToken>();
                    }
                    attrBuf.add(token);
                    if (this.isAttributeContent(token)) break;
                    this.addError(token);
                    break;
                }
            }
        }
        this.closeItem(item);
    }

    private boolean isAttributeContent(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_ATTRIBUTE_NAME" || type == "SELECTOR_ATTRIBUTE_OPERATOR" || type == "SELECTOR_ATTRIBUTE_VALUE";
    }

    private boolean isAttributeEnd(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_ATTRIBUTE_END";
    }

    private boolean isAttributeBegin(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_ATTRIBUTE_START";
    }

    private boolean isCombinator(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_COMBINATOR";
    }

    private boolean isPseudo(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_PSEUDO";
    }

    private boolean isClass(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_CLASS";
    }

    private boolean isID(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_ID";
    }

    private boolean isTag(CSSTextToken token) {
        String type = token.kind;
        return type == "SELECTOR_ELEMENT_NAME" || type == "SELECTOR_UNIVERSAL" || type == "UNKNOWN";
    }

    private CSSSimpleSelector createSimple() {
        return new CSSSimpleSelector();
    }

    private CSSSelectorCombinator createCombinator(CSSTextToken token) {
        int type = 0;
        String str = token.image;
        if (str.trim().length() == 0) {
            type = 32;
        } else if (str.equals("+")) {
            type = 43;
        } else if (str.equals(">")) {
            type = 62;
        }
        if (type > 0) {
            return new CSSSelectorCombinator((char)type);
        }
        return null;
    }

    private void closeItem(ICSSSelectorItem item) {
        if (item != null) {
            this.fItems.add(item);
        }
    }

    private void appendTag(CSSSimpleSelector item, CSSTextToken token) {
        item.setName(token.image);
        if (token.kind == "UNKNOWN") {
            this.addError(token);
        }
    }

    private void appendID(CSSSimpleSelector item, CSSTextToken token) {
        String text = token.toString();
        String idContent = text.substring(1, text.length());
        item.addID(idContent);
    }

    private void appendClass(CSSSimpleSelector item, CSSTextToken token) {
        String text = token.toString();
        String classContent = text.substring(1, text.length());
        item.addClass(classContent);
        if (Character.isDigit(classContent.charAt(0))) {
            this.addError(token);
        }
    }

    private void appendPseudo(CSSSimpleSelector item, CSSTextToken token) {
        String text = token.toString();
        String pseudoContent = text.substring(1, text.length());
        item.addPseudoName(pseudoContent);
    }

    private void appendAttribute(CSSSimpleSelector item, List tokens) {
        StringBuffer buf = new StringBuffer();
        Iterator i = tokens.iterator();
        while (i.hasNext()) {
            CSSTextToken token = (CSSTextToken)i.next();
            buf.append(token.image);
        }
        item.addAttribute(buf.toString());
    }

    List getSelectorTags() {
        ArrayList tagList = new ArrayList();
        return tagList;
    }

    private void addError(CSSTextToken token) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList();
        }
        this.fErrors.add(token);
    }

    Iterator getErrors() {
        return this.fErrors == null ? Collections.EMPTY_LIST.iterator() : this.fErrors.iterator();
    }
}

