/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualResource;
import org.eclipse.wst.common.componentcore.internal.util.ComponentImplManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ComponentCore {
    private static final IVirtualResource[] NO_RESOURCES = new VirtualResource[0];

    public static IVirtualComponent createComponent(IProject aProject) {
        if (aProject == null || !aProject.isAccessible()) {
            return null;
        }
        return ComponentImplManager.instance().createComponent(aProject);
    }

    public static IVirtualComponent createComponent(IProject aProject, String aName) {
        return ComponentCore.createComponent(aProject);
    }

    public static IVirtualComponent createArchiveComponent(IProject aProject, String aComponentName) {
        return ComponentImplManager.instance().createArchiveComponent(aProject, aComponentName);
    }

    public static IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return ComponentImplManager.instance().createFolder(aProject, aRuntimePath);
    }

    public static IVirtualFile createFile(IProject aProject, IPath aRuntimePath) {
        return new VirtualFile(aProject, aRuntimePath);
    }

    public static IVirtualReference createReference(IVirtualComponent aComponent, IVirtualComponent aReferencedComponent) {
        return new VirtualReference(aComponent, aReferencedComponent);
    }

    public static IVirtualReference createReference(IVirtualComponent aComponent, IVirtualComponent aReferencedComponent, IPath runtimePath) {
        return new VirtualReference(aComponent, aReferencedComponent, runtimePath);
    }

    public static IVirtualResource[] createResources(IResource aResource) {
        ArrayList<IVirtualResource> foundResources;
        block13: {
            IProject proj = aResource.getProject();
            StructureEdit se = null;
            foundResources = new ArrayList<IVirtualResource>();
            try {
                try {
                    se = StructureEdit.getStructureEditForRead(proj);
                    if (se != null) {
                        ComponentResource[] resources = se.findResourcesBySourcePath(aResource.getProjectRelativePath(), aResource.exists() ? 0 : 2);
                        int i = 0;
                        while (i < resources.length) {
                            if (aResource.getType() == 1) {
                                foundResources.add(new VirtualFile(proj, resources[i].getRuntimePath()));
                            } else {
                                foundResources.add(ComponentCore.createFolder(proj, resources[i].getRuntimePath()));
                            }
                            ++i;
                        }
                    }
                }
                catch (UnresolveableURIException e) {
                    e.printStackTrace();
                    if (se != null) {
                        se.dispose();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (se != null) {
                    se.dispose();
                }
                throw throwable;
            }
            if (se != null) {
                se.dispose();
            }
        }
        if (foundResources.size() > 0) {
            return foundResources.toArray(new VirtualResource[foundResources.size()]);
        }
        return NO_RESOURCES;
    }
}

