/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.format;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractStructuredFormatProcessor
implements IStructuredFormatProcessor {
    protected IStructuredFormatContraints fFormatContraints = null;
    protected IProgressMonitor fProgressMonitor = null;
    public boolean refreshFormatPreferences = true;
    private final int MAX_SMALL_FORMAT_SIZE = 1000;

    protected void ensureClosed(OutputStream outputStream, InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public String formatContent(String input) throws IOException, CoreException {
        if (input == null) {
            return input;
        }
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
            String id = String.valueOf(inputStream.toString()) + "." + this.getFileExtension();
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
            this.formatModel(structuredModel);
            String string = structuredModel.getStructuredDocument().get();
            Object var5_6 = null;
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            return string;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_7 = null;
                this.ensureClosed(null, inputStream);
                if (structuredModel == null) break block4;
                structuredModel.releaseFromRead();
            }
            throw throwable;
        }
    }

    public String formatContent(String input, int start, int length) throws IOException, CoreException {
        if (input == null) {
            return input;
        }
        if (start >= 0 && length >= 0 && start + length <= input.length()) {
            IStructuredModel structuredModel = null;
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
                String id = String.valueOf(inputStream.toString()) + "." + this.getFileExtension();
                structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
                this.formatModel(structuredModel, start, length);
                String string = structuredModel.getStructuredDocument().get();
                Object var7_8 = null;
                this.ensureClosed(null, inputStream);
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                return string;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.ensureClosed(null, inputStream);
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
        }
        return input;
    }

    /*
     * Exception decompiling
     */
    public void formatDocument(IDocument document) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void formatDocument(IDocument document, int start, int length) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 106->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void formatFile(IFile file) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void formatFile(IFile file, int start, int length) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 81->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void formatFileName(String fileName) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void formatFileName(String fileName, int start, int length) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void formatModel(IStructuredModel structuredModel) {
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.formatModel(structuredModel, start, length);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        if (structuredModel == null) return;
        startTime = System.currentTimeMillis();
        docExt4 = null;
        if (structuredModel.getStructuredDocument() instanceof IDocumentExtension4) {
            docExt4 = (IDocumentExtension4)structuredModel.getStructuredDocument();
        }
        rewriteSession = null;
        try {
            structuredModel.aboutToChangeModel();
            rewriteType = length > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
            v0 = rewriteSession = docExt4 == null || docExt4.getActiveRewriteSession() != null ? null : docExt4.startRewriteSession(rewriteType);
            if (start == 0 && length == structuredModel.getStructuredDocument().getLength()) {
                this.setFormatWithSiblingIndent(structuredModel, false);
            } else {
                this.setFormatWithSiblingIndent(structuredModel, true);
            }
            if (start >= 0 && length >= 0 && start + length <= structuredModel.getStructuredDocument().getLength() && (activeNodes = this.getAllActiveNodes(structuredModel, start, length)).size() > 0) {
                firstNode = (Node)activeNodes.get(0);
                lastNode = (Node)activeNodes.get(activeNodes.size() - 1);
                done = false;
                eachNode = firstNode;
                nextNode = null;
                while (!done) {
                    done = eachNode == lastNode;
                    nextNode = eachNode.getNextSibling();
                    this.formatNode(eachNode);
                    eachNode = nextNode != null && nextNode.getParentNode() == null ? eachNode.getNextSibling() : nextNode;
                    if (eachNode != null) continue;
                    done = true;
                }
            }
            var15_17 = null;
        }
        catch (Throwable var16_15) {
            var15_16 = null;
            try {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
                v1 = null;
            }
            catch (Throwable var18_18) {
                v1 = null;
            }
            var17_20 = v1;
            structuredModel.changedModel();
            throw var16_15;
        }
        ** try [egrp 1[TRYBLOCK] [2 : 303->325)] { 
lbl46:
        // 1 sources

        if (docExt4 != null && rewriteSession != null) {
            docExt4.stopRewriteSession(rewriteSession);
        }
        v2 = null;
        ** GOTO lbl52
lbl50:
        // 1 sources

        catch (Throwable var18_19) {
            v2 = null;
lbl52:
            // 2 sources

            var17_21 = v2;
            structuredModel.changedModel();
        }
        if (Logger.DEBUG_FORMAT == false) return;
        endTime = System.currentTimeMillis();
        System.out.println("formatModel time: " + (endTime - startTime));
    }

    public void formatNode(Node node) {
        if (node != null) {
            Node newNode = node;
            if (node.getNodeType() == 2) {
                newNode = ((Attr)node).getOwnerElement();
            }
            if (this.refreshFormatPreferences) {
                this.refreshFormatPreferences();
            }
            IStructuredFormatter formatter = this.getFormatter(newNode);
            Assert.isNotNull(formatter, "formatter was null for a node, ");
            IStructuredFormatContraints formatContraints = formatter.getFormatContraints();
            formatContraints.setFormatWithSiblingIndent(true);
            formatter.format(newNode, formatContraints);
        }
    }

    protected Vector getActiveNodes(IStructuredModel structuredModel, int startNodeOffset, int length) {
        List allActiveNodes = this.getAllActiveNodes(structuredModel, startNodeOffset, length);
        return new Vector(allActiveNodes);
    }

    protected List getAllActiveNodes(IStructuredModel structuredModel, int startNodeOffset, int length) {
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        if (structuredModel != null) {
            Node startNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset));
            int endNodeOffset = length > 0 ? startNodeOffset + length - 1 : startNodeOffset + length;
            Node endNode = (Node)((Object)structuredModel.getIndexedRegion(endNodeOffset));
            if (startNode != null) {
                while (!this.isSiblingOf(startNode, endNode)) {
                    if (endNode != null) {
                        endNode = endNode.getParentNode();
                    }
                    if (endNode != null) continue;
                    startNode = startNode.getParentNode();
                    endNodeOffset = length > 0 ? startNodeOffset + length - 1 : startNodeOffset + length;
                    endNode = (Node)((Object)structuredModel.getIndexedRegion(endNodeOffset));
                }
                while (startNode != endNode) {
                    activeNodes.add(startNode);
                    startNode = startNode.getNextSibling();
                }
                if (startNode != null) {
                    activeNodes.add(startNode);
                }
            }
        }
        return activeNodes;
    }

    protected abstract String getFileExtension();

    protected IStructuredFormatContraints getFormatContraints(IStructuredModel structuredModel) {
        IStructuredFormatter formatter;
        Node node;
        if (this.fFormatContraints == null && structuredModel != null && (node = (Node)((Object)structuredModel.getIndexedRegion(0))) != null && (formatter = this.getFormatter(node)) != null) {
            this.fFormatContraints = formatter.getFormatContraints();
        }
        return this.fFormatContraints;
    }

    protected abstract IStructuredFormatter getFormatter(Node var1);

    protected boolean isSiblingOf(Node node, Node endNode) {
        if (endNode == null) {
            return true;
        }
        Node siblingNode = node;
        while (siblingNode != null) {
            if (siblingNode == endNode) {
                return true;
            }
            siblingNode = siblingNode.getNextSibling();
        }
        return false;
    }

    protected abstract void refreshFormatPreferences();

    protected void setFormatWithSiblingIndent(IStructuredModel structuredModel, boolean formatWithSiblingIndent) {
        IStructuredFormatContraints formatContraints = this.getFormatContraints(structuredModel);
        if (formatContraints != null) {
            formatContraints.setFormatWithSiblingIndent(formatWithSiblingIndent);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }
}

