/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable
extends AbstractJavaJpaContextNode
implements UniqueConstraint.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final List<JavaUniqueConstraint> uniqueConstraints = new ArrayList<JavaUniqueConstraint>();

    protected AbstractJavaTable(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    protected abstract TableAnnotation getTableResource();

    protected abstract String getAnnotationName();

    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.getTableResource().setName(newSpecifiedName);
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.getTableResource().setCatalog(newSpecifiedCatalog);
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    protected void setSpecifiedCatalog_(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.getTableResource().setSchema(newSpecifiedSchema);
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public ListIterator<JavaUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    public JavaUniqueConstraint addUniqueConstraint(int index) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        this.uniqueConstraints.add(index, uniqueConstraint);
        UniqueConstraintAnnotation uniqueConstraintAnnotation = this.getTableResource().addUniqueConstraint(index);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        this.fireItemAdded("uniqueConstraintsList", index, uniqueConstraint);
        return uniqueConstraint;
    }

    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    public void removeUniqueConstraint(int index) {
        JavaUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        this.getTableResource().removeUniqueConstraint(index);
        this.fireItemRemoved("uniqueConstraintsList", index, removedUniqueConstraint);
    }

    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        this.getTableResource().moveUniqueConstraint(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraintsList", targetIndex, sourceIndex);
    }

    protected void addUniqueConstraint(int index, JavaUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    protected void removeUniqueConstraint_(JavaUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableResource().getNameTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getTableResource().nameTouches(pos, astRoot);
    }

    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableResource().getSchemaTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.getTableResource().schemaTouches(pos, astRoot);
    }

    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getTableResource().getCatalogTextRange(astRoot);
    }

    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.getTableResource().catalogTouches(pos, astRoot);
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalogProperty", oldDefaultCatalog, newDefaultCatalog);
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchemaProperty", oldDefaultSchema, newDefaultSchema);
    }

    protected void initializeFromResource(TableAnnotation table) {
        this.defaultName = this.defaultName();
        this.defaultSchema = this.defaultSchema();
        this.defaultCatalog = this.defaultCatalog();
        this.specifiedName = table.getName();
        this.specifiedSchema = table.getSchema();
        this.specifiedCatalog = table.getCatalog();
        this.initializeUniqueConstraints(table);
    }

    protected void initializeUniqueConstraints(TableAnnotation table) {
        for (UniqueConstraintAnnotation uniqueConstraintAnnotation : CollectionTools.iterable(table.uniqueConstraints())) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraintAnnotation));
        }
    }

    protected void update(TableAnnotation table) {
        this.setSpecifiedName_(table.getName());
        this.setSpecifiedSchema_(table.getSchema());
        this.setSpecifiedCatalog_(table.getCatalog());
        this.setDefaultName(this.defaultName());
        this.setDefaultSchema(this.defaultSchema());
        this.setDefaultCatalog(this.defaultCatalog());
        this.updateUniqueConstraints(table);
    }

    protected abstract String defaultName();

    protected String defaultSchema() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getSchema();
        }
        return this.getPersistenceUnit().getDefaultSchema();
    }

    protected String defaultCatalog() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getCatalog();
        }
        return this.getPersistenceUnit().getDefaultCatalog();
    }

    protected void updateUniqueConstraints(TableAnnotation table) {
        ListIterator<JavaUniqueConstraint> uniqueConstraints = this.uniqueConstraints();
        ListIterator<UniqueConstraintAnnotation> resourceUniqueConstraints = table.uniqueConstraints();
        while (uniqueConstraints.hasNext()) {
            JavaUniqueConstraint uniqueConstraint = uniqueConstraints.next();
            if (resourceUniqueConstraints.hasNext()) {
                uniqueConstraint.update(resourceUniqueConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(uniqueConstraint);
        }
        while (resourceUniqueConstraints.hasNext()) {
            this.addUniqueConstraint(this.uniqueConstraintsSize(), this.buildUniqueConstraint(resourceUniqueConstraints.next()));
        }
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation uniqueConstraintAnnotation) {
        JavaUniqueConstraint uniqueConstraint = this.getJpaFactory().buildJavaUniqueConstraint(this, this);
        uniqueConstraint.initialize(uniqueConstraintAnnotation);
        return uniqueConstraint;
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        if (dbTable != null) {
            return dbTable.columnNames();
        }
        return EmptyIterator.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableResource().getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public Table getDbTable() {
        Schema schema = this.getDbSchema();
        return schema == null ? null : schema.tableNamed(this.getName());
    }

    public Schema getDbSchema() {
        return this.getDatabase().schemaNamed(this.getSchema());
    }

    public boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaUniqueConstraint constraint : CollectionTools.iterable(this.uniqueConstraints())) {
            result = constraint.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.quotedCandidateNames(filter);
        }
        if (this.schemaTouches(pos, astRoot)) {
            return this.quotedCandidateSchemas(filter);
        }
        if (this.catalogTouches(pos, astRoot)) {
            return this.quotedCandidateCatalogs(filter);
        }
        return null;
    }

    private Iterator<String> candidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.tableNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> quotedCandidateNames(Filter<String> filter) {
        return StringTools.quote(this.candidateNames(filter));
    }

    private Iterator<String> candidateSchemas() {
        return this.getDatabase().schemaNames();
    }

    private Iterator<String> candidateSchemas(Filter<String> filter) {
        return new FilteringIterator(this.candidateSchemas(), filter);
    }

    private Iterator<String> quotedCandidateSchemas(Filter<String> filter) {
        return StringTools.quote(this.candidateSchemas(filter));
    }

    private Iterator<String> candidateCatalogs() {
        return this.getDatabase().catalogNames();
    }

    private Iterator<String> candidateCatalogs(Filter<String> filter) {
        return new FilteringIterator(this.candidateCatalogs(), filter);
    }

    private Iterator<String> quotedCandidateCatalogs(Filter<String> filter) {
        return StringTools.quote(this.candidateCatalogs(filter));
    }

    public String getQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getQualifiedName());
    }

    @Override
    public String displayString() {
        return this.getQualifiedName();
    }
}

