/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaOverride;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaAttributeOverride
extends AbstractJavaOverride
implements JavaAttributeOverride {
    protected final JavaColumn column = this.getJpaFactory().buildJavaColumn(this, this);

    public GenericJavaAttributeOverride(JavaJpaContextNode parent, AttributeOverride.Owner owner) {
        super(parent, owner);
    }

    @Override
    public JavaAttributeOverride setVirtual(boolean virtual) {
        return (JavaAttributeOverride)super.setVirtual(virtual);
    }

    @Override
    protected AttributeOverrideAnnotation getOverrideResource() {
        return (AttributeOverrideAnnotation)super.getOverrideResource();
    }

    @Override
    public AttributeOverride.Owner getOwner() {
        return (AttributeOverride.Owner)super.getOwner();
    }

    @Override
    public ColumnAnnotation getColumnResource() {
        return this.getOverrideResource().getNonNullColumn();
    }

    @Override
    public String getDefaultColumnName() {
        ColumnMapping columnMapping = this.getColumnMapping();
        if (columnMapping == null) {
            return null;
        }
        return columnMapping.getColumn().getName();
    }

    @Override
    public String getDefaultTableName() {
        ColumnMapping columnMapping = this.getColumnMapping();
        if (columnMapping == null) {
            return null;
        }
        String tableName = columnMapping.getColumn().getSpecifiedTable();
        if (tableName != null) {
            return tableName;
        }
        return this.getOwner().getTypeMapping().getTableName();
    }

    protected ColumnMapping getColumnMapping() {
        return this.getOwner().getColumnMapping(this.getName());
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getOwner().getTypeMapping();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    protected Iterator<String> candidateNames() {
        return this.getOwner().getTypeMapping().allOverridableAttributeNames();
    }

    @Override
    public void initializeFromResource(AttributeOverrideAnnotation attributeOverrideResource) {
        super.initializeFromResource(attributeOverrideResource);
        this.column.initializeFromResource(this.getColumnResource());
    }

    @Override
    public void update(AttributeOverrideAnnotation attributeOverrideResource) {
        super.update(attributeOverrideResource);
        this.column.update(this.getColumnResource());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        this.addColumnMessages(messages, astRoot);
    }

    protected void addColumnMessages(List<IMessage> messages, CompilationUnit astRoot) {
        String table = this.getColumn().getTable();
        boolean doContinue = this.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), table, this.getColumn().getName()}, this.getColumn(), this.getColumn().getTableTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, this.getColumn().getName()}, this.getColumn(), this.getColumn().getTableTextRange(astRoot)));
            }
            doContinue = false;
        }
        if (doContinue && !this.getColumn().isResolved()) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), this.getColumn().getName()}, this.getColumn(), this.getColumn().getNameTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.getColumn().getName()}, this.getColumn(), this.getColumn().getNameTextRange(astRoot)));
            }
        }
    }
}

