/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBaseEmbeddedMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverride;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlColumn;
import org.eclipse.jpt.core.resource.orm.BaseXmlEmbedded;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverrideImpl;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseEmbeddedMapping<T extends BaseXmlEmbedded>
extends AbstractOrmAttributeMapping<T>
implements OrmBaseEmbeddedMapping {
    protected final List<OrmAttributeOverride> specifiedAttributeOverrides = new ArrayList<OrmAttributeOverride>();
    protected final List<OrmAttributeOverride> virtualAttributeOverrides = new ArrayList<OrmAttributeOverride>();
    private Embeddable embeddable;

    protected AbstractOrmBaseEmbeddedMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        super.initializeFromOrmBaseEmbeddedMapping(oldMapping);
        int index = 0;
        for (OrmAttributeOverride attributeOverride : CollectionTools.iterable(oldMapping.specifiedAttributeOverrides())) {
            OrmAttributeOverride newAttributeOverride = this.addSpecifiedAttributeOverride(index++);
            newAttributeOverride.setName(attributeOverride.getName());
            newAttributeOverride.getColumn().initializeFrom(attributeOverride.getColumn());
        }
    }

    @Override
    public ListIterator<OrmAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<OrmAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    protected void addVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverridesList");
    }

    protected void removeVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverridesList");
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    @Override
    public ListIterator<OrmAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected OrmAttributeOverride addSpecifiedAttributeOverride(int index) {
        XmlAttributeOverrideImpl xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl();
        OrmAttributeOverride attributeOverride = this.buildAttributeOverride(xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, attributeOverride);
        ((BaseXmlEmbedded)this.getAttributeMapping()).getAttributeOverrides().add(index, (Object)xmlAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverridesList", index, attributeOverride);
        return attributeOverride;
    }

    protected void addSpecifiedAttributeOverride(int index, OrmAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    protected void removeSpecifiedAttributeOverride_(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        ((BaseXmlEmbedded)this.getAttributeMapping()).getAttributeOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAttributeOverridesList", targetIndex, sourceIndex);
    }

    @Override
    public OrmAttributeOverride getAttributeOverrideNamed(String name) {
        return (OrmAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    protected BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    @Override
    public boolean isVirtual(BaseOverride override) {
        return this.virtualAttributeOverrides.contains(override);
    }

    @Override
    public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
        if (virtual) {
            return this.setVirtual((OrmAttributeOverride)override);
        }
        return this.setSpecified((OrmAttributeOverride)override);
    }

    protected OrmAttributeOverride setVirtual(OrmAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        OrmAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
                if (!persistentAttribute.getName().equals(attributeOverrideName)) continue;
                JavaAttributeOverride javaAttributeOverride = null;
                if (this.getJavaEmbeddedMapping() != null) {
                    javaAttributeOverride = this.getJavaEmbeddedMapping().getAttributeOverrideNamed(attributeOverrideName);
                }
                virtualAttributeOverride = this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
            }
        }
        ((BaseXmlEmbedded)this.getAttributeMapping()).getAttributeOverrides().remove(index);
        this.fireItemRemoved("specifiedAttributeOverridesList", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverridesList", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected OrmAttributeOverride setSpecified(OrmAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        XmlAttributeOverrideImpl xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl();
        OrmAttributeOverride newAttributeOverride = this.getJpaFactory().buildOrmAttributeOverride(this, this, xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        ((BaseXmlEmbedded)this.getAttributeMapping()).getAttributeOverrides().add((Object)xmlAttributeOverride);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverridesList", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverridesList", index, newAttributeOverride);
        return newAttributeOverride;
    }

    @Override
    public ColumnMapping getColumnMapping(String attributeName) {
        return MappingTools.getColumnMapping(attributeName, this.getEmbeddable());
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    public Iterator<String> allOverridableAttributeNames() {
        return new TransformationIterator<PersistentAttribute, String>(this.allOverridableAttributes()){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    public Iterator<PersistentAttribute> allOverridableAttributes() {
        if (this.getEmbeddable() == null) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<PersistentAttribute, PersistentAttribute>((Iterator)this.getEmbeddable().getPersistentType().attributes()){

            protected boolean accept(PersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    public AbstractJavaBaseEmbeddedMapping<?> getJavaEmbeddedMapping() {
        JavaPersistentAttribute javaPersistentAttribute = this.getJavaPersistentAttribute();
        if (javaPersistentAttribute != null && javaPersistentAttribute.getMappingKey() == this.getKey()) {
            return (AbstractJavaBaseEmbeddedMapping)javaPersistentAttribute.getMapping();
        }
        return null;
    }

    @Override
    public void initialize(T embedded) {
        super.initialize(embedded);
        this.embeddable = AbstractOrmBaseEmbeddedMapping.embeddableFor(this.findJavaPersistentAttribute());
        this.initializeSpecifiedAttributeOverrides(embedded);
        this.initializeVirtualAttributeOverrides();
    }

    protected void initializeSpecifiedAttributeOverrides(T embedded) {
        for (XmlAttributeOverride attributeOverride : embedded.getAttributeOverrides()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride(attributeOverride));
        }
    }

    protected void initializeVirtualAttributeOverrides() {
        if (this.getPersistentAttribute().isVirtual()) {
            return;
        }
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
            OrmAttributeOverride attributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
            if (attributeOverride != null) continue;
            JavaAttributeOverride javaAttributeOverride = null;
            if (this.getJavaEmbeddedMapping() != null) {
                javaAttributeOverride = this.getJavaEmbeddedMapping().getAttributeOverrideNamed(persistentAttribute.getName());
            }
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
        }
    }

    protected OrmAttributeOverride buildVirtualAttributeOverride(PersistentAttribute persistentAttribute, JavaAttributeOverride javaAttributeOverride) {
        return this.buildAttributeOverride(this.buildVirtualXmlAttributeOverride(persistentAttribute, javaAttributeOverride));
    }

    protected XmlAttributeOverride buildVirtualXmlAttributeOverride(PersistentAttribute persistentAttribute, JavaAttributeOverride javaAttributeOverride) {
        VirtualXmlColumn xmlColumn;
        if (javaAttributeOverride == null) {
            ColumnMapping columnMapping = (ColumnMapping)((Object)persistentAttribute.getMapping());
            xmlColumn = new VirtualXmlColumn((OrmTypeMapping)this.getTypeMapping(), columnMapping.getColumn(), false);
        } else {
            xmlColumn = new VirtualXmlColumn((OrmTypeMapping)this.getTypeMapping(), javaAttributeOverride.getColumn(), true);
        }
        return new VirtualXmlAttributeOverride(persistentAttribute.getName(), xmlColumn);
    }

    protected OrmAttributeOverride buildAttributeOverride(XmlAttributeOverride attributeOverride) {
        return this.getJpaFactory().buildOrmAttributeOverride(this, this, attributeOverride);
    }

    @Override
    public void update(T embedded) {
        super.update(embedded);
        this.embeddable = AbstractOrmBaseEmbeddedMapping.embeddableFor(this.findJavaPersistentAttribute());
        this.updateSpecifiedAttributeOverrides(embedded);
        this.updateVirtualAttributeOverrides();
    }

    protected void updateSpecifiedAttributeOverrides(T embedded) {
        ListIterator<OrmAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        CloneListIterator resourceAttributeOverrides = new CloneListIterator(embedded.getAttributeOverrides());
        while (attributeOverrides.hasNext()) {
            OrmAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((XmlAttributeOverride)resourceAttributeOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.specifiedAttributeOverridesSize(), this.buildAttributeOverride((XmlAttributeOverride)resourceAttributeOverrides.next()));
        }
    }

    protected void updateVirtualAttributeOverrides() {
        Iterator<PersistentAttribute> overridableAttributes = this.allOverridableAttributes();
        ListIterator<OrmAttributeOverride> virtualAttributeOverrides = this.virtualAttributeOverrides();
        if (!this.getPersistentAttribute().isVirtual()) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(overridableAttributes)) {
                OrmAttributeOverride ormAttributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
                if (ormAttributeOverride != null && !ormAttributeOverride.isVirtual()) continue;
                JavaAttributeOverride javaAttributeOverride = null;
                if (this.getJavaEmbeddedMapping() != null) {
                    javaAttributeOverride = this.getJavaEmbeddedMapping().getAttributeOverrideNamed(persistentAttribute.getName());
                }
                if (ormAttributeOverride != null) {
                    if (virtualAttributeOverrides.hasNext()) {
                        OrmAttributeOverride virtualAttributeOverride = virtualAttributeOverrides.next();
                        virtualAttributeOverride.update(this.buildVirtualXmlAttributeOverride(persistentAttribute, javaAttributeOverride));
                        continue;
                    }
                    this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
                    continue;
                }
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute, javaAttributeOverride));
            }
        }
        for (OrmAttributeOverride virtualAttributeOverride : CollectionTools.iterable(virtualAttributeOverrides)) {
            this.removeVirtualAttributeOverride(virtualAttributeOverride);
        }
    }

    public static Embeddable embeddableFor(JavaPersistentAttribute javaPersistentAttribute) {
        if (javaPersistentAttribute == null) {
            return null;
        }
        return MappingTools.getEmbeddableFor(javaPersistentAttribute);
    }
}

