/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.MultiRelationshipMapping;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.MapKey;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlMultiRelationshipMapping;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmMultiRelationshipMapping<T extends XmlMultiRelationshipMapping>
extends AbstractOrmRelationshipMapping<T>
implements OrmMultiRelationshipMapping {
    protected String mappedBy;
    protected String orderBy;
    protected boolean isNoOrdering;
    protected boolean isPkOrdering;
    protected boolean isCustomOrdering;
    protected final OrmJoinTable joinTable = this.getJpaFactory().buildOrmJoinTable(this);
    protected String mapKey;

    protected AbstractOrmMultiRelationshipMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeFromXmlMulitRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        super.initializeFromXmlMulitRelationshipMapping(oldMapping);
        this.getJoinTable().initializeFrom(oldMapping.getJoinTable());
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public FetchType getDefaultFetch() {
        return MultiRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        ((XmlMultiRelationshipMapping)this.getAttributeMapping()).setMappedBy(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected void setMappedBy_(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        ((XmlMultiRelationshipMapping)this.getAttributeMapping()).setOrderBy(newOrderBy);
        this.firePropertyChanged("orderByProperty", oldOrderBy, newOrderBy);
    }

    protected void setOrderBy_(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        this.firePropertyChanged("orderByProperty", oldOrderBy, newOrderBy);
    }

    @Override
    public boolean isNoOrdering() {
        return this.isNoOrdering;
    }

    @Override
    public void setNoOrdering(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        if (newNoOrdering) {
            ((XmlMultiRelationshipMapping)this.getAttributeMapping()).setOrderBy(null);
        }
        this.firePropertyChanged("noOrderingProperty", oldNoOrdering, newNoOrdering);
    }

    protected void setNoOrdering_(boolean newNoOrdering) {
        boolean oldNoOrdering = this.isNoOrdering;
        this.isNoOrdering = newNoOrdering;
        this.firePropertyChanged("noOrderingProperty", oldNoOrdering, newNoOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.isPkOrdering;
    }

    @Override
    public void setPkOrdering(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        if (newPkOrdering) {
            ((XmlMultiRelationshipMapping)this.getAttributeMapping()).setOrderBy("");
        }
        this.firePropertyChanged("pkOrderingProperty", oldPkOrdering, newPkOrdering);
    }

    protected void setPkOrdering_(boolean newPkOrdering) {
        boolean oldPkOrdering = this.isPkOrdering;
        this.isPkOrdering = newPkOrdering;
        this.firePropertyChanged("pkOrderingProperty", oldPkOrdering, newPkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.isCustomOrdering;
    }

    @Override
    public void setCustomOrdering(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        if (newCustomOrdering) {
            this.setOrderBy("");
        }
        this.firePropertyChanged("customOrderingProperty", oldCustomOrdering, newCustomOrdering);
    }

    protected void setCustomOrdering_(boolean newCustomOrdering) {
        boolean oldCustomOrdering = this.isCustomOrdering;
        this.isCustomOrdering = newCustomOrdering;
        this.firePropertyChanged("customOrderingProperty", oldCustomOrdering, newCustomOrdering);
    }

    @Override
    public OrmJoinTable getJoinTable() {
        return this.joinTable;
    }

    @Override
    public boolean isJoinTableSpecified() {
        return this.getJoinTable().isSpecified();
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public void setMapKey(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        if (oldMapKey != newMapKey) {
            if (this.getMapKeyResource() != null) {
                this.getMapKeyResource().setName(newMapKey);
                if (this.getMapKeyResource().isAllFeaturesUnset()) {
                    this.removeMapKeyResource();
                }
            } else if (newMapKey != null) {
                this.addMapKeyResource();
                this.getMapKeyResource().setName(newMapKey);
            }
        }
        this.firePropertyChanged("mapKeyProperty", oldMapKey, newMapKey);
    }

    protected void setMapKey_(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        this.firePropertyChanged("mapKeyProperty", oldMapKey, newMapKey);
    }

    protected MapKey getMapKeyResource() {
        return ((XmlMultiRelationshipMapping)this.getAttributeMapping()).getMapKey();
    }

    protected void removeMapKeyResource() {
        ((XmlMultiRelationshipMapping)this.getAttributeMapping()).setMapKey(null);
    }

    protected void addMapKeyResource() {
        ((XmlMultiRelationshipMapping)this.getAttributeMapping()).setMapKey(OrmFactory.eINSTANCE.createMapKeyImpl());
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEntityAttributeNames();
    }

    public TextRange getMappedByTextRange() {
        TextRange mappedByTextRange = ((XmlMultiRelationshipMapping)this.getAttributeMapping()).getMappedByTextRange();
        return mappedByTextRange != null ? mappedByTextRange : this.getValidationTextRange();
    }

    @Override
    public void initialize(T multiRelationshipMapping) {
        super.initialize(multiRelationshipMapping);
        this.mappedBy = multiRelationshipMapping.getMappedBy();
        this.mapKey = this.mapKey(multiRelationshipMapping);
        this.orderBy = this.orderBy(multiRelationshipMapping);
        if (this.orderBy == null) {
            this.isNoOrdering = true;
        } else {
            this.isCustomOrdering = true;
        }
        this.joinTable.initialize((XmlRelationshipMapping)multiRelationshipMapping);
    }

    @Override
    public void update(T multiRelationshipMapping) {
        super.update(multiRelationshipMapping);
        this.setMappedBy_(multiRelationshipMapping.getMappedBy());
        this.setMapKey_(this.mapKey(multiRelationshipMapping));
        this.setOrderBy_(this.orderBy(multiRelationshipMapping));
        if (this.getOrderBy() == null) {
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
        } else {
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
        }
        this.joinTable.update((XmlRelationshipMapping)multiRelationshipMapping);
    }

    protected String mapKey(T multiRelationshipMapping) {
        return multiRelationshipMapping.getMapKey() == null ? null : multiRelationshipMapping.getMapKey().getName();
    }

    protected String orderBy(T multiRelationshipMapping) {
        return multiRelationshipMapping.getOrderBy();
    }

    @Override
    protected String defaultTargetEntity(JavaResourcePersistentAttribute persistentAttributeResource) {
        if (!persistentAttributeResource.typeIsContainer()) {
            return null;
        }
        return persistentAttributeResource.getQualifiedReferenceEntityElementTypeName();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned() && (this.isJoinTableSpecified() || this.isRelationshipOwner())) {
            this.getJoinTable().addToMessages(messages);
        }
        if (this.getMappedBy() != null) {
            this.addMappedByMessages(messages);
        }
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        NonOwningMapping mappedByMapping;
        if (this.isJoinTableSpecified()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_WITH_JOIN_TABLE", this.getJoinTable(), this.getJoinTable().getValidationTextRange()));
        }
        if (this.getResolvedTargetEntity() == null) {
            return;
        }
        PersistentAttribute attribute = this.getResolvedTargetEntity().getPersistentType().resolveAttribute(this.getMappedBy());
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.getMappedBy()}, this, this.getMappedByTextRange()));
            return;
        }
        if (!this.mappedByIsValid(attribute.getMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{this.getMappedBy()}, this, this.getMappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (NonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange()));
        }
    }
}

