/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.XmlNamedColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmNamedColumn<T extends XmlNamedColumn>
extends AbstractOrmJpaContextNode
implements OrmNamedColumn {
    protected OrmNamedColumn.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;

    protected AbstractOrmNamedColumn(OrmJpaContextNode parent, OrmNamedColumn.Owner owner) {
        super(parent);
        this.owner = owner;
    }

    @Override
    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    public void initializeFrom(NamedColumn oldColumn) {
        this.setSpecifiedName(oldColumn.getSpecifiedName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }

    protected abstract T getColumnResource();

    protected abstract void removeColumnResource();

    protected abstract void addColumnResource();

    @Override
    public OrmNamedColumn.Owner getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (oldSpecifiedName != newSpecifiedName) {
            if (this.getColumnResource() != null) {
                this.getColumnResource().setName(newSpecifiedName);
                if (this.getColumnResource().isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedName != null) {
                this.addColumnResource();
                this.getColumnResource().setName(newSpecifiedName);
            }
        }
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        if (oldColumnDefinition != newColumnDefinition) {
            if (this.getColumnResource() != null) {
                this.getColumnResource().setColumnDefinition(newColumnDefinition);
                if (this.getColumnResource().isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newColumnDefinition != null) {
                this.addColumnResource();
                this.getColumnResource().setColumnDefinition(newColumnDefinition);
            }
        }
        this.firePropertyChanged("columnDefinitionProperty", oldColumnDefinition, newColumnDefinition);
    }

    protected void setColumnDefinition_(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        this.firePropertyChanged("columnDefinitionProperty", oldColumnDefinition, newColumnDefinition);
    }

    @Override
    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.columnNamed(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.getOwner().getDbTable(this.tableName());
    }

    protected abstract String tableName();

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public TextRange getNameTextRange() {
        TextRange textRange;
        if (this.getColumnResource() != null && (textRange = this.getColumnResource().getNameTextRange()) != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getColumnResource().getValidationTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    protected void initialize(T column) {
        this.specifiedName = this.specifiedName(column);
        this.defaultName = this.defaultName();
        this.columnDefinition = this.specifiedColumnDefinition(column);
    }

    protected void update(T column) {
        this.setSpecifiedName_(this.specifiedName(column));
        this.setDefaultName(this.defaultName());
        this.setColumnDefinition_(this.specifiedColumnDefinition(column));
    }

    protected String specifiedName(T column) {
        return column == null ? null : column.getName();
    }

    protected String specifiedColumnDefinition(T column) {
        return column == null ? null : column.getColumnDefinition();
    }

    protected String defaultName() {
        return this.getOwner().getDefaultColumnName();
    }
}

