/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmAttributeOverride
extends AbstractOrmJpaContextNode
implements OrmAttributeOverride,
OrmColumn.Owner {
    protected String name;
    private final AttributeOverride.Owner owner;
    protected XmlAttributeOverride attributeOverride;
    protected final OrmColumn column;

    public GenericOrmAttributeOverride(OrmJpaContextNode parent, AttributeOverride.Owner owner, XmlAttributeOverride xmlAttributeOverride) {
        super(parent);
        this.owner = owner;
        this.column = this.getJpaFactory().buildOrmColumn(this, this);
        this.initialize(xmlAttributeOverride);
    }

    @Override
    public OrmJpaContextNode getParent() {
        return (OrmJpaContextNode)super.getParent();
    }

    @Override
    public OrmAttributeOverride setVirtual(boolean virtual) {
        return (OrmAttributeOverride)this.getOwner().setVirtual(virtual, this);
    }

    @Override
    public AttributeOverride.Owner getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.attributeOverride.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getOwner().getTypeMapping();
    }

    @Override
    public Table getDbTable(String tablename) {
        return this.getTypeMapping().getDbTable(this.getColumn().getTable());
    }

    @Override
    public String getDefaultColumnName() {
        ColumnMapping columnMapping = this.getColumnMapping();
        if (columnMapping == null) {
            return null;
        }
        return columnMapping.getColumn().getName();
    }

    @Override
    public String getDefaultTableName() {
        ColumnMapping columnMapping = this.getColumnMapping();
        if (columnMapping == null) {
            return null;
        }
        String tableName = columnMapping.getColumn().getSpecifiedTable();
        if (tableName != null) {
            return tableName;
        }
        return this.getOwner().getTypeMapping().getTableName();
    }

    protected ColumnMapping getColumnMapping() {
        return this.getOwner().getColumnMapping(this.getName());
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.attributeOverride.getValidationTextRange();
        return textRange == null ? this.getParent().getValidationTextRange() : textRange;
    }

    @Override
    public XmlColumn getColumnResource() {
        return this.attributeOverride.getColumn();
    }

    @Override
    public void addColumnResource() {
        this.attributeOverride.setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeColumnResource() {
        this.attributeOverride.setColumn(null);
    }

    protected void initialize(XmlAttributeOverride attributeOverride) {
        this.attributeOverride = attributeOverride;
        this.name = attributeOverride.getName();
        this.column.initialize(attributeOverride.getColumn());
    }

    @Override
    public void update(XmlAttributeOverride attributeOverride) {
        this.attributeOverride = attributeOverride;
        this.setName_(attributeOverride.getName());
        this.column.update(attributeOverride.getColumn());
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addColumnMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        OrmColumn column = this.getColumn();
        String table = column.getTable();
        boolean doContinue = this.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), table, column.getName()}, column, column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), column.getName()}, column, column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange()));
            }
        }
    }
}

