/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.core.resource.orm.XmlColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmColumn
extends AbstractOrmBaseColumn<XmlColumn>
implements OrmColumn {
    protected Integer specifiedLength;
    protected Integer specifiedPrecision;
    protected Integer specifiedScale;

    public GenericOrmColumn(OrmJpaContextNode parent, OrmColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public OrmColumn.Owner getOwner() {
        return (OrmColumn.Owner)super.getOwner();
    }

    @Override
    public void initializeFrom(Column oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedLength(oldColumn.getSpecifiedLength());
        this.setSpecifiedPrecision(oldColumn.getSpecifiedPrecision());
        this.setSpecifiedScale(oldColumn.getSpecifiedScale());
    }

    @Override
    public Integer getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength();
    }

    @Override
    public Integer getDefaultLength() {
        return Column.DEFAULT_LENGTH;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        if (oldSpecifiedLength != newSpecifiedLength) {
            if (this.getColumnResource() != null) {
                this.getColumnResource().setLength(newSpecifiedLength);
                if (this.getColumnResource().isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedLength != null) {
                this.addColumnResource();
                this.getColumnResource().setLength(newSpecifiedLength);
            }
        }
        this.firePropertyChanged("spcifiedLengthProperty", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("spcifiedLengthProperty", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    public Integer getPrecision() {
        return this.getSpecifiedPrecision() == null ? this.getDefaultPrecision() : this.getSpecifiedPrecision();
    }

    @Override
    public Integer getDefaultPrecision() {
        return Column.DEFAULT_PRECISION;
    }

    @Override
    public Integer getSpecifiedPrecision() {
        return this.specifiedPrecision;
    }

    @Override
    public void setSpecifiedPrecision(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        if (oldSpecifiedPrecision != newSpecifiedPrecision) {
            if (this.getColumnResource() != null) {
                this.getColumnResource().setPrecision(newSpecifiedPrecision);
                if (this.getColumnResource().isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedPrecision != null) {
                this.addColumnResource();
                this.getColumnResource().setPrecision(newSpecifiedPrecision);
            }
        }
        this.firePropertyChanged("spcifiedPrecisionProperty", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    protected void setSpecifiedPrecision_(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        this.firePropertyChanged("spcifiedPrecisionProperty", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    @Override
    public Integer getScale() {
        return this.getSpecifiedScale() == null ? this.getDefaultScale() : this.getSpecifiedScale();
    }

    @Override
    public Integer getDefaultScale() {
        return Column.DEFAULT_SCALE;
    }

    @Override
    public Integer getSpecifiedScale() {
        return this.specifiedScale;
    }

    @Override
    public void setSpecifiedScale(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        if (oldSpecifiedScale != newSpecifiedScale) {
            if (this.getColumnResource() != null) {
                this.getColumnResource().setScale(newSpecifiedScale);
                if (this.getColumnResource().isAllFeaturesUnset()) {
                    this.removeColumnResource();
                }
            } else if (newSpecifiedScale != null) {
                this.addColumnResource();
                this.getColumnResource().setScale(newSpecifiedScale);
            }
        }
        this.firePropertyChanged("spcifiedScaleProperty", oldSpecifiedScale, newSpecifiedScale);
    }

    protected void setSpecifiedScale_(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        this.firePropertyChanged("spcifiedScaleProperty", oldSpecifiedScale, newSpecifiedScale);
    }

    @Override
    protected XmlColumn getColumnResource() {
        return this.getOwner().getColumnResource();
    }

    @Override
    protected void addColumnResource() {
        this.getOwner().addColumnResource();
    }

    @Override
    protected void removeColumnResource() {
        this.getOwner().removeColumnResource();
    }

    @Override
    public void initialize(XmlColumn column) {
        super.initialize(column);
        this.specifiedLength = this.specifiedLength(column);
        this.specifiedPrecision = this.specifiedPrecision(column);
        this.specifiedScale = this.specifiedScale(column);
    }

    @Override
    public void update(XmlColumn column) {
        super.update(column);
        this.setSpecifiedLength_(this.specifiedLength(column));
        this.setSpecifiedPrecision_(this.specifiedPrecision(column));
        this.setSpecifiedScale_(this.specifiedScale(column));
    }

    protected Integer specifiedLength(XmlColumn column) {
        return column == null ? null : column.getLength();
    }

    protected Integer specifiedPrecision(XmlColumn column) {
        return column == null ? null : column.getPrecision();
    }

    protected Integer specifiedScale(XmlColumn column) {
        return column == null ? null : column.getScale();
    }
}

