/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinTable
extends AbstractOrmTable
implements OrmJoinTable {
    protected final List<OrmJoinColumn> specifiedJoinColumns = new ArrayList<OrmJoinColumn>();
    protected OrmJoinColumn defaultJoinColumn;
    protected final List<OrmJoinColumn> specifiedInverseJoinColumns = new ArrayList<OrmJoinColumn>();
    protected OrmJoinColumn defaultInverseJoinColumn;
    protected XmlRelationshipMapping relationshipMappingResource;
    private boolean doContinue;

    public GenericOrmJoinTable(OrmRelationshipMapping parent) {
        super(parent);
    }

    @Override
    public OrmRelationshipMapping getParent() {
        return (OrmRelationshipMapping)super.getParent();
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getParent();
    }

    @Override
    public void initializeFrom(JoinTable oldJoinTable) {
        OrmJoinColumn newJoinColumn;
        super.initializeFrom(oldJoinTable);
        int index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable((Iterator)oldJoinTable.specifiedJoinColumns())) {
            newJoinColumn = this.addSpecifiedJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
        index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable((Iterator)oldJoinTable.specifiedInverseJoinColumns())) {
            newJoinColumn = this.addSpecifiedInverseJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
    }

    @Override
    protected String defaultCatalog() {
        if (!this.getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return this.getEntityMappings().getCatalog();
    }

    @Override
    protected String defaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationshipMapping());
    }

    @Override
    protected String defaultSchema() {
        if (!this.getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return this.getEntityMappings().getSchema();
    }

    @Override
    protected void removeTableResource() {
        this.relationshipMappingResource.setJoinTable(null);
    }

    @Override
    protected void addTableResource() {
        this.relationshipMappingResource.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTableImpl());
    }

    @Override
    protected XmlJoinTable getTableResource() {
        return this.relationshipMappingResource.getJoinTable();
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn newJoinColumn) {
        OrmJoinColumn oldJoinColumn = this.defaultJoinColumn;
        this.defaultJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", oldJoinColumn, newJoinColumn);
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        if (this.getTableResource() == null) {
            this.addTableResource();
        }
        OrmJoinColumn joinColumn = this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        XmlJoinColumnImpl xmlJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        joinColumn.initialize(xmlJoinColumn);
        this.getTableResource().getJoinColumns().add(index, (Object)xmlJoinColumn);
        this.fireItemAdded("specifiedJoinColumnsList", index, joinColumn);
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.containsSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        this.getTableResource().getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getTableResource().getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmJoinColumn> inverseJoinColumns() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumns() : this.defaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedInverseJoinColumns() {
        return new CloneListIterator(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    protected ListIterator<OrmJoinColumn> defaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultInverseJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    @Override
    public OrmJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmJoinColumn newJoinColumn) {
        OrmJoinColumn oldJoinColumn = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", oldJoinColumn, newJoinColumn);
    }

    @Override
    public boolean containsSpecifiedInverseJoinColumns() {
        return !this.specifiedInverseJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn(int index) {
        if (this.getTableResource() == null) {
            this.addTableResource();
        }
        OrmJoinColumn joinColumn = this.getJpaFactory().buildOrmJoinColumn(this, new InverseJoinColumnOwner());
        this.specifiedInverseJoinColumns.add(index, joinColumn);
        XmlJoinColumnImpl xmlJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        joinColumn.initialize(xmlJoinColumn);
        this.getTableResource().getInverseJoinColumns().add(index, (Object)xmlJoinColumn);
        this.fireItemAdded("specifiedInverseJoinColumnsList", index, joinColumn);
        return joinColumn;
    }

    protected void addSpecifiedInverseJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumnsList");
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedInverseJoinColumns.remove(index);
        if (!this.containsSpecifiedInverseJoinColumns()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
        }
        this.getTableResource().getInverseJoinColumns().remove(index);
        this.fireItemRemoved("specifiedInverseJoinColumnsList", index, removedJoinColumn);
        if (this.defaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
        }
    }

    protected void removeSpecifiedInverseJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumnsList");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedInverseJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getTableResource().getInverseJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedInverseJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean isSpecified() {
        return this.getTableResource() != null && this.getTableResource().isSpecified();
    }

    @Override
    public void initialize(XmlRelationshipMapping relationshipMapping) {
        this.relationshipMappingResource = relationshipMapping;
        this.initialize(this.getTableResource());
    }

    @Override
    public void update(XmlRelationshipMapping relationshipMapping) {
        this.relationshipMappingResource = relationshipMapping;
        this.update(this.getTableResource());
    }

    protected void initialize(XmlJoinTable joinTable) {
        super.initialize(joinTable);
        this.initializeSpecifiedJoinColumns(joinTable);
        this.initializeDefaultJoinColumn();
        this.initializeSpecifiedInverseJoinColumns(joinTable);
        this.initializeDefaultInverseJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns(XmlJoinTable joinTable) {
        if (joinTable == null) {
            return;
        }
        for (XmlJoinColumn joinColumn : joinTable.getJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(joinColumn));
        }
    }

    protected void initializeDefaultJoinColumn() {
        if (!this.shouldBuildDefaultJoinColumn()) {
            return;
        }
        this.defaultJoinColumn = this.buildJoinColumn(null);
    }

    protected void initializeSpecifiedInverseJoinColumns(XmlJoinTable joinTable) {
        if (joinTable == null) {
            return;
        }
        for (XmlJoinColumn joinColumn : joinTable.getInverseJoinColumns()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(joinColumn));
        }
    }

    protected void initializeDefaultInverseJoinColumn() {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            return;
        }
        this.defaultInverseJoinColumn = this.buildInverseJoinColumn(null);
    }

    protected void update(XmlJoinTable joinTable) {
        super.update(joinTable);
        this.updateSpecifiedJoinColumns(joinTable);
        this.updateDefaultJoinColumn();
        this.updateSpecifiedInverseJoinColumns(joinTable);
        this.updateDefaultInverseJoinColumn();
    }

    protected void updateSpecifiedJoinColumns(XmlJoinTable joinTable) {
        ListIterator<OrmJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator resourceJoinColumns = EmptyListIterator.instance();
        if (joinTable != null) {
            resourceJoinColumns = new CloneListIterator(joinTable.getJoinColumns());
        }
        while (joinColumns.hasNext()) {
            OrmJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((XmlJoinColumn)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.specifiedJoinColumnsSize(), this.buildJoinColumn((XmlJoinColumn)resourceJoinColumns.next()));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns();
    }

    protected void updateDefaultJoinColumn() {
        if (!this.shouldBuildDefaultJoinColumn()) {
            this.setDefaultJoinColumn(null);
            return;
        }
        if (this.getDefaultJoinColumn() == null) {
            this.setDefaultJoinColumn(this.buildJoinColumn(null));
        } else {
            this.defaultJoinColumn.update(null);
        }
    }

    protected void updateSpecifiedInverseJoinColumns(XmlJoinTable joinTable) {
        ListIterator<OrmJoinColumn> inverseJoinColumns = this.specifiedInverseJoinColumns();
        ListIterator resourceInverseJoinColumns = EmptyListIterator.instance();
        if (joinTable != null) {
            resourceInverseJoinColumns = new CloneListIterator(joinTable.getInverseJoinColumns());
        }
        while (inverseJoinColumns.hasNext()) {
            OrmJoinColumn joinColumn = inverseJoinColumns.next();
            if (resourceInverseJoinColumns.hasNext()) {
                joinColumn.update((XmlJoinColumn)resourceInverseJoinColumns.next());
                continue;
            }
            this.removeSpecifiedInverseJoinColumn_(joinColumn);
        }
        while (resourceInverseJoinColumns.hasNext()) {
            this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumnsSize(), this.buildInverseJoinColumn((XmlJoinColumn)resourceInverseJoinColumns.next()));
        }
    }

    protected boolean shouldBuildDefaultInverseJoinColumn() {
        return !this.containsSpecifiedInverseJoinColumns();
    }

    protected void updateDefaultInverseJoinColumn() {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            this.setDefaultInverseJoinColumn(null);
            return;
        }
        if (this.getDefaultInverseJoinColumn() == null) {
            this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(null));
        } else {
            this.defaultInverseJoinColumn.update(null);
        }
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn joinColumn) {
        OrmJoinColumn ormJoinColumn = this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner());
        ormJoinColumn.initialize(joinColumn);
        return ormJoinColumn;
    }

    protected OrmJoinColumn buildInverseJoinColumn(XmlJoinColumn joinColumn) {
        OrmJoinColumn ormJoinColumn = this.getJpaFactory().buildOrmJoinColumn(this, new InverseJoinColumnOwner());
        ormJoinColumn.initialize(joinColumn);
        return ormJoinColumn;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addTableMessages(messages);
        if (this.doContinue) {
            for (OrmJoinColumn joinColumn : CollectionTools.iterable(this.joinColumns())) {
                joinColumn.addToMessages(messages);
            }
            for (OrmJoinColumn joinColumn : CollectionTools.iterable(this.inverseJoinColumns())) {
                joinColumn.addToMessages(messages);
            }
        }
    }

    protected void addTableMessages(List<IMessage> messages) {
        this.doContinue = this.connectionProfileIsActive();
        String schema = this.getSchema();
        OrmRelationshipMapping mapping = this.getRelationshipMapping();
        if (this.doContinue && !this.hasResolvedSchema()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{mapping.getName(), schema, this.getName()}, this, this.getSchemaTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.getName()}, this, this.getSchemaTextRange()));
            }
            this.doContinue = false;
        }
        if (this.doContinue && !this.isResolved()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME", new String[]{mapping.getName(), this.getName()}, this, this.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange()));
            }
        }
    }

    abstract class AbstractJoinColumnOwner
    implements OrmJoinColumn.Owner {
        AbstractJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericOrmJoinTable.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return false;
        }

        public boolean tableIsAllowed() {
            return false;
        }

        public Table getDbTable(String tableName) {
            if (GenericOrmJoinTable.this.getName() == null) {
                return null;
            }
            return GenericOrmJoinTable.this.getName().equals(tableName) ? GenericOrmJoinTable.this.getDbTable() : null;
        }

        public String getDefaultTableName() {
            return GenericOrmJoinTable.this.getName();
        }

        public TextRange getValidationTextRange() {
            return GenericOrmJoinTable.this.getValidationTextRange();
        }
    }

    class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getName();
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getDbTable(tableName);
        }

        public Table getDbReferencedColumnTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.inverseJoinColumnsSize();
        }
    }

    class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericOrmJoinTable.this.getRelationshipMapping().getEntity();
        }

        public String getAttributeName() {
            Entity targetEntity = GenericOrmJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            String attributeName = GenericOrmJoinTable.this.getRelationshipMapping().getName();
            Iterator<PersistentAttribute> stream = targetEntity.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                String mappedBy;
                PersistentAttribute attribute = stream.next();
                AttributeMapping mapping = attribute.getMapping();
                if (!(mapping instanceof NonOwningMapping) || (mappedBy = ((NonOwningMapping)mapping).getMappedBy()) == null || !mappedBy.equals(attributeName)) continue;
                return attribute.getName();
            }
            return null;
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getDbReferencedColumnTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinTable.this.joinColumnsSize();
        }
    }
}

