/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmGenerator;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraintImpl;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmTableGenerator
extends AbstractOrmGenerator<XmlTableGenerator>
implements OrmTableGenerator,
UniqueConstraint.Owner {
    protected String specifiedTable;
    protected String defaultTable;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final List<OrmUniqueConstraint> uniqueConstraints = new ArrayList<OrmUniqueConstraint>();

    public GenericOrmTableGenerator(OrmJpaContextNode parent) {
        super(parent);
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        ((XmlTableGenerator)this.getGeneratorResource()).setTable(newSpecifiedTable);
        this.firePropertyChanged("specifiedTableProperty", oldSpecifiedTable, newSpecifiedTable);
    }

    protected void setSpecifiedTable_(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.firePropertyChanged("specifiedTableProperty", oldSpecifiedTable, newSpecifiedTable);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String newDefaultTable) {
        String oldDefaultTable = this.defaultTable;
        this.defaultTable = newDefaultTable;
        this.firePropertyChanged("defaultTableProperty", oldDefaultTable, newDefaultTable);
    }

    @Override
    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        ((XmlTableGenerator)this.getGeneratorResource()).setCatalog(newSpecifiedCatalog);
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    protected void setSpecifiedCatalog_(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalogProperty", oldDefaultCatalog, newDefaultCatalog);
    }

    @Override
    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        ((XmlTableGenerator)this.getGeneratorResource()).setSchema(newSpecifiedSchema);
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchemaProperty", oldDefaultSchema, newDefaultSchema);
    }

    @Override
    public String getPkColumnName() {
        return this.getSpecifiedPkColumnName() == null ? this.getDefaultPkColumnName() : this.getSpecifiedPkColumnName();
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String newSpecifiedPkColumnName) {
        String oldSpecifiedPkColumnName = this.specifiedPkColumnName;
        this.specifiedPkColumnName = newSpecifiedPkColumnName;
        ((XmlTableGenerator)this.getGeneratorResource()).setPkColumnName(newSpecifiedPkColumnName);
        this.firePropertyChanged("specifiedPkColumnNameProperty", oldSpecifiedPkColumnName, newSpecifiedPkColumnName);
    }

    protected void setSpecifiedPkColumnName_(String newSpecifiedPkColumnName) {
        String oldSpecifiedPkColumnName = this.specifiedPkColumnName;
        this.specifiedPkColumnName = newSpecifiedPkColumnName;
        this.firePropertyChanged("specifiedPkColumnNameProperty", oldSpecifiedPkColumnName, newSpecifiedPkColumnName);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    protected void setDefaultPkColumnName(String newDefaultPkColumnName) {
        String oldDefaultPkColumnName = this.defaultPkColumnName;
        this.defaultPkColumnName = newDefaultPkColumnName;
        this.firePropertyChanged("defaultPkColumnNameProperty", oldDefaultPkColumnName, newDefaultPkColumnName);
    }

    @Override
    public String getValueColumnName() {
        return this.getSpecifiedValueColumnName() == null ? this.getDefaultValueColumnName() : this.getSpecifiedValueColumnName();
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String newSpecifiedValueColumnName) {
        String oldSpecifiedValueColumnName = this.specifiedValueColumnName;
        this.specifiedValueColumnName = newSpecifiedValueColumnName;
        ((XmlTableGenerator)this.getGeneratorResource()).setValueColumnName(newSpecifiedValueColumnName);
        this.firePropertyChanged("specifiedValueColumnNameProperty", oldSpecifiedValueColumnName, newSpecifiedValueColumnName);
    }

    protected void setSpecifiedValueColumnName_(String newSpecifiedValueColumnName) {
        String oldSpecifiedValueColumnName = this.specifiedValueColumnName;
        this.specifiedValueColumnName = newSpecifiedValueColumnName;
        this.firePropertyChanged("specifiedValueColumnNameProperty", oldSpecifiedValueColumnName, newSpecifiedValueColumnName);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    protected void setDefaultValueColumnName(String newDefaultValueColumnName) {
        String oldDefaultValueColumnName = this.defaultValueColumnName;
        this.defaultValueColumnName = newDefaultValueColumnName;
        this.firePropertyChanged("defaultValueColumnNameProperty", oldDefaultValueColumnName, newDefaultValueColumnName);
    }

    @Override
    public String getPkColumnValue() {
        return this.getSpecifiedPkColumnValue() == null ? this.getDefaultPkColumnValue() : this.getSpecifiedPkColumnValue();
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String newSpecifiedPkColumnValue) {
        String oldSpecifiedPkColumnValue = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = newSpecifiedPkColumnValue;
        ((XmlTableGenerator)this.getGeneratorResource()).setPkColumnValue(newSpecifiedPkColumnValue);
        this.firePropertyChanged("specifiedPkColummValueProperty", oldSpecifiedPkColumnValue, newSpecifiedPkColumnValue);
    }

    protected void setSpecifiedPkColumnValue_(String newSpecifiedPkColumnValue) {
        String oldSpecifiedPkColumnValue = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = newSpecifiedPkColumnValue;
        this.firePropertyChanged("specifiedPkColummValueProperty", oldSpecifiedPkColumnValue, newSpecifiedPkColumnValue);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    public void setDefaultPkColumnValue(String newDefaultPkColumnValue) {
        String oldDefaultPkColumnValue = this.defaultPkColumnValue;
        this.defaultPkColumnValue = newDefaultPkColumnValue;
        this.firePropertyChanged("defaultPkColummValueProperty", oldDefaultPkColumnValue, newDefaultPkColumnValue);
    }

    @Override
    public ListIterator<OrmUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint(int index) {
        XmlUniqueConstraintImpl uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        OrmUniqueConstraint uniqueConstraint = this.buildUniqueConstraint(uniqueConstraintResource);
        this.uniqueConstraints.add(index, uniqueConstraint);
        ((XmlTableGenerator)this.getGeneratorResource()).getUniqueConstraints().add(index, (Object)uniqueConstraintResource);
        this.fireItemAdded("uniqueConstraintsList", index, uniqueConstraint);
        return uniqueConstraint;
    }

    protected void addUniqueConstraint(int index, OrmUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        OrmUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        ((XmlTableGenerator)this.getGeneratorResource()).getUniqueConstraints().remove(index);
        this.fireItemRemoved("uniqueConstraintsList", index, removedUniqueConstraint);
    }

    protected void removeUniqueConstraint_(OrmUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraintsList");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        ((XmlTableGenerator)this.getGeneratorResource()).getUniqueConstraints().move(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraintsList", targetIndex, sourceIndex);
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        if (dbTable != null) {
            return dbTable.columnNames();
        }
        return EmptyIterator.instance();
    }

    @Override
    public Table getDbTable() {
        Schema schema = this.getDbSchema();
        return schema == null ? null : schema.tableNamed(this.getTable());
    }

    @Override
    public Schema getDbSchema() {
        return this.getDatabase().schemaNamed(this.getSchema());
    }

    @Override
    public void initialize(XmlTableGenerator tableGenerator) {
        super.initialize(tableGenerator);
        this.specifiedTable = this.specifiedTable(tableGenerator);
        this.specifiedCatalog = this.specifiedCatalog(tableGenerator);
        this.defaultCatalog = this.defaultCatalog();
        this.specifiedSchema = this.specifiedSchema(tableGenerator);
        this.defaultSchema = this.defaultSchema();
        this.specifiedPkColumnName = this.specifiedPkColumnName(tableGenerator);
        this.specifiedValueColumnName = this.specifiedValueColumnName(tableGenerator);
        this.specifiedPkColumnValue = this.specifiedPkColumnValue(tableGenerator);
        this.initializeUniqueContraints(tableGenerator);
    }

    protected void initializeUniqueContraints(XmlTableGenerator tableGenerator) {
        if (tableGenerator == null) {
            return;
        }
        for (XmlUniqueConstraint uniqueConstraint : tableGenerator.getUniqueConstraints()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraint));
        }
    }

    @Override
    public void update(XmlTableGenerator tableGenerator) {
        super.update(tableGenerator);
        this.setSpecifiedTable_(this.specifiedTable(tableGenerator));
        this.setSpecifiedCatalog_(this.specifiedCatalog(tableGenerator));
        this.setDefaultCatalog(this.defaultCatalog());
        this.setSpecifiedSchema_(this.specifiedSchema(tableGenerator));
        this.setDefaultSchema(this.defaultSchema());
        this.setSpecifiedPkColumnName_(this.specifiedPkColumnName(tableGenerator));
        this.setSpecifiedValueColumnName_(this.specifiedValueColumnName(tableGenerator));
        this.setSpecifiedPkColumnValue_(this.specifiedPkColumnValue(tableGenerator));
        this.updateUniqueConstraints(tableGenerator);
    }

    protected String specifiedTable(XmlTableGenerator tableGenerator) {
        return tableGenerator.getTable();
    }

    protected String specifiedCatalog(XmlTableGenerator tableGenerator) {
        return tableGenerator.getCatalog();
    }

    protected String specifiedSchema(XmlTableGenerator tableGenerator) {
        return tableGenerator.getSchema();
    }

    protected String specifiedPkColumnName(XmlTableGenerator tableGenerator) {
        return tableGenerator.getPkColumnName();
    }

    protected String specifiedValueColumnName(XmlTableGenerator tableGenerator) {
        return tableGenerator.getValueColumnName();
    }

    protected String specifiedPkColumnValue(XmlTableGenerator tableGenerator) {
        return tableGenerator.getPkColumnValue();
    }

    protected String defaultSchema() {
        return this.getEntityMappings().getSchema();
    }

    protected String defaultCatalog() {
        return this.getEntityMappings().getCatalog();
    }

    protected void updateUniqueConstraints(XmlTableGenerator tableGenerator) {
        ListIterator<OrmUniqueConstraint> uniqueConstraints = this.uniqueConstraints();
        ListIterator resourceUniqueConstraints = tableGenerator == null ? EmptyListIterator.instance() : new CloneListIterator(tableGenerator.getUniqueConstraints());
        while (uniqueConstraints.hasNext()) {
            OrmUniqueConstraint uniqueConstraint = uniqueConstraints.next();
            if (resourceUniqueConstraints.hasNext()) {
                uniqueConstraint.update((XmlUniqueConstraint)resourceUniqueConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(uniqueConstraint);
        }
        while (resourceUniqueConstraints.hasNext()) {
            this.addUniqueConstraint(this.uniqueConstraintsSize(), this.buildUniqueConstraint((XmlUniqueConstraint)resourceUniqueConstraints.next()));
        }
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint xmlUniqueConstraint) {
        return this.getJpaFactory().buildOrmUniqueConstraint(this, this, xmlUniqueConstraint);
    }
}

