/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmUniqueConstraint
extends AbstractOrmJpaContextNode
implements OrmUniqueConstraint {
    protected final List<String> columnNames;
    protected XmlUniqueConstraint uniqueConstraint;
    protected UniqueConstraint.Owner owner;

    public GenericOrmUniqueConstraint(OrmJpaContextNode parent, UniqueConstraint.Owner owner, XmlUniqueConstraint uniqueConstraint) {
        super(parent);
        this.owner = owner;
        this.columnNames = new ArrayList<String>();
        this.initialize(uniqueConstraint);
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.uniqueConstraint.getColumnNames().add(index, (Object)columnName);
        this.fireItemAdded("columnNamesList", index, columnName);
    }

    protected void addColumnName_(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.fireItemAdded("columnNamesList", index, columnName);
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.uniqueConstraint.getColumnNames().remove(index);
        this.fireItemRemoved("columnNamesList", index, removedColumnName);
    }

    protected void removeColumnName_(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.fireItemRemoved("columnNamesList", index, removedColumnName);
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.uniqueConstraint.getColumnNames().move(targetIndex, sourceIndex);
        this.fireItemMoved("columnNamesList", targetIndex, sourceIndex);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.uniqueConstraint.getValidationTextRange();
    }

    protected void initialize(XmlUniqueConstraint uniqueConstraint) {
        this.uniqueConstraint = uniqueConstraint;
        this.initializeColumnNames(uniqueConstraint);
    }

    protected void initializeColumnNames(XmlUniqueConstraint uniqueConstraint) {
        CloneListIterator xmlColumnNames = new CloneListIterator(uniqueConstraint.getColumnNames());
        for (String annotationColumnName : CollectionTools.iterable((Iterator)xmlColumnNames)) {
            this.columnNames.add(annotationColumnName);
        }
    }

    @Override
    public void update(XmlUniqueConstraint uniqueConstraint) {
        this.uniqueConstraint = uniqueConstraint;
        this.updateColumnNames(uniqueConstraint);
    }

    protected void updateColumnNames(XmlUniqueConstraint uniqueConstraint) {
        CloneListIterator xmlColumnNames = new CloneListIterator(uniqueConstraint.getColumnNames());
        int index = 0;
        for (String xmlColumnName : CollectionTools.iterable((Iterator)xmlColumnNames)) {
            if (this.columnNamesSize() > index) {
                if (this.columnNames.get(index) != xmlColumnName) {
                    this.addColumnName_(index, xmlColumnName);
                }
            } else {
                this.addColumnName_(index, xmlColumnName);
            }
            ++index;
        }
        while (index < this.columnNamesSize()) {
            this.removeColumnName_(index);
        }
    }
}

