/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NamedColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedColumn
extends AbstractResourceAnnotation<Member>
implements NamedColumnAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildStringElementAdapter(this.nameElementName());
    private final DeclarationAnnotationElementAdapter<String> columnDefinitionDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter = this.buildShortCircuitElementAdapter(this.nameDeclarationAdapter);
    private final AnnotationElementAdapter<String> columnDefinitionAdapter;
    private String name;
    private String columnDefinition;

    public AbstractNamedColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.columnDefinitionDeclarationAdapter = this.buildStringElementAdapter(this.columnDefinitionElementName());
        this.columnDefinitionAdapter = this.buildShortCircuitElementAdapter(this.columnDefinitionDeclarationAdapter);
    }

    protected DeclarationAnnotationElementAdapter<String> buildStringElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(this.getDeclarationAnnotationAdapter(), elementName);
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildBooleanElementAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(this.getDeclarationAnnotationAdapter(), elementName, BooleanExpressionConverter.instance());
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildIntegerElementAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(this.getDeclarationAnnotationAdapter(), elementName, NumberIntegerExpressionConverter.instance());
    }

    protected AnnotationElementAdapter<String> buildShortCircuitElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), daea);
    }

    protected AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new ShortCircuitAnnotationElementAdapter<Boolean>((Member)this.getMember(), daea);
    }

    protected AnnotationElementAdapter<Integer> buildShortCircuitIntegerElementAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new ShortCircuitAnnotationElementAdapter<Integer>((Member)this.getMember(), daea);
    }

    protected AnnotationElementAdapter<String> buildShortCircuitStringElementAdapter(String elementName) {
        return this.buildShortCircuitElementAdapter(this.buildStringElementAdapter(elementName));
    }

    protected abstract String nameElementName();

    protected abstract String columnDefinitionElementName();

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.columnDefinition = this.columnDefinition(astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        NamedColumnAnnotation oldColumn = (NamedColumnAnnotation)((Object)oldAnnotation);
        this.setName(oldColumn.getName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String newColumnDefinition) {
        if (this.attributeValueHasNotChanged(this.columnDefinition, newColumnDefinition)) {
            return;
        }
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        this.columnDefinitionAdapter.setValue(newColumnDefinition);
        this.firePropertyChanged("columnDefinitionPropety", oldColumnDefinition, newColumnDefinition);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getColumnDefinitionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.columnDefinitionDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setColumnDefinition(this.columnDefinition(astRoot));
    }

    protected String name(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    protected String columnDefinition(CompilationUnit astRoot) {
        return this.columnDefinitionAdapter.getValue(astRoot);
    }
}

