/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.BaseColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.NullColumn;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public class ColumnImpl
extends BaseColumnImpl
implements ColumnAnnotation,
NestableAnnotation {
    public static final DeclarationAnnotationAdapter MAPPING_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Column");
    private final DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildIntegerElementAdapter("length");
    private final DeclarationAnnotationElementAdapter<Integer> precisionDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<Integer> scaleDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> lengthAdapter = this.buildShortCircuitIntegerElementAdapter(this.lengthDeclarationAdapter);
    private final AnnotationElementAdapter<Integer> precisionAdapter;
    private final AnnotationElementAdapter<Integer> scaleAdapter;
    private Integer length;
    private Integer precision;
    private Integer scale;

    protected ColumnImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
        this.precisionDeclarationAdapter = this.buildIntegerElementAdapter("precision");
        this.precisionAdapter = this.buildShortCircuitIntegerElementAdapter(this.precisionDeclarationAdapter);
        this.scaleDeclarationAdapter = this.buildIntegerElementAdapter("scale");
        this.scaleAdapter = this.buildShortCircuitIntegerElementAdapter(this.scaleDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.length = this.length(astRoot);
        this.precision = this.precision(astRoot);
        this.scale = this.scale(astRoot);
    }

    protected String nameElementName() {
        return "name";
    }

    protected String columnDefinitionElementName() {
        return "columnDefinition";
    }

    protected String tableElementName() {
        return "table";
    }

    protected String uniqueElementName() {
        return "unique";
    }

    protected String nullableElementName() {
        return "nullable";
    }

    protected String insertableElementName() {
        return "insertable";
    }

    protected String updatableElementName() {
        return "updatable";
    }

    public String getAnnotationName() {
        return "javax.persistence.Column";
    }

    public void moveAnnotation(int newIndex) {
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        ColumnAnnotation oldColumn = (ColumnAnnotation)((Object)oldAnnotation);
        this.setLength(oldColumn.getLength());
        this.setPrecision(oldColumn.getPrecision());
        this.setScale(oldColumn.getScale());
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer newLength) {
        if (this.attributeValueHasNotChanged(this.length, newLength)) {
            return;
        }
        Integer oldLength = this.length;
        this.length = newLength;
        this.lengthAdapter.setValue(newLength);
        this.firePropertyChanged("lengthProperty", oldLength, newLength);
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer newPrecision) {
        if (this.attributeValueHasNotChanged(this.precision, newPrecision)) {
            return;
        }
        Integer oldPrecision = this.precision;
        this.precision = newPrecision;
        this.precisionAdapter.setValue(newPrecision);
        this.firePropertyChanged("precisionProperty", oldPrecision, newPrecision);
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer newScale) {
        if (this.attributeValueHasNotChanged(this.scale, newScale)) {
            return;
        }
        Integer oldScale = this.scale;
        this.scale = newScale;
        this.scaleAdapter.setValue(newScale);
        this.firePropertyChanged("scaleProperty", oldScale, newScale);
    }

    public TextRange getLengthTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.lengthDeclarationAdapter, astRoot);
    }

    public TextRange getPrecisionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.precisionDeclarationAdapter, astRoot);
    }

    public TextRange getScaleTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.scaleDeclarationAdapter, astRoot);
    }

    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setLength(this.length(astRoot));
        this.setPrecision(this.precision(astRoot));
        this.setScale(this.scale(astRoot));
    }

    protected Integer length(CompilationUnit astRoot) {
        return this.lengthAdapter.getValue(astRoot);
    }

    protected Integer precision(CompilationUnit astRoot) {
        return this.precisionAdapter.getValue(astRoot);
    }

    protected Integer scale(CompilationUnit astRoot) {
        return this.scaleAdapter.getValue(astRoot);
    }

    static ColumnImpl createAttributeOverrideColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return new ColumnImpl(parent, member, ColumnImpl.buildAttributeOverrideAnnotationAdapter(attributeOverrideAnnotationAdapter));
    }

    static DeclarationAnnotationAdapter buildAttributeOverrideAnnotationAdapter(DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(attributeOverrideAnnotationAdapter, "column", "javax.persistence.Column");
    }

    public static class ColumnAnnotationDefinition
    implements AnnotationDefinition {
        private static final ColumnAnnotationDefinition INSTANCE = new ColumnAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private ColumnAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ColumnImpl((JavaResourceNode)parent, member, MAPPING_DECLARATION_ANNOTATION_ADAPTER);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullColumn(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.Column";
        }
    }
}

